package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;

public enum ActorType implements Classification<ActorType> {

	/** A sentient being */
	NPC,
	/** A creature, neither good nor bad */
	ANIMAL,
	/** A creature that clearly is a foe */
	MONSTER
	;

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.classification.Classification#getType()
	 */
	@Override
	public ClassificationType getType() {
		return GenericClassificationType.ROLE;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.classification.Classification#getValue()
	 */
	@Override
	public ActorType getValue() {
		return this;
	}

}