package de.rpgframework.random;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;

/**
 * @author prelle
 *
 */
public interface RandomGenerator {

	//-------------------------------------------------------------------
	public static boolean contains(List<Classification<?>> list, ClassificationType type) {
		return list.stream().anyMatch(e -> e.getType()==type);
	}

	//-------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static <T> T getValueOf(List<Classification<?>> list, ClassificationType type) {
		for (Classification<?> cls : list) {
			if (cls.getType()==type)
				return (T)cls.getValue();
		}
		return null;
	}

	//-------------------------------------------------------------------
	public GeneratorType getType();

	//-------------------------------------------------------------------
	public Collection<ClassificationType> getRequiredVariables();

	//-------------------------------------------------------------------
	public boolean matchesFilter(Classification<?> filter);

	//-------------------------------------------------------------------
	public boolean understandsHint(Classification<?> filter);

	//-------------------------------------------------------------------
	/**
	 * @param classifier
	 * @return Generated objected
	 */
	public Object generate(Map<GeneratorVariable,Integer> variables, Classification<?>...classifier);

}
