package de.rpgframework.random;

import java.lang.System.Logger;
import java.lang.System.Logger.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.prelle.simplepersist.ElementList;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;

public class VariableHolderNode {

	private final static Logger logger = System.getLogger("rpgframework.random");

	/**
	 * Defines general context information for a generator, like
	 * genre, type of location ...
	 */
	private Map<ClassificationType, Classification<?>> tags;
//	@Element
	private Map<GeneratorVariable, Integer> modifiers;
//	@Element
	private Map<GeneratorVariable, Object> variables;

	@ElementList(entry="line", type=TextLine.class)
	private List<TextLine> lines;

	//-------------------------------------------------------------------
	public VariableHolderNode() {
		modifiers = new HashMap<>();
		variables = new HashMap<GeneratorVariable, Object>();
		lines = new ArrayList<>();
		tags = new HashMap<>();
	}

	//-------------------------------------------------------------------
	public void setHint(Classification<?> value) {
		tags.put(value.getType(), value);
	}

	//-------------------------------------------------------------------
	public Collection<Classification<?>> getHints() {
		return tags.values();
	}

	//-------------------------------------------------------------------
	public void copyHints(VariableHolderNode node) {
		for (Entry<ClassificationType, Classification<?>> tmp : node.tags.entrySet()) {
			tags.put(tmp.getKey(), tmp.getValue());
		}
	}

	//-------------------------------------------------------------------
	public void addVariable(GeneratorVariable modifier, int value) {
		if (modifier==null)
			throw new NullPointerException("modifier");
		Integer old = modifiers.get(modifier);
		if (old==null) {
			modifiers.put(modifier, value);
		} else {
			modifiers.put(modifier, old+value);
		}
	}

	//-------------------------------------------------------------------
	public int getVariable(GeneratorVariable modifier) {
		if (modifiers.containsKey(modifier))
			return modifiers.get(modifier);
		return 0;
	}

	//-------------------------------------------------------------------
	public Map<GeneratorVariable,Integer> getVariables() {
		return modifiers;
	}

	//-------------------------------------------------------------------
	public  Map<GeneratorVariable, Object> getGenericVariables() {
		return variables;
	}

	//-------------------------------------------------------------------
	public void setVariable(GeneratorVariable key, String value) {
		if (key.isList()) {
			List<String> prev = (List<String>) variables.getOrDefault(key, new ArrayList<String>());
			prev.add(value);
			variables.put(key, prev);
		} else {
			variables.put(key, value);
		}
		logger.log(Level.DEBUG, "Variable {0} of {1} now {2}", key, this, variables.get(key));
	}

	//-------------------------------------------------------------------
	public Object getGenericVariable(GeneratorVariable key) {
		return variables.get(key);
	}

	//-------------------------------------------------------------------
	/**
	 * @return the lines
	 */
	public List<TextLine> getLines() {
		return lines;
	}

	//-------------------------------------------------------------------
	/**
	 * @param lines the lines to set
	 */
	public void addLine(TextLine line) {
		this.lines.add(line);
	}

}