package de.rpgframework.random.withoutnumber;

import java.io.InputStream;
import java.lang.System.Logger;
import java.lang.System.Logger.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.classification.Genre;
import de.rpgframework.random.Actor;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.RollTable;
import de.rpgframework.random.RollTableGenerator;

/**
 *
 */
public class SWNNPCGenerator extends RollTableGenerator implements RandomGenerator {

	private final static Logger logger = System.getLogger(SWNNPCGenerator.class.getPackageName());

	private List<Classification<?>> classifications = new ArrayList<>();

	//-------------------------------------------------------------------
	/**
	 * @param res
	 */
	public SWNNPCGenerator(MultiLanguageResourceBundle res, String prefix, Genre genre) {
		super(res);
		classifications.add(genre);
		String key = prefix+"_npc_tables.xml";
		logger.log(Level.INFO, "Try load "+key);
		InputStream ins = getClass().getResourceAsStream(key);
		super.loadTables(ins);
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#getType()
	 */
	@Override
	public GeneratorType getType() {
		return GeneratorType.NSC;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#getRequiredVariables()
	 */
	@Override
	public Collection<ClassificationType> getRequiredVariables() {
		return List.of(GenericClassificationType.GENRE);
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#matchesFilter(de.rpgframework.classification.Classification)
	 */
	@Override
	public boolean matchesFilter(Classification<?> filter) {
		if (filter==Genre.CYBERPUNK) return true;
		return false;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#understandsHint(de.rpgframework.classification.Classification)
	 */
	@Override
	public boolean understandsHint(Classification<?> filter) {
		return false;
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RandomGenerator#generate(java.util.Map, de.rpgframework.classification.Classification[])
	 */
	@Override
	public Object generate(Map<GeneratorVariable, Integer> variables, Classification<?>... classifier) {
		logger.log(Level.INFO, "ENTER: generate()");
		logger.log(Level.INFO, "variables = "+variables);
		logger.log(Level.INFO, "classifier = "+Arrays.toString(classifier));

		Actor plot = new Actor();
		for (Classification<?> tmp : classifier) plot.setHint(tmp);
		try {
			RollTable table = tables.get(WithoutNumberVariable.NPC_STRENGTH.name());
			logger.log(Level.DEBUG,"Roll with classifier "+plot.getHints());
			super.simpleRoll(table, plot, Locale.getDefault());

			return plot;
		} finally {
			logger.log(Level.DEBUG, "LEAVE: generate");
		}
	}

	//-------------------------------------------------------------------
	/**
	 * @see de.rpgframework.random.RollTableGenerator#resolveModifier(java.lang.String)
	 */
	@Override
	protected GeneratorVariable resolveModifier(String name) {
		return WithoutNumberVariable.valueOf(name);
	}

}
