/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface RandomGenerator {
    public static boolean contains(List<Classification<?>> list, ClassificationType type) {
        return list.stream().anyMatch(e -> e.getType() == type);
    }

    public static <T> T getValueOf(List<Classification<?>> list, ClassificationType type) {
        for (Classification<?> cls : list) {
            if (cls.getType() != type) continue;
            return (T)cls.getValue();
        }
        return null;
    }

    public GeneratorType getType();

    public Collection<ClassificationType> getRequiredVariables();

    public boolean matchesFilter(Classification<?> var1);

    public boolean understandsHint(Classification<?> var1);

    public Object generate(Map<GeneratorVariable, Integer> var1, Classification<?> ... var2);
}

