/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.TextLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.prelle.simplepersist.ElementList;

public class VariableHolderNode {
    private static final System.Logger logger = System.getLogger("rpgframework.random");
    private Map<ClassificationType, Classification<?>> tags;
    private Map<GeneratorVariable, Integer> modifiers = new HashMap<GeneratorVariable, Integer>();
    private Map<GeneratorVariable, Object> variables = new HashMap<GeneratorVariable, Object>();
    @ElementList(entry="line", type=TextLine.class)
    private List<TextLine> lines = new ArrayList<TextLine>();

    public VariableHolderNode() {
        this.tags = new HashMap();
    }

    public void setHint(Classification<?> value) {
        this.tags.put(value.getType(), value);
    }

    public Collection<Classification<?>> getHints() {
        return this.tags.values();
    }

    public void copyHints(VariableHolderNode node) {
        for (Map.Entry<ClassificationType, Classification<?>> tmp : node.tags.entrySet()) {
            this.tags.put(tmp.getKey(), tmp.getValue());
        }
    }

    public void addVariable(GeneratorVariable modifier, int value) {
        if (modifier == null) {
            throw new NullPointerException("modifier");
        }
        Integer old = this.modifiers.get(modifier);
        if (old == null) {
            this.modifiers.put(modifier, value);
        } else {
            this.modifiers.put(modifier, old + value);
        }
    }

    public int getVariable(GeneratorVariable modifier) {
        if (this.modifiers.containsKey(modifier)) {
            return this.modifiers.get(modifier);
        }
        return 0;
    }

    public Map<GeneratorVariable, Integer> getVariables() {
        return this.modifiers;
    }

    public Map<GeneratorVariable, Object> getGenericVariables() {
        return this.variables;
    }

    public void setVariable(GeneratorVariable key, String value) {
        if (key.isList()) {
            List prev = this.variables.getOrDefault(key, new ArrayList());
            prev.add(value);
            this.variables.put(key, prev);
        } else {
            this.variables.put(key, value);
        }
        logger.log(System.Logger.Level.DEBUG, "Variable {0} of {1} now {2}", key, this, this.variables.get(key));
    }

    public Object getGenericVariable(GeneratorVariable key) {
        return this.variables.get(key);
    }

    public List<TextLine> getLines() {
        return this.lines;
    }

    public void addLine(TextLine line) {
        this.lines.add(line);
    }
}

