/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random.withoutnumber;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.classification.Genre;
import de.rpgframework.random.Actor;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.RollTable;
import de.rpgframework.random.RollTableGenerator;
import de.rpgframework.random.withoutnumber.WithoutNumberVariable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SWNNPCGenerator
extends RollTableGenerator
implements RandomGenerator {
    private static final System.Logger logger = System.getLogger(SWNNPCGenerator.class.getPackageName());
    private List<Classification<?>> classifications = new ArrayList();

    public SWNNPCGenerator(MultiLanguageResourceBundle res, String prefix, Genre genre) {
        super(res);
        this.classifications.add((Classification<?>)genre);
        String key = prefix + "_npc_tables.xml";
        logger.log(System.Logger.Level.INFO, "Try load " + key);
        InputStream ins = this.getClass().getResourceAsStream(key);
        super.loadTables(ins);
    }

    @Override
    public GeneratorType getType() {
        return GeneratorType.NSC;
    }

    @Override
    public Collection<ClassificationType> getRequiredVariables() {
        return List.of(GenericClassificationType.GENRE);
    }

    @Override
    public boolean matchesFilter(Classification<?> filter) {
        return filter == Genre.CYBERPUNK;
    }

    @Override
    public boolean understandsHint(Classification<?> filter) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object generate(Map<GeneratorVariable, Integer> variables, Classification<?> ... classifier) {
        logger.log(System.Logger.Level.INFO, "ENTER: generate()");
        logger.log(System.Logger.Level.INFO, "variables = " + String.valueOf(variables));
        logger.log(System.Logger.Level.INFO, "classifier = " + Arrays.toString(classifier));
        Actor plot = new Actor();
        for (Classification<?> tmp : classifier) {
            plot.setHint(tmp);
        }
        try {
            RollTable table = (RollTable)this.tables.get(WithoutNumberVariable.NPC_STRENGTH.name());
            logger.log(System.Logger.Level.DEBUG, "Roll with classifier " + String.valueOf(plot.getHints()));
            super.simpleRoll(table, plot, Locale.getDefault());
            Actor actor = plot;
            return actor;
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: generate");
        }
    }

    @Override
    protected GeneratorVariable resolveModifier(String name) {
        return WithoutNumberVariable.valueOf(name);
    }
}

