/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.ActorRole;
import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.Gender;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.random.Actor;
import de.rpgframework.random.DataType;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.VariableHolderNode;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class NSCGenerator
implements RandomGenerator {
    private static final System.Logger logger = System.getLogger("rpgframework.random");
    public static final Random RANDOM = new Random();

    @Override
    public String getId() {
        return "GenericNSC";
    }

    @Override
    public GeneratorType getType() {
        return GeneratorType.NSC;
    }

    @Override
    public boolean matchesFilter(Classification<?> filter) {
        return false;
    }

    @Override
    public boolean understandsHint(ClassificationType filter) {
        return filter == GenericClassificationType.ACTOR_ROLE;
    }

    protected Classification<?> getHint(ClassificationType needle, Collection<Classification<?>> haystack) {
        for (Classification<?> tmp : haystack) {
            if (tmp.getType() != needle) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public Object generate(VariableHolderNode context) {
        logger.log(System.Logger.Level.INFO, "ENTER: createNSC(" + context.getHints() + ")");
        VariableHolderNode newContext = new VariableHolderNode(context);
        Gender gender = null;
        Classification<?> cls = this.getHint(GenericClassificationType.GENDER, newContext.getHints());
        if (cls != null) {
            gender = Gender.valueOf((String)((String)cls.getValue()));
        } else {
            gender = switch (RANDOM.nextInt(20)) {
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> Gender.MALE;
                case 11, 12, 13, 14, 15, 16, 17, 18, 19 -> Gender.FEMALE;
                default -> Gender.DIVERSE;
            };
            newContext.setHint((Classification<?>)gender);
        }
        logger.log(System.Logger.Level.INFO, "Gender is {0}", gender);
        logger.log(System.Logger.Level.DEBUG, "Call NAME_PERSON generator");
        RandomGenerator generator = RandomGenerator.builder().thatGenerates(GeneratorType.NAME_PERSON).optionallySupportsHints(newContext.getHints().stream().map(h -> h.getType()).toList()).build();
        String name = (String)generator.generate(newContext);
        ActorRole role = ActorRole.UNDEFINED;
        if (RandomGenerator.contains(newContext.getHints(), GenericClassificationType.ACTOR_ROLE)) {
            role = (ActorRole)RandomGenerator.getValueOf(newContext.getHints(), GenericClassificationType.ACTOR_ROLE);
        }
        Actor actor = new Actor(role, name);
        actor.copyHints(newContext);
        actor.setGender(gender);
        for (Classification<?> cls2 : context.getHints()) {
            if (!cls2.getType().isRuleSpecific()) continue;
            actor.setHint(cls2);
        }
        logger.log(System.Logger.Level.INFO, "LEAVE createNSC()=" + actor);
        return actor;
    }

    @Override
    public Collection<ClassificationType> getRequiredVariables() {
        return List.of();
    }

    @Override
    public Collection<DataType> getProvidedData() {
        return List.of(DataType.ACTOR_BASEDATA);
    }
}

