/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.random.Actor;
import de.rpgframework.random.VariableHolderNode;
import java.util.ArrayList;
import java.util.List;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.ElementList;

public class PlotNode
extends VariableHolderNode {
    @Attribute
    private Type type;
    @Attribute
    private String i18n;
    @ElementList(entry="actor", type=Actor.class)
    private List<Actor> actors;
    private List<Object> locations;
    private PlotNode parent;
    @ElementList(entry="section", type=PlotNode.class, inline=true)
    private List<PlotNode> children;

    public PlotNode(Type type) {
        this.type = type;
        this.actors = new ArrayList<Actor>();
        this.children = new ArrayList<PlotNode>();
    }

    public Type getType() {
        return this.type;
    }

    public void addNode(PlotNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public List<PlotNode> getChildNodes() {
        return this.children;
    }

    public PlotNode getNode(Type type) {
        for (PlotNode tmp : this.children) {
            if (tmp.getType() != type) continue;
            return tmp;
        }
        return null;
    }

    public PlotNode getParent() {
        return this.parent;
    }

    public void setParent(PlotNode parent) {
        this.parent = parent;
    }

    public String getI18n() {
        return this.i18n;
    }

    public void setI18n(String i18n) {
        this.i18n = i18n;
    }

    public void addActor(Actor value) {
        this.actors.add(value);
    }

    public List<Actor> getActors() {
        ArrayList<Actor> ret = new ArrayList<Actor>(this.actors);
        for (PlotNode child : this.children) {
            ret.addAll(child.getActors());
        }
        return ret;
    }

    public static enum Type {
        STORY,
        EXPOSITION,
        RISE,
        CRISIS,
        FALL,
        CONCLUSION,
        OPTIONAL,
        REWARD;

    }
}

