/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.Taxonomy;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.random.GeneratorInitializer;
import de.rpgframework.random.GeneratorReference;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.VariableHolderNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.prelle.simplepersist.Persister;

public class RandomGeneratorRegistry {
    private static final System.Logger logger = System.getLogger(RandomGeneratorRegistry.class.getPackageName());
    private static Map<GeneratorType, List<RandomGenerator>> knownByType = new HashMap<GeneratorType, List<RandomGenerator>>();

    public static void initialize() {
        Persister.putContext((String)("org.prelle.simplepersist.interfaceconverter." + ModifiedObjectType.class.getName()), GeneratorReference.class);
        ServiceLoader.load(GeneratorInitializer.class).forEach(init -> {
            logger.log(System.Logger.Level.DEBUG, "Initializing " + init.getClass());
            init.getGeneratorsToRegister().forEach(gen -> RandomGeneratorRegistry.register(gen));
        });
    }

    public static void register(RandomGenerator gen) {
        logger.log(System.Logger.Level.WARNING, "register {0} as {1}", new Object[]{gen.getClass().getSimpleName(), gen.getType()});
        List<RandomGenerator> addTo = knownByType.get((Object)gen.getType());
        if (addTo == null) {
            addTo = new ArrayList<RandomGenerator>();
            knownByType.put(gen.getType(), addTo);
        }
        logger.log(System.Logger.Level.INFO, "Registered " + gen.getClass() + " as " + gen.getType() + " generator");
        addTo.add(gen);
    }

    public static RandomGenerator findGenerator(GeneratorType type, List<Classification<?>> requires, List<ClassificationType> hints) {
        logger.log(System.Logger.Level.DEBUG, "Requires: " + requires);
        logger.log(System.Logger.Level.DEBUG, "hints: " + hints);
        List<RandomGenerator> possible = RandomGeneratorRegistry.findGenerators(type, requires, hints);
        RandomGenerator gen = possible.get(0);
        logger.log(System.Logger.Level.INFO, "Use generator " + gen.getClass() + " for " + type);
        return gen;
    }

    public static List<RandomGenerator> findGenerators(GeneratorType type, List<Classification<?>> requires, final List<ClassificationType> hints) {
        logger.log(System.Logger.Level.WARNING, "Known generator types: " + knownByType.keySet());
        List<RandomGenerator> possible = knownByType.get((Object)type);
        if (possible == null) {
            logger.log(System.Logger.Level.WARNING, "No generators for type " + type);
            return null;
        }
        logger.log(System.Logger.Level.DEBUG, "We have {0} generators for {1}", new Object[]{possible.size(), type});
        if (possible.isEmpty()) {
            throw new NoSuchElementException("No generator support for " + type);
        }
        possible = possible.stream().filter(gen -> requires.stream().allMatch(cls -> gen.matchesFilter((Classification<?>)cls))).collect(Collectors.toList());
        logger.log(System.Logger.Level.DEBUG, "After following requirements {0} this is down to {1}", requires, possible.size());
        if (possible.isEmpty()) {
            throw new NoSuchElementException("With this requirements there is no generator available");
        }
        for (RandomGenerator opt : possible) {
            logger.log(System.Logger.Level.DEBUG, "--> {0} providing {1}", opt.getClass().getSimpleName(), opt.getProvidedData());
        }
        Collections.sort(possible, new Comparator<RandomGenerator>(){

            @Override
            public int compare(RandomGenerator gen1, RandomGenerator gen2) {
                long count2;
                long count1 = hints.stream().filter(cls -> gen1.understandsHint((ClassificationType)cls)).count();
                int cmp = -Long.compare(count1, count2 = hints.stream().filter(cls -> gen2.understandsHint((ClassificationType)cls)).count());
                if (cmp != 0) {
                    return cmp;
                }
                return -Integer.compare(gen1.getProvidedData().size(), gen2.getProvidedData().size());
            }
        });
        return possible;
    }

    public static Object generate(GeneratorType type, List<Classification<?>> requires, List<Classification<?>> hints, Map<GeneratorVariable, Integer> variables) {
        List<ClassificationType> optionalHints = hints.stream().map(cl -> cl.getType()).toList();
        RandomGenerator gen = RandomGeneratorRegistry.findGenerator(type, requires, optionalHints);
        ArrayList merged = new ArrayList(requires);
        merged.addAll(hints);
        logger.log(System.Logger.Level.DEBUG, "Hints: " + merged);
        logger.log(System.Logger.Level.DEBUG, "Variables: " + variables);
        VariableHolderNode context = new VariableHolderNode().withVariables(variables).withHints(merged);
        return gen.generate(context);
    }

    public static Collection<GeneratorType> getSupportedTypes() {
        return knownByType.keySet();
    }

    public static List<RandomGenerator> getGenerators(GeneratorType type) {
        return knownByType.get((Object)type);
    }

    static {
        new Taxonomy();
    }
}

