/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.random.AddNodeInstruction;
import de.rpgframework.random.RollResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Element;
import org.prelle.simplepersist.ElementList;
import org.prelle.simplepersist.Root;

@Root(name="rollTable")
public class RollTable {
    @Attribute(required=true)
    protected String id;
    @Attribute
    protected int d6;
    @Attribute
    protected int d20;
    @Attribute
    protected int d00;
    @Attribute
    protected String modifiers;
    @Attribute
    protected int draw = 1;
    @Attribute
    protected String nextTable;
    @Element
    private AddNodeInstruction addNode;
    @ElementList(entry="rollResult", type=RollResult.class, inline=true)
    private List<RollResult> results = new ArrayList<RollResult>();

    public RollResult getResultFor(int value) {
        ArrayList<RollResult> options = new ArrayList<RollResult>();
        for (RollResult result : this.results) {
            if (!result.isInRange(value)) continue;
            options.add(result);
        }
        switch (options.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (RollResult)((Object)options.get(0));
            }
        }
        return (RollResult)((Object)options.get(new Random().nextInt(options.size())));
    }

    public String getId() {
        return this.id;
    }

    public int getD6() {
        return this.d6;
    }

    public Collection<String> getModifierNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.modifiers != null) {
            StringTokenizer tok = new StringTokenizer(this.modifiers, ",");
            while (tok.hasMoreTokens()) {
                ret.add(tok.nextToken().trim());
            }
        }
        return ret;
    }

    public List<RollResult> getResults() {
        return this.results;
    }

    public String getNextTable() {
        return this.nextTable;
    }

    public AddNodeInstruction getAddNode() {
        return this.addNode;
    }
}

