/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random.withoutnumber;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.classification.ActorRole;
import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.classification.Genre;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.GenericCore;
import de.rpgframework.random.Actor;
import de.rpgframework.random.DataType;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.Plot;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.RollTable;
import de.rpgframework.random.RollTableGenerator;
import de.rpgframework.random.VariableHolderNode;
import de.rpgframework.random.withoutnumber.StoryTag;
import de.rpgframework.random.withoutnumber.StoryTagElement;
import de.rpgframework.random.withoutnumber.StoryTagList;
import de.rpgframework.random.withoutnumber.StoryTagValue;
import de.rpgframework.random.withoutnumber.WithoutNumberVariable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.prelle.simplepersist.Persister;
import org.prelle.simplepersist.SerializationException;

public class StoryTagGenerator
extends RollTableGenerator
implements RandomGenerator {
    private static final System.Logger logger = System.getLogger(StoryTagGenerator.class.getPackageName());
    private List<Classification<?>> classifications = new ArrayList();
    private GenericCore core;

    public StoryTagGenerator(MultiLanguageResourceBundle RES, String prefix, Genre genre) {
        super(RES);
        this.classifications.add((Classification<?>)genre);
        logger.log(System.Logger.Level.INFO, "START -------------------------------CWN-----------------------------------------------");
        DataSet core = new DataSet((Object)this, RoleplayingSystem.ALL, "cwn", "cwn", new Locale[]{Locale.ENGLISH});
        Class<StoryTagGenerator> clazz = StoryTagGenerator.class;
        List list = null;
        try {
            list = GenericCore.loadDataItems(StoryTagList.class, StoryTag.class, (DataSet)core, (InputStream)clazz.getResourceAsStream("cwn_mission_tags.xml"));
            logger.log(System.Logger.Level.DEBUG, "Loaded {0} missions tags", list.size());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed loading missions tags", (Throwable)e);
        }
        String key = prefix + "_tags_table.xml";
        logger.log(System.Logger.Level.INFO, "Try load " + key);
        InputStream ins = this.getClass().getResourceAsStream(key);
        super.loadTables(ins);
    }

    @Override
    public String getId() {
        return "SWNMission";
    }

    @Override
    public GeneratorType getType() {
        return GeneratorType.RUN;
    }

    @Override
    public Collection<ClassificationType> getRequiredVariables() {
        return List.of(GenericClassificationType.GENRE);
    }

    @Override
    public boolean matchesFilter(Classification<?> filter) {
        for (Classification<?> cls : this.classifications) {
            if (cls.getType() != filter.getType()) continue;
            return cls.getValue() == filter.getValue();
        }
        return false;
    }

    @Override
    public boolean understandsHint(ClassificationType filter) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object generate(VariableHolderNode context) {
        logger.log(System.Logger.Level.INFO, "ENTER: generate({0})", context);
        Plot plot = new Plot();
        for (Classification<?> tmp : context.getHints()) {
            plot.setHint(tmp);
        }
        try {
            StoryTagValue tagValue;
            StoryTag tag;
            RollTable table = (RollTable)this.tables.get(WithoutNumberVariable.MISSION_TAG.name());
            logger.log(System.Logger.Level.DEBUG, "Roll with classifier " + plot.getHints());
            super.simpleRoll(table, plot, Locale.getDefault());
            Object foo = plot.getGenericVariable(WithoutNumberVariable.MISSION_TAG);
            System.err.println("Generatated misson tag =" + foo);
            List list = (List)plot.getGenericVariable(WithoutNumberVariable.MISSION_TAG);
            List enemyList = (List)plot.getGenericVariable(WithoutNumberVariable.ENEMY);
            if (list.size() > 0) {
                Actor actor;
                VariableHolderNode context2;
                tag = (StoryTag)GenericCore.getItem(StoryTag.class, (String)((String)list.get(0)));
                if (tag == null) {
                    logger.log(System.Logger.Level.ERROR, "Unknown tag {0}", list.get(0));
                }
                tagValue = new StoryTagValue(tag);
                plot.setTag1(tagValue);
                if (!tag.getEnemies().isEmpty()) {
                    StoryTagElement enemy = tag.getEnemies().get(random.nextInt(tag.getEnemies().size()));
                    tagValue.setEnemy(enemy);
                    context2 = new VariableHolderNode(plot);
                    context2.setHint((Classification<?>)ActorRole.VILLAIN);
                    List<RandomGenerator> generators = RandomGenerator.builder().thatGenerates(GeneratorType.NSC).forRules(RoleplayingSystem.SHADOWRUN6).buildChain();
                    actor = null;
                    logger.log(System.Logger.Level.WARNING, "Creating the villain returns {0} generators", generators.size());
                    for (RandomGenerator generator : generators) {
                        if (actor == null) {
                            actor = (Actor)generator.generate(context2);
                            continue;
                        }
                        Actor tmpActor = (Actor)generator.generate(context2);
                        logger.log(System.Logger.Level.DEBUG, "Added gen.vars  {0}", tmpActor.getGenericVariables());
                        actor.copyVariables(tmpActor);
                    }
                    plot.addActor(actor);
                }
                if (!tag.getFriends().isEmpty()) {
                    StoryTagElement friend = tag.getEnemies().get(random.nextInt(tag.getFriends().size()));
                    tagValue.setFriend(friend.getId());
                    context2 = new VariableHolderNode(plot);
                    context2.setHint((Classification<?>)ActorRole.CLIENT);
                    RandomGenerator generator = RandomGenerator.builder().thatGenerates(GeneratorType.NSC).forRules(RoleplayingSystem.SHADOWRUN6).build();
                    actor = (Actor)generator.generate(context2);
                    plot.addActor(actor);
                }
                if (!tag.getComplications().isEmpty()) {
                    tagValue.setComplication(tag.getComplications().get(random.nextInt(tag.getComplications().size())).getId());
                }
                if (!tag.getThings().isEmpty()) {
                    tagValue.setThing(tag.getThings().get(random.nextInt(tag.getThings().size())).getId());
                }
                if (!tag.getPlaces().isEmpty()) {
                    tagValue.setPlace(tag.getPlaces().get(random.nextInt(tag.getPlaces().size())).getId());
                }
            }
            if (list.size() > 1) {
                tag = (StoryTag)GenericCore.getItem(StoryTag.class, (String)((String)list.get(1)));
                tagValue = new StoryTagValue(tag);
                plot.setTag2(tagValue);
                if (!tag.getEnemies().isEmpty()) {
                    tagValue.setEnemy(tag.getEnemies().get(random.nextInt(tag.getEnemies().size())));
                }
                if (!tag.getFriends().isEmpty()) {
                    tagValue.setFriend(tag.getFriends().get(random.nextInt(tag.getFriends().size())).getId());
                }
                if (!tag.getComplications().isEmpty()) {
                    tagValue.setComplication(tag.getComplications().get(random.nextInt(tag.getComplications().size())).getId());
                }
                if (!tag.getThings().isEmpty()) {
                    tagValue.setThing(tag.getThings().get(random.nextInt(tag.getThings().size())).getId());
                }
                if (!tag.getPlaces().isEmpty()) {
                    tagValue.setPlace(tag.getPlaces().get(random.nextInt(tag.getPlaces().size())).getId());
                }
            }
            try {
                new Persister().write((Object)plot, (OutputStream)System.out);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Plot plot2 = plot;
            return plot2;
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: generate");
        }
    }

    @Override
    protected GeneratorVariable resolveModifier(String name) {
        logger.log(System.Logger.Level.TRACE, "resolve {0}", name);
        return WithoutNumberVariable.valueOf(name);
    }

    @Override
    public Collection<DataType> getProvidedData() {
        return List.of(DataType.PLOT_ABSTRACT);
    }
}

