/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.random.DataType;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.RandomGeneratorBuilder;
import de.rpgframework.random.VariableHolderNode;
import java.util.Collection;
import java.util.List;

public interface RandomGenerator {
    public static RandomGeneratorBuilder builder() {
        return new RandomGeneratorBuilder();
    }

    public static boolean contains(List<Classification<?>> list, ClassificationType type) {
        return list.stream().anyMatch(e -> e.getType() == type);
    }

    public static <T> T getValueOf(List<Classification<?>> list, ClassificationType type) {
        for (Classification<?> cls : list) {
            if (cls.getType() != type) continue;
            return (T)cls.getValue();
        }
        return null;
    }

    public String getId();

    public GeneratorType getType();

    public Collection<ClassificationType> getRequiredVariables();

    public Collection<DataType> getProvidedData();

    public boolean matchesFilter(Classification<?> var1);

    public boolean understandsHint(ClassificationType var1);

    public Object generate(VariableHolderNode var1);
}

