/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.DynamicClassification;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.random.GeneratorVariable;
import de.rpgframework.random.GeneratorVariableValue;
import de.rpgframework.random.StringGeneratorVariableValue;
import de.rpgframework.random.TextLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.prelle.simplepersist.ElementList;

public class VariableHolderNode {
    private static final System.Logger logger = System.getLogger(VariableHolderNode.class.getPackageName());
    private RoleplayingSystem rules;
    private Map<ClassificationType, Classification<?>> tags;
    private Map<GeneratorVariable, Integer> modifiers = new HashMap<GeneratorVariable, Integer>();
    private Map<GeneratorVariable, GeneratorVariableValue> variables = new HashMap<GeneratorVariable, GeneratorVariableValue>();
    @ElementList(entry="line", type=TextLine.class)
    private List<TextLine> lines;

    public VariableHolderNode() {
        this.lines = new ArrayList<TextLine>();
        this.tags = new HashMap();
    }

    public VariableHolderNode(VariableHolderNode copy) {
        copy.getGenericVariables().forEach((k, v) -> this.variables.put((GeneratorVariable)k, (GeneratorVariableValue)v));
        this.lines = new ArrayList<TextLine>();
        this.tags = new HashMap();
        copy.getHints().forEach(c -> this.tags.put(c.getType(), (Classification<?>)c));
    }

    public <T extends VariableHolderNode> T setHint(Classification<?> value) {
        this.tags.put(value.getType(), value);
        return (T)this;
    }

    public <T extends VariableHolderNode> T setHint(ClassificationType type, String value) {
        DynamicClassification dyn = new DynamicClassification(type, value);
        this.tags.put(type, (Classification<?>)dyn);
        return (T)this;
    }

    public VariableHolderNode withHints(List<Classification<?>> data) {
        data.forEach(c -> this.tags.put(c.getType(), (Classification<?>)c));
        return this;
    }

    public List<Classification<?>> getHints() {
        return new ArrayList(this.tags.values());
    }

    public void copyHints(VariableHolderNode copy) {
        copy.getHints().forEach(c -> this.tags.put(c.getType(), (Classification<?>)c));
    }

    public void copyVariables(VariableHolderNode copy) {
        copy.getGenericVariables().forEach((k, v) -> this.variables.put((GeneratorVariable)k, (GeneratorVariableValue)v));
    }

    public <T extends VariableHolderNode> T addVariable(GeneratorVariable modifier, int value) {
        if (modifier == null) {
            throw new NullPointerException("modifier");
        }
        Integer old = this.modifiers.get(modifier);
        if (old == null) {
            this.modifiers.put(modifier, value);
        } else {
            this.modifiers.put(modifier, old + value);
        }
        return (T)this;
    }

    public VariableHolderNode withVariables(Map<GeneratorVariable, Integer> data) {
        data.forEach((k, v) -> this.modifiers.put((GeneratorVariable)k, (Integer)v));
        return this;
    }

    public int getVariable(GeneratorVariable modifier) {
        if (this.modifiers.containsKey(modifier)) {
            return this.modifiers.get(modifier);
        }
        return 0;
    }

    public Map<GeneratorVariable, Integer> getVariables() {
        return this.modifiers;
    }

    public Map<GeneratorVariable, GeneratorVariableValue> getGenericVariables() {
        return this.variables;
    }

    public VariableHolderNode setVariable(GeneratorVariable key, GeneratorVariableValue value) {
        this.variables.put(key, value);
        logger.log(System.Logger.Level.DEBUG, "Variable {0} of {1} now {2}", key, this, this.variables.get(key));
        return this;
    }

    public VariableHolderNode setVariable(GeneratorVariable key, String value) {
        StringGeneratorVariableValue var = new StringGeneratorVariableValue(null, key, value);
        return this.setVariable(key, var);
    }

    public Object getGenericVariable(GeneratorVariable key) {
        return this.variables.get(key);
    }

    public List<TextLine> getLines() {
        return this.lines;
    }

    public void addLine(TextLine line) {
        this.lines.add(line);
    }
}

