/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.ComplexDataItemControllerOneColumnSkin;
import de.rpgframework.jfx.ComplexDataItemControllerTwoColumnSkin;
import de.rpgframework.jfx.ComplexDataItemListFilter;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.WindowMode;

public class ComplexDataItemControllerNode<T extends ComplexDataItem, V extends ComplexDataItemValue<T>>
extends Control
implements ResponsiveControl {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private static final String DEFAULT_STYLE_CLASS = "selection-control";
    private ObjectProperty<ComplexDataItemController<T, V>> control;
    private ObjectProperty<ObservableList<T>> availableProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<ObservableList<V>> selectedProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> availableCellFactoryProperty;
    private ObjectProperty<Callback<ListView<V>, ListCell<V>>> selectedCellFactoryProperty;
    private ObjectProperty<BiFunction<T, List<Choice>, Decision[]>> optionCallbackProperty;
    private ObjectProperty<ComplexDataItemListFilter<T, V>> filterNodeProperty = new SimpleObjectProperty();
    private ObjectProperty<Predicate<V>> selectedFilterProperty = new SimpleObjectProperty();
    private ObjectProperty<Node> selectedListHeadProperty = new SimpleObjectProperty();
    private ObjectProperty<Node> selectedListPostNodeProperty = new SimpleObjectProperty();
    private BooleanProperty showHeadingsProperty;
    private StringProperty availableHeadingProperty;
    private StringProperty selectedHeadingProperty;
    private StringProperty availablePlaceholderProperty;
    private StringProperty selectedPlaceholderProperty;
    private ObjectProperty<T> showHelpForProperty;
    private ObjectProperty<ComplexDataItem> showGenericHelpForProperty = new SimpleObjectProperty();
    private StringProperty availableStyleProperty;
    private StringProperty selectedStyleProperty;
    private ObjectProperty<Function<Requirement, String>> requirementResolver = new SimpleObjectProperty();
    private ObjectProperty<Function<Modification, String>> modificationResolver = new SimpleObjectProperty();

    public ComplexDataItemControllerNode(ComplexDataItemController<T, V> controller) {
        this.control = new SimpleObjectProperty(controller);
        this.availableCellFactoryProperty = new SimpleObjectProperty();
        this.selectedCellFactoryProperty = new SimpleObjectProperty();
        this.optionCallbackProperty = new SimpleObjectProperty();
        this.showHeadingsProperty = new SimpleBooleanProperty(true);
        this.availableHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.available"));
        this.selectedHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.selected"));
        this.availablePlaceholderProperty = new SimpleStringProperty();
        this.selectedPlaceholderProperty = new SimpleStringProperty();
        this.showHelpForProperty = new SimpleObjectProperty();
        this.availableStyleProperty = new SimpleStringProperty();
        this.selectedStyleProperty = new SimpleStringProperty();
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.control.addListener((ov, o, n) -> this.refresh());
        this.refresh();
    }

    public Skin<?> createDefaultSkin() {
        return new ComplexDataItemControllerTwoColumnSkin(this);
    }

    public ObjectProperty<ComplexDataItemController<T, V>> getControllerProperty() {
        return this.control;
    }

    public ComplexDataItemController<T, V> getController() {
        return (ComplexDataItemController)this.control.get();
    }

    public void setController(ComplexDataItemController<T, V> value) {
        this.control.set(value);
    }

    public void refresh() {
        if (this.control.get() == null) {
            logger.log(System.Logger.Level.WARNING, "No controller yet");
            return;
        }
        if (logger.isLoggable(System.Logger.Level.DEBUG)) {
            logger.log(System.Logger.Level.DEBUG, "ComplexDataItemControllerNode.refresh: " + String.valueOf(((ComplexDataItemController)this.control.get()).getSelected()));
        }
        try {
            ((ObservableList)this.availableProperty.get()).setAll((Collection)((ComplexDataItemController)this.control.get()).getAvailable().stream().sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList()));
            if (this.getFilterNode() != null) {
                this.getFilterNode().applyFilter();
            }
            if (this.selectedFilterProperty.get() != null) {
                ((ObservableList)this.selectedProperty.get()).setAll((Collection)((ComplexDataItemController)this.control.get()).getSelected().stream().filter(this.getSelectedFilter()).collect(Collectors.toList()));
            } else {
                ((ObservableList)this.selectedProperty.get()).setAll((Collection)((ComplexDataItemController)this.control.get()).getSelected());
            }
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "ComplexDataItemControllerNode.refresh: done");
        }
    }

    public ObjectProperty<ObservableList<T>> availableProperty() {
        return this.availableProperty;
    }

    public ObservableList<T> getAvailable() {
        return (ObservableList)this.availableProperty.get();
    }

    public ObjectProperty<ObservableList<V>> selectedProperty() {
        return this.selectedProperty;
    }

    public ObservableList<V> getSelected() {
        return (ObservableList)this.selectedProperty.get();
    }

    public ObjectProperty<BiFunction<T, List<Choice>, Decision[]>> optionCallbackProperty() {
        return this.optionCallbackProperty;
    }

    public BiFunction<T, List<Choice>, Decision[]> getOptionCallback() {
        return (BiFunction)this.optionCallbackProperty.get();
    }

    public void setOptionCallback(BiFunction<T, List<Choice>, Decision[]> value) {
        this.optionCallbackProperty.setValue(value);
    }

    public ObjectProperty<ComplexDataItemListFilter<T, V>> filterNodeProperty() {
        return this.filterNodeProperty;
    }

    public ComplexDataItemListFilter<T, V> getFilterNode() {
        return (ComplexDataItemListFilter)((Object)this.filterNodeProperty.get());
    }

    public void setFilterNode(ComplexDataItemListFilter<T, V> value) {
        this.filterNodeProperty.setValue(value);
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> availableCellFactoryProperty() {
        return this.availableCellFactoryProperty;
    }

    public Callback<ListView<T>, ListCell<T>> getAvailableCellFactory() {
        return (Callback)this.availableCellFactoryProperty.get();
    }

    public void setAvailableCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.availableCellFactoryProperty.setValue(value);
    }

    public ObjectProperty<Callback<ListView<V>, ListCell<V>>> selectedCellFactoryProperty() {
        return this.selectedCellFactoryProperty;
    }

    public Callback<ListView<V>, ListCell<V>> getSelectedCellFactory() {
        return (Callback)this.selectedCellFactoryProperty.get();
    }

    public void setSelectedCellFactory(Callback<ListView<V>, ListCell<V>> value) {
        this.selectedCellFactoryProperty.setValue(value);
    }

    public ObjectProperty<Predicate<V>> selectedFilterProperty() {
        return this.selectedFilterProperty;
    }

    public Predicate<V> getSelectedFilter() {
        return (Predicate)this.selectedFilterProperty.get();
    }

    public void setSelectedFilter(Predicate<V> value) {
        this.selectedFilterProperty.setValue(value);
    }

    public ObjectProperty<Node> selectedListHeadProperty() {
        return this.selectedListHeadProperty;
    }

    public Node getSelectedListHead() {
        return (Node)this.selectedListHeadProperty.get();
    }

    public void setSelectedListHead(Node value) {
        this.selectedListHeadProperty.setValue((Object)value);
    }

    public ObjectProperty<Node> selectedListPostNodeProperty() {
        return this.selectedListPostNodeProperty;
    }

    public Node getSelectedListPostNode() {
        return (Node)this.selectedListPostNodeProperty.get();
    }

    public void setSelectedListPostNode(Node value) {
        this.selectedListPostNodeProperty.setValue((Object)value);
    }

    public BooleanProperty showHeadingsProperty() {
        return this.showHeadingsProperty;
    }

    public boolean getShowHeadings() {
        return this.showHeadingsProperty.get();
    }

    public void setShowHeadings(boolean value) {
        this.showHeadingsProperty.set(value);
    }

    public StringProperty availableHeadingProperty() {
        return this.availableHeadingProperty;
    }

    public String getAvailableHeading() {
        return (String)this.availableHeadingProperty.get();
    }

    public void setAvailableHeading(String value) {
        this.availableHeadingProperty.set((Object)value);
    }

    public StringProperty selectedHeadingProperty() {
        return this.selectedHeadingProperty;
    }

    public String getSelectedHeading() {
        return (String)this.selectedHeadingProperty.get();
    }

    public void setSelectedHeading(String value) {
        this.selectedHeadingProperty.set((Object)value);
    }

    public StringProperty availablePlaceholderProperty() {
        return this.availablePlaceholderProperty;
    }

    public String getAvailablePlaceholder() {
        return (String)this.availablePlaceholderProperty.get();
    }

    public void setAvailablePlaceholder(String value) {
        this.availablePlaceholderProperty.set((Object)value);
    }

    public StringProperty selectedPlaceholderProperty() {
        return this.selectedPlaceholderProperty;
    }

    public String getSelectedPlaceholder() {
        return (String)this.selectedPlaceholderProperty.get();
    }

    public void setSelectedPlaceholder(String value) {
        this.selectedPlaceholderProperty.set((Object)value);
    }

    public ObjectProperty<T> showHelpForProperty() {
        return this.showHelpForProperty;
    }

    public T getShowHelpFor() {
        return (T)((ComplexDataItem)this.showHelpForProperty.get());
    }

    public void setShowHelpFor(T value) {
        this.showHelpForProperty.setValue(value);
    }

    public void setShowGenericHelpFor(ComplexDataItem value) {
        this.showGenericHelpForProperty.setValue((Object)value);
    }

    public ReadOnlyObjectProperty<ComplexDataItem> showGenericHelpForProperty() {
        return this.showGenericHelpForProperty;
    }

    public StringProperty availableStyleProperty() {
        return this.availableStyleProperty;
    }

    public String getAvailableStyle() {
        return (String)this.availableStyleProperty.get();
    }

    public void setAvailableStyle(String value) {
        this.availableStyleProperty.set((Object)value);
    }

    public StringProperty selectedStyleProperty() {
        return this.selectedStyleProperty;
    }

    public String getSelectedStyle() {
        return (String)this.selectedStyleProperty.get();
    }

    public void setSelectedStyle(String value) {
        this.selectedStyleProperty.set((Object)value);
    }

    public ObjectProperty<Function<Requirement, String>> requirementResolverProperty() {
        return this.requirementResolver;
    }

    public Function<Requirement, String> getRequirementResolver() {
        return (Function)this.requirementResolver.get();
    }

    public ComplexDataItemControllerNode<T, V> setRequirementResolver(Function<Requirement, String> value) {
        this.requirementResolver.setValue(value);
        return this;
    }

    public ObjectProperty<Function<Modification, String>> modificationResolverProperty() {
        return this.modificationResolver;
    }

    public Function<Modification, String> getModificationResolver() {
        return (Function)this.modificationResolver.get();
    }

    public ComplexDataItemControllerNode<T, V> setModificationResolver(Function<Modification, String> value) {
        this.modificationResolver.setValue(value);
        return this;
    }

    public void setResponsiveMode(WindowMode value) {
        if (this.getSkin() instanceof ComplexDataItemControllerTwoColumnSkin) {
            ((ComplexDataItemControllerTwoColumnSkin)this.getSkin()).setResponsiveMode(value);
        } else if (this.getSkin() instanceof ComplexDataItemControllerOneColumnSkin) {
            ((ComplexDataItemControllerOneColumnSkin)this.getSkin()).setResponsiveMode(value);
        }
    }
}

