/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.jfx.ADescriptionPane;
import de.rpgframework.jfx.AFilterInjector;
import de.rpgframework.jfx.IRefreshableList;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.javafx.ApplicationScreen;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.Mode;
import org.prelle.javafx.Page;
import org.prelle.javafx.PageBase;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.WindowMode;

public class FilteredListPage<T extends DataItem>
extends Page
implements IRefreshableList {
    private static final ResourceBundle RES = ResourceBundle.getBundle(FilteredListPage.class.getName());
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private Callback<ListView<T>, ListCell<T>> NAME_CELL_FACTORY = new Callback<ListView<T>, ListCell<T>>(){

        public ListCell<T> call(ListView<T> param) {
            return new DataItemListCell();
        }
    };
    private Supplier<Collection<? extends T>> listProvider;
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty = new SimpleObjectProperty(this.NAME_CELL_FACTORY);
    private ADescriptionPane<T> descPane;
    private AFilterInjector<T> filterInjector;
    private Button btnOpen;
    private TextField search;
    private FlowPane filterPane;
    private HBox contentPane;
    private ListView<T> lvResult;
    private transient boolean busy;

    public FilteredListPage(String title, Supplier<Collection<? extends T>> listProvider, ADescriptionPane<T> descPane) {
        super(title);
        this.setMode(Mode.BACKDROP);
        this.listProvider = listProvider;
        this.descPane = descPane;
        if (descPane == null) {
            throw new NullPointerException("descPane");
        }
        descPane.setStyle("-fx-background-color: transparent");
        this.initSecondaryHeader();
        this.initSecondaryContent();
        this.initPrimaryContent();
        this.initInteractivity();
        this.refreshList();
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        return this.cellFactoryProperty;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public void setFilterInjector(AFilterInjector<T> value) {
        this.filterInjector = value;
        if (value != null) {
            value.addFilter(this, (Pane)this.filterPane);
        }
        this.refreshList();
    }

    private void initSecondaryHeader() {
        this.btnOpen = new Button(null, (Node)new SymbolIcon("Filter"));
        this.btnOpen.setStyle("-fx-pref-width: 2em; -fx-border-width: 0px");
        this.search = new TextField();
        this.search.setPromptText(ResourceI18N.get((ResourceBundle)RES, (String)"search.prompt"));
        HBox head2nd = new HBox(new Node[]{this.btnOpen, this.search});
        this.setSecondaryHeader((Node)head2nd);
    }

    private void initSecondaryContent() {
        Label head = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"heading.type"));
        head.getStyleClass().add((Object)"base");
        this.filterPane = new FlowPane();
        this.filterPane.setVgap(2.0);
        this.filterPane.setHgap(2.0);
        VBox content2nd = new VBox(new Node[]{head, this.filterPane});
        content2nd.setStyle("-fx-spacing: 0.5em; -fx-padding: 10px 0 10px 0");
        VBox.setMargin((Node)content2nd, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.setSecondaryContent((Node)content2nd);
    }

    private void initPrimaryContent() {
        this.contentPane = new HBox(20.0);
        VBox.setVgrow((Node)this.contentPane, (Priority)Priority.ALWAYS);
        this.lvResult = new ListView();
        this.lvResult.cellFactoryProperty().bind(this.cellFactoryProperty);
        this.lvResult.setMaxHeight(Double.MAX_VALUE);
        this.lvResult.setStyle("-fx-min-width: 20em; -fx-pref-width: 28em;  -fx-max-width: 28em");
        HBox.setHgrow(this.lvResult, (Priority)Priority.SOMETIMES);
        this.contentPane.getChildren().add(this.lvResult);
        if (ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL) {
            this.contentPane.getChildren().add(this.descPane);
        }
        this.setContent((Node)this.contentPane);
    }

    private void initInteractivity() {
        this.lvResult.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            if (n != null) {
                this.showAction(n);
            }
        });
        this.search.textProperty().addListener((ov, o, n) -> this.refreshList());
        this.btnOpen.setOnAction(ev -> this.toggleOpenClose());
    }

    public boolean nameMatch(T item, String search) {
        return item.getName().toLowerCase().indexOf(search.toLowerCase()) > -1;
    }

    @Override
    public void refreshList() {
        if (this.busy) {
            return;
        }
        try {
            this.busy = true;
            List<Object> list = new ArrayList<T>(this.listProvider.get());
            if (this.search.getText() != null && !this.search.getText().isBlank()) {
                list = list.stream().filter(crea -> this.nameMatch(crea, this.search.getText())).collect(Collectors.toList());
            }
            if (this.filterInjector != null) {
                list = this.filterInjector.applyFilter(list);
                this.filterInjector.updateChoices(list);
            }
            Collections.sort(list, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return Collator.getInstance().compare(o1.getName(), o2.getName());
                }
            });
            this.lvResult.getItems().setAll(list);
        }
        finally {
            this.busy = false;
        }
    }

    protected void showAction(T value) {
        logger.log(System.Logger.Level.WARNING, "showAction(" + String.valueOf(value) + ") on " + String.valueOf(((Object)this.descPane).getClass()));
        this.descPane.setData(value);
        if (ResponsiveControlManager.getCurrentMode() == WindowMode.MINIMAL) {
            logger.log(System.Logger.Level.DEBUG, "Open page for " + String.valueOf(this.descPane));
            this.contentPane.getChildren().remove(this.descPane);
            Page toOpen = new Page(null, this.descPane);
            FlexibleApplication.getInstance().openScreen(new ApplicationScreen((PageBase)toOpen));
        } else {
            HBox.setHgrow(this.descPane, (Priority)Priority.SOMETIMES);
            this.contentPane.getChildren().setAll((Object[])new Node[]{this.lvResult, this.descPane});
        }
    }

    private class DataItemListCell<U extends DataItem>
    extends ListCell<U> {
        private DataItemListCell() {
        }

        public void updateItem(U item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
            } else {
                this.setText(item.getName(Locale.getDefault()));
            }
        }
    }
}

