/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.PageReference;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.ADescriptionPane;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.attach.PDFViewerServiceFactory;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;

public class GenericDescriptionVBox
extends ADescriptionPane {
    private static final ResourceBundle RES = ResourceBundle.getBundle(GenericDescriptionVBox.class.getName());
    private Function<Requirement, String> requirementResolver;
    private Function<Modification, String> modificationResolver;
    private BooleanProperty showModificationsInDescription = new SimpleBooleanProperty(true);
    private BooleanProperty useScrollPane = new SimpleBooleanProperty(true);
    private TextFlow description;
    private TextField tfKey;
    private Label hdRequires;
    private Label requirements;
    private Label hdModifies;
    private Label modifications;
    protected VBox inner;

    public GenericDescriptionVBox(Function<Requirement, String> requirementResolver, Function<Modification, String> modificationResolver) {
        this.requirementResolver = requirementResolver;
        this.modificationResolver = modificationResolver;
        if (requirementResolver == null) {
            requirementResolver = req -> req.toString();
        }
        if (modificationResolver == null) {
            modificationResolver = req -> req.toString();
        }
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    public GenericDescriptionVBox(Function<Requirement, String> requirementResolver, Function<Modification, String> modificationResolver, DataItem item) {
        this(requirementResolver, modificationResolver);
        this.setData(item);
    }

    private void initComponents() {
        this.descTitle.setWrapText(true);
        this.descSources.setWrapText(true);
        this.description = new TextFlow();
        this.tfKey = new TextField();
        this.tfKey.setVisible(false);
        this.tfKey.setManaged(false);
        this.requirements = new Label();
        this.requirements.setWrapText(true);
        this.modifications = new Label();
        this.modifications.setWrapText(true);
    }

    protected void initLayout() {
        Label hdDescription = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.descr"));
        this.hdRequires = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.requires"));
        this.hdModifies = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.modifications"));
        hdDescription.getStyleClass().add((Object)"base");
        this.hdRequires.getStyleClass().add((Object)"base");
        this.hdModifies.getStyleClass().add((Object)"base");
        this.inner = new VBox(5.0, new Node[]{hdDescription, this.description, this.tfKey, this.hdModifies, this.modifications, this.hdRequires, this.requirements});
        VBox.setMargin((Node)this.hdModifies, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.hdRequires, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        this.setMaxHeight(Double.MAX_VALUE);
        this.setStyle("-fx-pref-width: 20em");
        this.setStyle("-fx-max-width: 30em");
        this.getChildren().addAll((Object[])new Node[]{this.descTitle, this.descSources, this.getWithOrWithoutScrollPane()});
    }

    private Node getWithOrWithoutScrollPane() {
        if (this.useScrollPane.get()) {
            ScrollPane scroll = new ScrollPane((Node)this.inner);
            scroll.setFitToWidth(true);
            scroll.setMinHeight(200.0);
            scroll.setMaxHeight(Double.MAX_VALUE);
            VBox.setVgrow((Node)scroll, (Priority)Priority.ALWAYS);
            return scroll;
        }
        return this.inner;
    }

    protected void initInteractivity() {
        this.useScrollPaneProperty().addListener((ov, o, n) -> this.getChildren().setAll((Object[])new Node[]{this.descTitle, this.descSources, this.getWithOrWithoutScrollPane()}));
    }

    public void setData(DataItemValue<?> data) {
        if (data == null) {
            this.descTitle.setText(null);
            this.descSources.setText(null);
            this.requirements.setText(null);
            this.modifications.setText(null);
            return;
        }
        this.setData(data.getModifyable());
    }

    public void setData(DataItem data) {
        ArrayList<String> list;
        PageReference pageRef;
        if (data == null) {
            this.descTitle.setText(null);
            this.descSources.setText(null);
            this.requirements.setText(null);
            this.modifications.setText(null);
            return;
        }
        Optional<PageReference> optPageRef = data.getPageReferences().stream().filter(pr -> pr.getLanguage().equals(Locale.getDefault().getLanguage())).findFirst();
        PageReference pageReference = pageRef = optPageRef.isPresent() ? optPageRef.get() : null;
        if (pageRef != null) {
            PDFViewerServiceFactory.create().ifPresent(service -> service.show(pageRef.getProduct().getRules(), pageRef.getProduct().getID(), pageRef.getLanguage(), pageRef.getPage()));
        }
        this.descTitle.setText(data.getName(Locale.getDefault()));
        this.descSources.setText(RPGFrameworkJavaFX.createSourceText(data));
        this.tfKey.setVisible(!data.hasLicense(Locale.getDefault()));
        this.tfKey.setManaged(!data.hasLicense(Locale.getDefault()));
        this.tfKey.setText(data.getTypeString() + "." + data.getId().toLowerCase() + ".desc");
        RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, data.getDescription(Locale.getDefault()));
        if (data instanceof ComplexDataItem && !((ComplexDataItem)data).getRequirements().isEmpty()) {
            this.hdRequires.setVisible(true);
            this.hdRequires.setManaged(true);
            this.requirements.setVisible(true);
            this.requirements.setManaged(true);
            list = new ArrayList<String>();
            for (Requirement req : ((ComplexDataItem)data).getRequirements()) {
                if (this.requirementResolver != null) {
                    list.add(this.requirementResolver.apply(req));
                    continue;
                }
                list.add(String.valueOf(req));
            }
            this.requirements.setText(String.join((CharSequence)", ", list));
        } else {
            this.hdRequires.setVisible(false);
            this.hdRequires.setManaged(false);
            this.requirements.setVisible(false);
            this.requirements.setManaged(false);
        }
        if (data instanceof ComplexDataItem && !((ComplexDataItem)data).getModifications().isEmpty() && this.showModificationsInDescription.get()) {
            this.hdModifies.setVisible(true);
            this.hdModifies.setManaged(true);
            this.modifications.setVisible(true);
            this.modifications.setManaged(true);
            list = new ArrayList();
            for (Requirement req : ((ComplexDataItem)data).getModifications()) {
                String toAdd;
                if (req instanceof DataItemModification && String.valueOf(((DataItemModification)req).getReferenceType()).equals("HOOK") || (toAdd = this.modificationResolver != null ? this.modificationResolver.apply((Modification)req) : String.valueOf(req)) == null) continue;
                list.add(toAdd);
            }
            this.modifications.setText(String.join((CharSequence)", ", list));
        } else {
            this.hdModifies.setVisible(false);
            this.hdModifies.setManaged(false);
            this.modifications.setVisible(false);
            this.modifications.setManaged(false);
        }
    }

    public void setData(String title, String source, String desc) {
        this.descTitle.setText(title);
        this.descSources.setText(source);
        RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, desc);
        this.hdRequires.setVisible(false);
        this.hdRequires.setManaged(false);
        this.hdModifies.setVisible(false);
        this.hdModifies.setManaged(false);
        this.requirements.setVisible(false);
        this.requirements.setManaged(false);
        this.modifications.setVisible(false);
        this.modifications.setManaged(false);
    }

    public void setResolver(Function<Requirement, String> requirementResolver) {
        this.requirementResolver = requirementResolver;
    }

    public void setModificationResolver(Function<Modification, String> modResolver) {
        this.modificationResolver = modResolver;
    }

    public BooleanProperty showModificationsInDescriptionProperty() {
        return this.showModificationsInDescription;
    }

    public Boolean isShowModificationsInDescription() {
        return this.showModificationsInDescription.get();
    }

    public GenericDescriptionVBox setShowModificationsInDescription(Boolean value) {
        this.showModificationsInDescription.set(value.booleanValue());
        return this;
    }

    public BooleanProperty useScrollPaneProperty() {
        return this.useScrollPane;
    }

    public Boolean isUseScrollPane() {
        return this.useScrollPane.get();
    }

    public GenericDescriptionVBox setUseScrollPane(Boolean value) {
        this.useScrollPane.set(value.booleanValue());
        return this;
    }
}

