/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import javafx.beans.property.ObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import org.prelle.javafx.SymbolIcon;

public class NumericalValueField<T, V extends NumericalValue<T>>
extends HBox {
    private static final System.Logger logger = System.getLogger("prelle.jfx");
    private V value;
    private ObjectProperty<NumericalValueController<T, V>> control;
    private Button dec;
    private Button inc;
    private TextField tfValue;
    private Label lbValue;
    private Callback<V, Integer> valueCallback;
    private Callback<V, String> converter;
    private int minWidthEm;
    private boolean useLabel;
    private Integer overrideValue;
    private EventHandler<ActionEvent> onAction = null;

    public NumericalValueField() {
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.dec.setDisable(true);
        this.inc.setDisable(true);
    }

    public NumericalValueField(V val, ObjectProperty<NumericalValueController<T, V>> ctrl) {
        if (val == null) {
            throw new NullPointerException("val may not be NULL");
        }
        this.value = val;
        this.control = ctrl;
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.refresh();
    }

    public NumericalValueField(V val, ObjectProperty<NumericalValueController<T, V>> ctrl, int minWidthEm, boolean useLabel) {
        if (val == null) {
            throw new NullPointerException("val may not be NULL");
        }
        this.value = val;
        this.control = ctrl;
        this.minWidthEm = minWidthEm;
        this.useLabel = useLabel;
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.refresh();
    }

    private void initComponents() {
        this.dec = new Button(null, (Node)new SymbolIcon("remove"));
        this.inc = new Button(null, (Node)new SymbolIcon("add"));
        this.tfValue = new TextField();
        this.tfValue.setPrefColumnCount(2);
        this.tfValue.setEditable(false);
        this.tfValue.setFocusTraversable(false);
        this.lbValue = new Label();
    }

    private void initLayout() {
        this.getChildren().clear();
        this.setAlignment(Pos.CENTER);
        if (this.useLabel) {
            this.getChildren().addAll((Object[])new Node[]{this.dec, this.lbValue, this.inc});
        } else {
            this.getChildren().addAll((Object[])new Node[]{this.dec, this.tfValue, this.inc});
        }
        HBox.setHgrow((Node)this.lbValue, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)this.tfValue, (Priority)Priority.SOMETIMES);
    }

    private void initStyle() {
        this.inc.getStyleClass().add((Object)"mini-button");
        this.dec.getStyleClass().add((Object)"mini-button");
        if (this.minWidthEm > 0) {
            this.lbValue.setStyle("-fx-padding: 0 0.1em 0 0.1em; -fx-min-width: " + this.minWidthEm + "em; -fx-alignment:center");
        } else {
            this.lbValue.setStyle("-fx-padding: 0 1em 0 1em; -fx-pref-width: 3em");
        }
    }

    private void initInteractivity() {
        this.dec.setOnAction(ev -> {
            ((NumericalValueController)this.control.get()).decrease(this.value);
            this.refresh();
            if (this.onAction != null) {
                this.onAction.handle(ev);
            }
        });
        this.inc.setOnAction(ev -> {
            ((NumericalValueController)this.control.get()).increase(this.value);
            this.refresh();
            if (this.onAction != null) {
                this.onAction.handle(ev);
            }
        });
        if (this.control != null) {
            this.control.addListener((ov, o, n) -> this.refresh());
        }
        this.tfValue.focusedProperty().addListener((ov, o, n) -> {
            if (n.booleanValue()) {
                ActionEvent ev = new ActionEvent((Object)this.tfValue, null);
                if (this.onAction != null) {
                    this.onAction.handle((Event)ev);
                }
            }
        });
    }

    public void setData(V val, ObjectProperty<NumericalValueController<T, V>> ctrl) {
        this.value = val;
        this.control = ctrl;
        this.control.addListener((ov, o, n) -> this.refresh());
        this.refresh();
    }

    public void refresh() {
        if (this.control == null) {
            logger.log(System.Logger.Level.DEBUG, "Mising control for {0} in {1}", new Object[]{this, this.getParent().getParent()});
            return;
        }
        if (this.control.get() == null || this.value == null) {
            return;
        }
        this.dec.setDisable(!((NumericalValueController)this.control.get()).canBeDecreased(this.value).get());
        this.inc.setDisable(!((NumericalValueController)this.control.get()).canBeIncreased(this.value).get());
        int num = ((NumericalValueController)this.control.get()).getValue(this.value);
        if (this.overrideValue != null) {
            num = this.overrideValue;
        }
        if (this.valueCallback != null) {
            num = (Integer)this.valueCallback.call(this.value);
        }
        String text = String.valueOf(num);
        if (this.converter != null) {
            text = (String)this.converter.call(this.value);
        }
        this.tfValue.setText(text);
        this.lbValue.setText(text);
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.tfValue.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setItem(V val) {
        this.value = val;
        this.refresh();
    }

    public void setValueCallback(Callback<V, Integer> valueCallback) {
        this.valueCallback = valueCallback;
        this.initLayout();
    }

    public void setConverter(Callback<V, String> converter) {
        this.converter = converter;
    }

    public void setOverrideValue(Integer overrideValue) {
        this.overrideValue = overrideValue;
    }

    public void setOnAction(EventHandler<ActionEvent> onAction) {
        this.onAction = onAction;
    }
}

