/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.genericrpg.HistoryElement;
import java.text.DateFormat;
import java.util.ResourceBundle;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Separator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;

public class HistoryElementListCell
extends ListCell<HistoryElement> {
    private DateFormat FORMAT = DateFormat.getDateInstance(2);
    private Label lbTitle;
    private Label lbGamemaster;
    private Label lbRealDate;
    private TilePane ruleData;
    private VBox layout;

    public HistoryElementListCell(ResourceBundle res) {
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.lbTitle = new Label();
        this.lbTitle.getStyleClass().add((Object)"base");
        this.lbGamemaster = new Label();
        this.lbGamemaster.getStyleClass().add((Object)"text-secondary-info");
        this.lbRealDate = new Label();
    }

    private void initLayout() {
        this.layout = new VBox(2.0);
        this.layout.getChildren().add((Object)this.lbTitle);
        Region buf = new Region();
        buf.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)buf, (Priority)Priority.ALWAYS);
        HBox line2 = new HBox(5.0, new Node[]{this.lbRealDate, buf, this.lbGamemaster});
        this.layout.getChildren().add((Object)line2);
        this.ruleData = new TilePane(10.0, 5.0);
        this.layout.setFillWidth(true);
        this.layout.getChildren().add((Object)this.ruleData);
        this.layout.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
    }

    protected void updateRuleData(TilePane box, HistoryElement item) {
        box.getChildren().clear();
        box.getChildren().add((Object)new Label("" + item.getTotalExperience()));
        box.getChildren().add((Object)new Label("" + item.getTotalMoney()));
    }

    public void updateItem(HistoryElement item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            this.lbTitle.setText(item.getName());
            this.lbGamemaster.setText(String.join((CharSequence)",", item.getGamemasters()));
            this.lbRealDate.setText(this.FORMAT.format(item.getStart()));
            this.updateRuleData(this.ruleData, item);
            this.setGraphic((Node)this.layout);
        }
    }
}

