/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.chargen.RecommendingController;
import de.rpgframework.genericrpg.data.DataItem;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;

public class RecommendingDataItemListCell<T extends DataItem>
extends ListCell<T> {
    private RecommendingController<T> controller;

    public RecommendingDataItemListCell(RecommendingController<T> controller) {
        this.controller = controller;
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            this.setText(item.getName());
            RecommendationState state = this.controller.getRecommendationState(item);
            if (state == null || state == RecommendationState.NEUTRAL) {
                this.setGraphic(null);
            } else if (state == RecommendationState.RECOMMENDED) {
                this.setGraphic((Node)new Label("*"));
            } else if (state == RecommendationState.UNRECOMMENDED) {
                this.setGraphic((Node)new Label("!"));
            }
        }
    }
}

