/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pages;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.Attachment;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.character.CharacterIOException;
import de.rpgframework.character.CharacterProvider;
import de.rpgframework.character.CharacterProviderLoader;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.CharacterController;
import de.rpgframework.genericrpg.chargen.CharacterGenerator;
import de.rpgframework.genericrpg.chargen.Rule;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.jfx.pages.RuleSettingsPage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import org.prelle.javafx.AlertManager;
import org.prelle.javafx.ApplicationScreen;
import org.prelle.javafx.ApplicationScreenWithPages;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.PageBase;
import org.prelle.javafx.SymbolIcon;

public abstract class CharacterViewLayout<A extends IAttribute, M extends RuleSpecificCharacterObject<A, ?, ?, ?>, C extends CharacterController<A, M>>
extends ApplicationScreenWithPages {
    private static final System.Logger logger = System.getLogger(CharacterViewLayout.class.getPackageName());
    private static final ResourceBundle RES = ResourceBundle.getBundle(CharacterViewLayout.class.getName());
    protected C control;
    protected CharacterHandle handle;
    private RoleplayingSystem rules;
    protected Button btnFinish;
    private Button btnQuit;
    private Button btnSave;
    private Button btnSetting;
    protected boolean dontShowConfirmationDialog;

    public CharacterViewLayout(RoleplayingSystem rules) {
        this.rules = rules;
        this.getStyleClass().add((Object)"character-view-layout");
        SymbolIcon icoAccept = new SymbolIcon("accept");
        SymbolIcon icoQuit = new SymbolIcon("clear");
        SymbolIcon icoSave = new SymbolIcon("save");
        SymbolIcon icoSetting = new SymbolIcon("setting");
        this.btnFinish = new Button(null, (Node)icoAccept);
        this.btnFinish.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"action.finishCreation")));
        this.btnQuit = new Button(null, (Node)icoQuit);
        this.btnQuit.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"action.cancelEditing")));
        this.btnSave = new Button(null, (Node)icoSave);
        this.btnSave.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"action.saveAndExit")));
        this.btnSetting = new Button(null, (Node)icoSetting);
        this.btnSetting.setTooltip(new Tooltip(ResourceI18N.get((ResourceBundle)RES, (String)"action.settings")));
        this.initButtonInteractivity();
        this.extraButtonsTopProperty().addAll((Object[])new Button[]{this.btnQuit, this.btnSave, this.btnFinish});
        this.extraButtonsBottomProperty().addAll((Object[])new Button[]{this.btnSetting});
    }

    private void initButtonInteractivity() {
        this.setCanBeLeftCallback(scr -> {
            boolean allowed = this.userTriesToLeave();
            logger.log(System.Logger.Level.WARNING, "Trying to leave is allowed = " + allowed);
            return allowed;
        });
        this.btnFinish.setOnAction(ev -> {
            logger.log(System.Logger.Level.INFO, "FINISH clicked");
            if (((CharacterGenerator)this.control).canBeFinished()) {
                if (this.control.getToDos().isEmpty()) {
                    if (this.confirmFINISH() == CloseType.OK) {
                        ((CharacterGenerator)this.control).finish();
                        this.saveCharacter();
                        this.dontShowConfirmationDialog = true;
                        FlexibleApplication.getInstance().closeScreen((ApplicationScreen)this);
                    }
                } else if (this.confirmFINISHWarning() == CloseType.OK) {
                    ((CharacterGenerator)this.control).finish();
                    this.dontShowConfirmationDialog = true;
                    this.saveCharacter();
                    FlexibleApplication.getInstance().closeScreen((ApplicationScreen)this);
                }
            } else {
                this.errorCannotFINISH();
            }
        });
        this.btnSave.setOnAction(ev -> {
            logger.log(System.Logger.Level.INFO, "SAVE clicked");
            if (!this.saveCharacter()) {
                return;
            }
            this.dontShowConfirmationDialog = true;
            FlexibleApplication.getInstance().closeScreen((ApplicationScreen)this);
        });
        this.btnQuit.setOnAction(ev -> {
            logger.log(System.Logger.Level.INFO, "QUIT clicked");
            if (this.confirmQUIT() == CloseType.OK) {
                if (this.handle != null) {
                    try {
                        this.reloadCharacter();
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Failed reloading character", (Throwable)e);
                    }
                }
                this.dontShowConfirmationDialog = true;
                FlexibleApplication.getInstance().closeScreen((ApplicationScreen)this);
            }
        });
        this.btnSetting.setOnAction(ev -> {
            logger.log(System.Logger.Level.INFO, "SETTINGS clicked");
            ArrayList<Rule.EffectOn> categories = new ArrayList<Rule.EffectOn>();
            categories.addAll(List.of(Rule.EffectOn.COMMON, Rule.EffectOn.UI));
            if (this.control.getModel().isInCareerMode()) {
                categories.add(0, Rule.EffectOn.CAREER);
            } else {
                categories.add(0, Rule.EffectOn.CHARGEN);
            }
            RuleSettingsPage rulePage = new RuleSettingsPage((CharacterController<?, ?>)this.control, (List<Rule.EffectOn>)categories);
            ApplicationScreen screen = new ApplicationScreen((PageBase)rulePage);
            FlexibleApplication.getInstance().openScreen(screen);
        });
    }

    public void setController(C value) {
        if (value == null) {
            throw new NullPointerException("Controller may not be null");
        }
        this.control = value;
        logger.log(System.Logger.Level.DEBUG, "Controller set to " + String.valueOf(value));
    }

    private CloseType confirmQUIT() {
        return AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.CONFIRMATION, (String)ResourceI18N.get((ResourceBundle)RES, (String)"confirm.quit.title"), (String)ResourceI18N.get((ResourceBundle)RES, (String)"confirm.quit.content"));
    }

    private CloseType confirmFINISH() {
        return AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.CONFIRMATION, (String)ResourceI18N.get((ResourceBundle)RES, (String)"confirm.finish.title"), (String)ResourceI18N.get((ResourceBundle)RES, (String)"confirm.finish.content"));
    }

    private CloseType errorCannotFINISH() {
        return AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)"error.finish.title"), (Node)CharacterViewLayout.getToDoBox(ResourceI18N.get((ResourceBundle)RES, (String)"error.finish.content"), this.control.getToDos()));
    }

    private CloseType confirmFINISHWarning() {
        return AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.CONFIRMATION, (String)ResourceI18N.get((ResourceBundle)RES, (String)"confirm.finishWarning.title"), (Node)CharacterViewLayout.getToDoBox(ResourceI18N.get((ResourceBundle)RES, (String)"confirm.finishWarning.content"), this.control.getToDos()));
    }

    public abstract void startCreation(CharacterGenerator<?, ?> var1);

    public abstract void continueCreation(M var1, CharacterHandle var2);

    public abstract void resetCharacter(M var1, CharacterHandle var2);

    public abstract void edit(M var1, CharacterHandle var2);

    protected void showCharacterIOException(CharacterIOException e, RuleSpecificCharacterObject<A, ?, ?, ?> model) {
        logger.log(System.Logger.Level.ERROR, "showCharacterIOException", (Throwable)e);
        StringWriter out = new StringWriter();
        if (e != null) {
            e.printStackTrace(new PrintWriter(out));
        }
        String title = e.getMessage();
        String explain = e.getValue();
        int type = 2;
        switch (e.getCode()) {
            case ENCODING_FAILED: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.encoding.title");
                explain = ResourceI18N.format((ResourceBundle)RES, (String)"error.encoding.content", (Object[])new Object[]{System.getProperty("logdir") + "\\genesis-logs.txt"});
                break;
            }
            case DECODING_FAILED: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.decoding.title");
                explain = ResourceI18N.format((ResourceBundle)RES, (String)"error.decoding.content", (Object[])new Object[]{System.getProperty("logdir") + "\\genesis-logs.txt"});
                break;
            }
            case CHARACTER_WITH_THAT_NAME_EXISTS: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.already_exists.title");
                explain = ResourceI18N.format((ResourceBundle)RES, (String)"error.chario.already_exists.mess", (Object[])new Object[]{model.getName(), e.getValue()});
                break;
            }
            case NO_FREE_ONLINE_CHARACTER_SLOTS: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.no_free_slots.title");
                explain = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.no_free_slots.mess");
                type = 1;
                break;
            }
            case NO_WRITE_PERMISSION: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.no_write_permission.title");
                explain = ResourceI18N.format((ResourceBundle)RES, (String)"error.chario.no_write_permission.mess", (Object[])new Object[]{e.getValue()});
                break;
            }
            case SERVER_ERROR: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.server_error.title");
                explain = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.server_error.mess");
                break;
            }
            case MISSING_SERVER_CONNECTION: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.missing_server_connection.title");
                explain = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.missing_server_connection.mess");
                type = 1;
                break;
            }
            case OTHER_ERROR: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.other_error.title");
                explain = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.other_error.mess");
                break;
            }
            case FILESYSTEM_WRITE: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.filesystem_write.title");
                explain = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.filesystem_write.mess");
                break;
            }
            case FILESYSTEM_READ: {
                title = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.filesystem_read.title");
                explain = ResourceI18N.get((ResourceBundle)RES, (String)"error.chario.filesystem_read.mess");
            }
        }
        Label mess = new Label(explain);
        mess.setWrapText(true);
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{type, explain, e.getCause()});
    }

    protected void showAnyException(Exception e, RuleSpecificCharacterObject<A, ?, ?, ?> model, String title, String message) {
        StringWriter out = new StringWriter();
        if (e != null) {
            e.printStackTrace(new PrintWriter(out));
        }
        Label mess = new Label(message != null ? message : e.getMessage());
        Label trace = new Label(out.toString());
        mess.setWrapText(true);
        trace.setWrapText(true);
        AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)title, (Node)new VBox(10.0, new Node[]{mess, trace}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userTriesToLeave() {
        logger.log(System.Logger.Level.INFO, "ENTER userTriesToLeave (dontShowConfirmation={0})", this.dontShowConfirmationDialog);
        if (this.dontShowConfirmationDialog) {
            this.dontShowConfirmationDialog = false;
            return true;
        }
        try {
            boolean generation = this.control instanceof CharacterGenerator;
            logger.log(System.Logger.Level.INFO, "generation=" + generation);
            logger.log(System.Logger.Level.DEBUG, "warnings = " + String.valueOf(this.control.getToDos()));
            VBox toDos = CharacterViewLayout.getToDoBox(ResourceI18N.get((ResourceBundle)RES, (String)"alert.finish_creation_with_warning.mess"), this.control.getToDos());
            if (generation) {
                logger.log(System.Logger.Level.DEBUG, "Check if creation is finished");
                if (((CharacterGenerator)this.control).canBeFinished()) {
                    String title;
                    logger.log(System.Logger.Level.DEBUG, "finishing is okay");
                    VBox help = new VBox(5.0, new Node[]{new Label(ResourceI18N.get((ResourceBundle)RES, (String)"closetype.leavecreation.cancel")), new Label(ResourceI18N.get((ResourceBundle)RES, (String)"closetype.leavecreation.quit")), new Label(ResourceI18N.get((ResourceBundle)RES, (String)"closetype.leavecreation.save")), new Label(ResourceI18N.get((ResourceBundle)RES, (String)"closetype.leavecreation.finish"))});
                    VBox dialogContent = new VBox(10.0, new Node[]{toDos, help});
                    if (this.control.getToDos().size() > 0) {
                        dialogContent = new VBox(10.0, new Node[]{toDos, help});
                        title = ResourceI18N.get((ResourceBundle)RES, (String)"alert.finish_creation_with_warning.title");
                    } else {
                        title = ResourceI18N.get((ResourceBundle)RES, (String)"alert.finish_creation_without_warning.title");
                        dialogContent = new VBox(10.0, new Node[]{help});
                    }
                    ManagedDialog dialog = new ManagedDialog(title, (Node)dialogContent, new CloseType[]{CloseType.CANCEL, CloseType.QUIT, CloseType.SAVE, CloseType.FINISH});
                    CloseType result = AlertManager.showAlertAndCall((ManagedDialog)dialog);
                    logger.log(System.Logger.Level.DEBUG, "ManagedDialog closed with " + String.valueOf(result));
                    switch (result) {
                        case CANCEL: {
                            logger.log(System.Logger.Level.INFO, "CANCEL leaving creation");
                            boolean bl = false;
                            return bl;
                        }
                        case QUIT: {
                            logger.log(System.Logger.Level.INFO, "QUIT creation without saving");
                            if (this.handle != null) {
                                this.reloadCharacter();
                            }
                            boolean bl = true;
                            return bl;
                        }
                        case SAVE: {
                            logger.log(System.Logger.Level.INFO, "User wants to pause and leave");
                            this.saveCharacter();
                            boolean bl = true;
                            return bl;
                        }
                        case FINISH: {
                            logger.log(System.Logger.Level.INFO, "User wants to finish and leave");
                            ((CharacterGenerator)this.control).finish();
                            this.saveCharacter();
                            boolean bl = true;
                            return bl;
                        }
                    }
                    logger.log(System.Logger.Level.WARNING, "This should not happen");
                    boolean bl = false;
                    return bl;
                }
                logger.log(System.Logger.Level.INFO, "User wants to leave the generation early.");
                CloseType result = AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.CONFIRMATION, (String)RES.getString("alert.cancel_creation.title"), (String)RES.getString("alert.cancel_creation.message"));
                boolean bl = false;
                return bl;
            }
            logger.log(System.Logger.Level.INFO, "User wants to leave career mode");
            logger.log(System.Logger.Level.DEBUG, "warnings = " + String.valueOf(this.control.getToDos()));
            CloseType result = AlertManager.showAlertAndCall((String)ResourceI18N.get((ResourceBundle)RES, (String)"alert.save_character.title"), (Node)CharacterViewLayout.getToDoBox(ResourceI18N.get((ResourceBundle)RES, (String)"alert.save_character.message"), this.control.getToDos()), (CloseType[])new CloseType[]{CloseType.YES, CloseType.NO, CloseType.CANCEL});
            if (result == CloseType.YES || result == CloseType.OK) {
                logger.log(System.Logger.Level.DEBUG, "User confirmed saving character");
                this.saveCharacter();
                boolean bl = true;
                return bl;
            }
            if (result == CloseType.CANCEL) {
                logger.log(System.Logger.Level.DEBUG, "User cancelled leaving");
                boolean bl = false;
                return bl;
            }
            logger.log(System.Logger.Level.DEBUG, "User denied saving character - reload it");
            this.reloadCharacter();
            boolean bl = true;
            return bl;
        }
        finally {
            logger.log(System.Logger.Level.INFO, "LEAVE userTriesToLeave");
        }
    }

    protected abstract byte[] encodeCharacter(M var1) throws CharacterIOException;

    protected abstract M decodeCharacter(byte[] var1) throws CharacterIOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveCharacter() {
        logger.log(System.Logger.Level.DEBUG, "START: saveCharacter");
        RuleSpecificCharacterObject model = this.control.getModel();
        try {
            byte[] encoded = null;
            try {
                encoded = this.encodeCharacter(model);
                logger.log(System.Logger.Level.DEBUG, "Successfully encoded character");
            }
            catch (CharacterIOException e) {
                this.showCharacterIOException(e, model);
                boolean bl = false;
                logger.log(System.Logger.Level.DEBUG, "STOP : saveCharacter");
                return bl;
            }
            try {
                CharacterProvider charProv;
                Attachment existAttach;
                if (this.handle == null) {
                    logger.log(System.Logger.Level.DEBUG, "CharacterHandle does not exist yet - prepare it");
                    this.handle = CharacterProviderLoader.getCharacterProvider().createCharacter(model.getName(), this.rules);
                    logger.log(System.Logger.Level.DEBUG, "Add model and description to handle {0}", this.handle.getUUID());
                    this.handle.setCharacter(model);
                    this.handle.setShortDescription(model.getShortDescription());
                }
                logger.log(System.Logger.Level.INFO, "Save character " + model.getName());
                if (!this.handle.getName().equals(model.getName())) {
                    logger.log(System.Logger.Level.INFO, "Name changed from ''{0}'' to ''{1}''", this.handle.getName(), model.getName());
                    this.handle.setName(model.getName());
                }
                if ((existAttach = (charProv = CharacterProviderLoader.getCharacterProvider()).getFirstAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC)) == null) {
                    logger.log(System.Logger.Level.DEBUG, "Create new attachment");
                    charProv.addAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC, this.handle.getName(), encoded);
                } else {
                    logger.log(System.Logger.Level.DEBUG, "Modify existing attachment");
                    charProv.deleteAttachment(this.handle, existAttach);
                    existAttach.setData(encoded);
                    existAttach.setFilename(model.getName() + ".xml");
                    charProv.modifyAttachment(this.handle, existAttach);
                }
                logger.log(System.Logger.Level.INFO, "Saved character " + model.getName() + " successfully");
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "Failed saving character", (Throwable)e);
                StringWriter out = new StringWriter();
                e.printStackTrace(new PrintWriter(out));
                AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)"error.saving_character.title"), (String)(ResourceI18N.format((ResourceBundle)RES, (String)"error.saving_character.message", (Object[])new Object[]{System.getProperty("logdir") + "\\genesis-logs.txt"}) + "\n" + String.valueOf(out)));
                boolean bl = false;
                logger.log(System.Logger.Level.DEBUG, "STOP : saveCharacter");
                return bl;
            }
            try {
                if (this.handle != null && !this.handle.getName().equals(model.getName())) {
                    logger.log(System.Logger.Level.INFO, "Character has been renamed");
                    CharacterProviderLoader.getCharacterProvider().renameCharacter(this.handle, model.getName());
                }
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "Renaming failed", (Throwable)e);
                BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, "Renaming failed: " + String.valueOf(e)});
            }
            logger.log(System.Logger.Level.DEBUG, "Update portrait");
            CharacterProvider charServ = CharacterProviderLoader.getCharacterProvider();
            try {
                Attachment attach;
                CharacterProvider charProv = CharacterProviderLoader.getCharacterProvider();
                if (model.getImage() != null && this.handle != null) {
                    Attachment attach2 = charProv.getFirstAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.IMAGE);
                    if (attach2 != null) {
                        logger.log(System.Logger.Level.INFO, "Update character image");
                        attach2.setData(model.getImage());
                        charServ.modifyAttachment(this.handle, attach2);
                    } else {
                        charServ.addAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.IMAGE, this.handle.getName(), model.getImage());
                    }
                } else if (this.handle != null && (attach = charProv.getFirstAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.IMAGE)) != null) {
                    logger.log(System.Logger.Level.INFO, "Delete old character image");
                    charServ.deleteAttachment(this.handle, attach);
                }
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "Failed modifying portrait attachment", (Throwable)e);
            }
            BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.CHAR_MODIFIED, (Object[])new Object[]{this.handle});
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "STOP : saveCharacter");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void reloadCharacter() {
        block16: {
            logger.log(System.Logger.Level.DEBUG, "START: reloadCharacter");
            Object model = this.control.getModel();
            Attachment attach = null;
            try {
                byte[] encoded = null;
                try {
                    attach = CharacterProviderLoader.getCharacterProvider().getFirstAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC);
                    encoded = attach.getData();
                    logger.log(System.Logger.Level.DEBUG, "  character reloaded from disk");
                }
                catch (CharacterIOException e) {
                    this.showCharacterIOException(e, (RuleSpecificCharacterObject<A, ?, ?, ?>)model);
                    logger.log(System.Logger.Level.DEBUG, "STOP : reloadCharacter");
                    return;
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "Failed reloading character", (Throwable)e);
                    BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, ResourceI18N.format((ResourceBundle)RES, (String)"error.reloading_character.message", (Object[])new Object[]{System.getProperty("logdir") + "\\commlink-logs.txt"}), e, attach.getLocalFile()});
                    logger.log(System.Logger.Level.DEBUG, "STOP : reloadCharacter");
                    return;
                }
                try {
                    model = this.decodeCharacter(encoded);
                    this.handle.setCharacter(model);
                    logger.log(System.Logger.Level.INFO, "Loaded character " + model.getName() + " successfully");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Failed decoding character", (Throwable)e);
                    BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, ResourceI18N.format((ResourceBundle)RES, (String)"error.decoding.message", (Object[])new Object[]{System.getProperty("logdir") + "\\commlink-logs.txt"}), e, attach.getLocalFile()});
                    logger.log(System.Logger.Level.DEBUG, "STOP : reloadCharacter");
                    return;
                }
                try {
                    this.resetCharacter(model, this.handle);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Failed processing character", (Throwable)e);
                    e.printStackTrace();
                    BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{1, ResourceI18N.format((ResourceBundle)RES, (String)"error.processing_character.content", (Object[])new Object[]{System.getProperty("logdir") + "\\commlink-logs.txt"}), e, attach.getLocalFile()});
                    logger.log(System.Logger.Level.DEBUG, "STOP : reloadCharacter");
                    return;
                }
                BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.CHAR_MODIFIED, (Object[])new Object[]{this.handle});
                break block16;
                {
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.ERROR, "Failed loading character", e);
                        StringWriter out = new StringWriter();
                        e.printStackTrace(new PrintWriter(out));
                        AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)"error.loading_character.title"), (String)(ResourceI18N.format((ResourceBundle)RES, (String)"error.loading_character.message", (Object[])new Object[]{System.getProperty("logdir") + "\\commlink-logs.txt"}) + "\n" + String.valueOf(out)));
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                logger.log(System.Logger.Level.DEBUG, "STOP : reloadCharacter");
            }
        }
    }

    public static VBox getToDoBox(String mess, List<ToDoElement> todos) {
        VBox bxToDos = new VBox(10.0);
        Label lbMess = new Label(mess);
        lbMess.setWrapText(true);
        bxToDos.getChildren().add((Object)lbMess);
        VBox.setMargin((Node)bxToDos, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        for (ToDoElement todo : todos) {
            Label label = new Label(todo.getMessage());
            label.setWrapText(true);
            label.setStyle("-fx-text-fill: textcolor-" + todo.getSeverity().name().toLowerCase());
            bxToDos.getChildren().add((Object)label);
        }
        return bxToDos;
    }
}

