/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pages;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.Attachment;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.character.CharacterIOException;
import de.rpgframework.character.CharacterProvider;
import de.rpgframework.character.CharacterProviderListener;
import de.rpgframework.character.CharacterProviderLoader;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.BabylonEvent;
import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventListener;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.chargen.CharacterController;
import de.rpgframework.genericrpg.chargen.CharacterGenerator;
import de.rpgframework.jfx.CharacterHandleBox;
import de.rpgframework.jfx.StupidSimpleSingleSelectionModel;
import de.rpgframework.jfx.pages.CharacterExportPluginConfigPane;
import de.rpgframework.jfx.pages.CharacterExportPluginSelectorPane;
import de.rpgframework.jfx.pages.CharacterViewLayout;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import org.prelle.javafx.AlertManager;
import org.prelle.javafx.AlertType;
import org.prelle.javafx.AppBarButton;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.CommandBar;
import org.prelle.javafx.IconElement;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.OptionalNodePane;
import org.prelle.javafx.Page;
import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.WindowMode;

public abstract class CharactersOverviewPage
extends Page
implements ResponsiveControl,
CharacterProviderListener,
BabylonEventListener {
    protected static final ResourceBundle RES = ResourceBundle.getBundle(CharactersOverviewPage.class.getName());
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private static final System.Logger logger = System.getLogger(CharactersOverviewPage.class.getPackageName());
    protected CommandBar cbCharacters;
    protected AppBarButton btnCreate;
    protected TilePane tpCharacters;
    protected HBox bxLayout;
    protected StupidSimpleSingleSelectionModel<CharacterHandle> selectionModel;
    protected ObservableList<CharacterHandle> handles = FXCollections.observableArrayList();
    protected Map<CharacterHandle, CharacterHandleBox> boxByHandle = new HashMap<CharacterHandle, CharacterHandleBox>();
    protected OptionalNodePane withDesc;

    public CharactersOverviewPage() {
        super(ResourceI18N.get((ResourceBundle)RES, (String)"page.title"));
        this.selectionModel = new StupidSimpleSingleSelectionModel<CharacterHandle>(this.handles);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.setOnEnterAction(ev -> logger.log(System.Logger.Level.WARNING, "onEnter: " + String.valueOf(ev)));
        this.setOnLeaveAction(ev -> logger.log(System.Logger.Level.WARNING, "onLeave: " + String.valueOf(ev)));
        this.refresh();
    }

    private void initComponents() {
        this.btnCreate = new AppBarButton(ResourceI18N.get((ResourceBundle)RES, (String)"button.create"), (IconElement)new SymbolIcon("add"));
        this.cbCharacters = new CommandBar();
        this.cbCharacters.getPrimaryCommands().add((Object)this.btnCreate);
        this.tpCharacters = new TilePane();
        this.tpCharacters.setPrefTileHeight(96.0);
        this.tpCharacters.setPrefTileWidth(330.0);
        this.tpCharacters.setHgap(10.0);
        this.tpCharacters.setVgap(10.0);
    }

    private void initLayout() {
        VBox bxMain = new VBox(10.0, new Node[]{this.cbCharacters, this.tpCharacters});
        VBox.setVgrow((Node)this.tpCharacters, (Priority)Priority.ALWAYS);
        bxMain.setMaxWidth(Double.MAX_VALUE);
        this.bxLayout = new HBox(20.0, new Node[]{bxMain});
        HBox.setHgrow((Node)bxMain, (Priority)Priority.ALWAYS);
        this.withDesc = new OptionalNodePane((Node)this.bxLayout, (Node)new Label(""));
        this.bxLayout.setMaxHeight(Double.MAX_VALUE);
        this.withDesc.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow((Node)this.withDesc, (Priority)Priority.ALWAYS);
        this.setContent((Node)this.withDesc);
    }

    private void initInteractivity() {
        this.btnCreate.setOnAction(ev -> this.createClicked());
        CharacterProviderLoader.getCharacterProvider().setListener(new CharacterProviderListener(){

            public void characterRemoved(CharacterHandle handle) {
                logger.log(System.Logger.Level.WARNING, "REMOVED");
                CharacterHandleBox box = CharactersOverviewPage.this.boxByHandle.get(handle);
                CharactersOverviewPage.this.handles.remove((Object)handle);
                CharactersOverviewPage.this.boxByHandle.remove(handle);
                if (box != null) {
                    CharactersOverviewPage.this.tpCharacters.getChildren().remove((Object)box);
                }
            }

            public void characterModified(CharacterHandle handle) {
                logger.log(System.Logger.Level.WARNING, "MODIFIED");
                CharactersOverviewPage.this.refresh();
            }

            public void characterAdded(CharacterHandle handle) {
                logger.log(System.Logger.Level.WARNING, "ADDED");
                CharactersOverviewPage.this.refresh();
            }
        });
        this.selectionModel.selectedItemProperty().addListener((ov, o, n) -> logger.log(System.Logger.Level.WARNING, "To Do: show PDF"));
        BabylonEventBus.add((BabylonEventListener)this);
        this.setOnDragEntered(ev -> this.onDragged((DragEvent)ev));
        this.setOnDragOver(ev -> this.onDragOver((DragEvent)ev));
        this.setOnDragDropped(ev -> this.onDragDropped((DragEvent)ev));
    }

    protected void onDragged(DragEvent event) {
        logger.log(System.Logger.Level.ERROR, "Drag entered: " + String.valueOf(event.getDragboard().getFiles()));
        if (event.getGestureSource() == this.withDesc) {
            return;
        }
        if (event.getGestureSource() == this.withDesc || event.getDragboard().hasString()) {
            // empty if block
        }
        event.consume();
    }

    protected void onDragOver(DragEvent event) {
        boolean foundXML = false;
        for (File file : event.getDragboard().getFiles()) {
            if (!file.exists() || !file.canRead() || !file.getName().toLowerCase().endsWith(".xml")) continue;
            foundXML = true;
        }
        if (event.getGestureSource() != this && event.getDragboard().hasFiles() && foundXML) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
        event.consume();
    }

    public void onDragDropped(DragEvent event) {
        boolean success = false;
        for (File file : event.getDragboard().getFiles()) {
            if (!file.exists() || !file.canRead() || !file.getName().toLowerCase().endsWith(".xml")) continue;
            logger.log(System.Logger.Level.WARNING, "TODO: Import {0}", file);
            try {
                byte[] raw = Files.readAllBytes(file.toPath());
                String fname = file.getName().substring(0, file.getName().length() - 4);
                this.importCharacter(raw, fname);
                success = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed to import character from " + String.valueOf(file), (Throwable)e);
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    protected void styleCharacterHandleBox(CharacterHandle charac, CharacterHandleBox card) {
    }

    private void initPerCharacterInteractivity(final CharacterHandle charac, final CharacterHandleBox card) {
        if (charac == null) {
            throw new NullPointerException("CharacterHandle may not be null");
        }
        card.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                logger.log(System.Logger.Level.WARNING, "Event " + String.valueOf(event.getEventType()) + " from " + String.valueOf(event.getSource()));
                if (event.getClickCount() == 1) {
                    logger.log(System.Logger.Level.DEBUG, "Clicked " + String.valueOf(charac));
                    boolean oldState = CharactersOverviewPage.this.selectionModel.isSelected(CharactersOverviewPage.this.handles.indexOf((Object)charac));
                    logger.log(System.Logger.Level.INFO, "Old state: " + oldState);
                    card.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, !oldState);
                    if (oldState) {
                        CharactersOverviewPage.this.selectionModel.clearSelection(CharactersOverviewPage.this.handles.indexOf((Object)charac));
                    } else {
                        CharactersOverviewPage.this.selectionModel.select(CharactersOverviewPage.this.handles.indexOf((Object)charac));
                    }
                    if (!oldState && charac.getCharacter() == null) {
                        StringWriter buf;
                        logger.log(System.Logger.Level.INFO, "Trying to load character " + String.valueOf(charac));
                        Attachment attach = null;
                        try {
                            attach = CharacterProviderLoader.getCharacterProvider().getFirstAttachment(charac, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC);
                        }
                        catch (Exception e) {
                            logger.log(System.Logger.Level.ERROR, "Error loading character attachment", (Throwable)e);
                            buf = new StringWriter();
                            e.printStackTrace(new PrintWriter(buf));
                            AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)"error.loading.char.title"), (String)ResourceI18N.format((ResourceBundle)RES, (String)"error.loading.char.message", (Object[])new Object[]{buf.toString()}));
                        }
                        if (attach == null) {
                            logger.log(System.Logger.Level.WARNING, "No rule-specific character attachment for handle " + String.valueOf(charac));
                            return;
                        }
                        try {
                            RuleSpecificCharacterObject<?, ?, ?, ?> parsed = CharactersOverviewPage.this.loadRuleSpecific(attach.getData());
                            logger.log(System.Logger.Level.INFO, "Parsed character: " + String.valueOf(parsed));
                            charac.setCharacter(parsed);
                            charac.setShortDescription(parsed.getShortDescription());
                            card.setHandle(charac);
                        }
                        catch (CharacterIOException e) {
                            e.setPath(String.valueOf(attach.getLocalFile()));
                            logger.log(System.Logger.Level.ERROR, "Error parsing character attachment " + String.valueOf(attach.getLocalFile()), (Throwable)e);
                            CharactersOverviewPage.this.showException(e);
                        }
                        catch (Exception e) {
                            logger.log(System.Logger.Level.ERROR, "Error parsing character attachment", (Throwable)e);
                            buf = new StringWriter();
                            e.printStackTrace(new PrintWriter(buf));
                            AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)"error.loading.char.title"), (String)ResourceI18N.format((ResourceBundle)RES, (String)"error.loading.char.message", (Object[])new Object[]{buf.toString()}));
                        }
                    }
                }
                if (event.getClickCount() >= 2) {
                    logger.log(System.Logger.Level.DEBUG, "Double Clicked " + String.valueOf(charac));
                    CharactersOverviewPage.this.openClicked(charac);
                }
            }
        });
        card.setOnDelete((EventHandler<ActionEvent>)((EventHandler)ev -> {
            logger.log(System.Logger.Level.INFO, "Delete");
            this.deleteClicked(charac);
        }));
        card.setOnOpen((EventHandler<ActionEvent>)((EventHandler)ev -> {
            logger.log(System.Logger.Level.INFO, "Open " + charac.getName());
            this.openClicked(charac);
        }));
        card.setOnExport((EventHandler<ActionEvent>)((EventHandler)ev -> {
            logger.log(System.Logger.Level.WARNING, "Export");
            this.exportClicked(charac);
        }));
        card.setOnOpenDir((EventHandler<ActionEvent>)((EventHandler)ev -> {
            logger.log(System.Logger.Level.INFO, "Open Directory");
            this.openDirectoryClicked(charac);
        }));
    }

    public void setResponsiveMode(WindowMode value) {
        logger.log(System.Logger.Level.WARNING, "***ToDo**********Set mode to " + String.valueOf(value));
    }

    protected abstract CharacterGenerator<?, ?> createCharacterGenerator();

    protected abstract CharacterController<?, ?> createCharacterController(RuleSpecificCharacterObject<?, ?, ?, ?> var1, CharacterHandle var2);

    protected abstract CharacterViewLayout<?, ?, ?> createCharacterAppLayout(CharacterController<?, ?> var1);

    protected abstract RuleSpecificCharacterObject<?, ?, ?, ?> loadRuleSpecific(byte[] var1) throws Exception;

    private void createClicked() {
        logger.log(System.Logger.Level.INFO, "ENTER createClicked()---------------------------------------------------------------------");
        try {
            CharacterGenerator<?, ?> charGen = this.createCharacterGenerator();
            CharacterViewLayout<?, ?, ?> layout = this.createCharacterAppLayout((CharacterController<?, ?>)charGen);
            logger.log(System.Logger.Level.DEBUG, "open character view layout " + String.valueOf(layout));
            logger.log(System.Logger.Level.DEBUG, "open character view layout2 " + String.valueOf(this.getAppLayout()));
            this.getAppLayout().getApplication().openScreen(layout);
            logger.log(System.Logger.Level.DEBUG, "calling startCreation() on " + String.valueOf(((Object)layout).getClass()));
            charGen.runProcessors();
            layout.startCreation(charGen);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.ERROR, "Error on createClicked()", (Throwable)e);
        }
        finally {
            logger.log(System.Logger.Level.INFO, "LEAVE createClicked()---------------------------------------------------------------------");
        }
    }

    protected abstract List<CharacterHandle> loadCharacters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        logger.log(System.Logger.Level.TRACE, "ENTER refresh()");
        try {
            this.tpCharacters.getChildren().clear();
            List<CharacterHandle> list = this.loadCharacters();
            this.handles.setAll(list);
            this.boxByHandle.clear();
            for (CharacterHandle charac : list) {
                CharacterHandleBox card = new CharacterHandleBox();
                card.getStyleClass().addAll((Object[])new String[]{"grid-cell", "character-handle-box"});
                logger.log(System.Logger.Level.DEBUG, "handle {0} / {1} has char {2}", charac.getUUID(), charac.getName(), charac.getCharacter());
                if (charac.getCharacter() != null) {
                    if (charac.getCharacter().isInCareerMode()) {
                        card.getStyleClass().add((Object)"career-mode");
                    } else {
                        card.getStyleClass().add((Object)"chargen-mode");
                    }
                }
                card.setHandle(charac);
                this.boxByHandle.put(charac, card);
                card.setUserData(charac);
                this.styleCharacterHandleBox(charac, card);
                this.initPerCharacterInteractivity(charac, card);
                this.tpCharacters.getChildren().add((Object)card);
            }
            this.selectionModel.getSelectedItems().addListener((ListChangeListener)new ListChangeListener<CharacterHandle>(){

                public void onChanged(ListChangeListener.Change<? extends CharacterHandle> c) {
                    while (c.next()) {
                        CharacterHandleBox box;
                        if (c.wasRemoved()) {
                            for (CharacterHandle index : c.getRemoved()) {
                                box = CharactersOverviewPage.this.boxByHandle.get(index);
                                if (box == null) {
                                    logger.log(System.Logger.Level.WARNING, "No CharacterHandleBox for index {0}", index);
                                    continue;
                                }
                                if (!c.getRemoved().contains(index)) continue;
                                box.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, false);
                            }
                        }
                        if (!c.wasAdded()) continue;
                        for (CharacterHandle index : c.getRemoved()) {
                            box = CharactersOverviewPage.this.boxByHandle.get(index);
                            if (!c.getAddedSubList().contains(index)) continue;
                            box.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, true);
                        }
                    }
                }
            });
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE refresh()");
        }
    }

    public void characterAdded(CharacterHandle handle) {
        this.refresh();
    }

    public void characterModified(CharacterHandle handle) {
        this.refresh();
    }

    public void characterRemoved(CharacterHandle handle) {
        this.refresh();
    }

    private void deleteClicked(CharacterHandle selected) {
        logger.log(System.Logger.Level.DEBUG, "Delete " + String.valueOf(selected));
        CloseType response = AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.CONFIRMATION, (String)ResourceI18N.get((ResourceBundle)RES, (String)"confirm.delete.char"), (String)ResourceI18N.format((ResourceBundle)RES, (String)"confirm.delete.char.long", (Object[])new Object[]{selected.getRuleIdentifier().getName(Locale.getDefault()), selected.getName()}));
        logger.log(System.Logger.Level.DEBUG, "Response was " + String.valueOf(response));
        if (response == CloseType.OK || response == CloseType.YES) {
            logger.log(System.Logger.Level.INFO, "delete character " + String.valueOf(selected));
            try {
                CharacterProvider charProv = CharacterProviderLoader.getCharacterProvider();
                charProv.deleteCharacter(selected);
            }
            catch (Exception e) {
                StringWriter buf = new StringWriter();
                e.printStackTrace(new PrintWriter(buf));
                AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)"error.deleting.char.title"), (String)ResourceI18N.format((ResourceBundle)RES, (String)"error.deleting.char.message", (Object[])new Object[]{buf.toString()}));
            }
        }
    }

    private void openClicked(CharacterHandle charac) {
        logger.log(System.Logger.Level.DEBUG, "open " + String.valueOf(charac));
        RuleSpecificCharacterObject model = charac.getCharacter();
        if (model == null) {
            logger.log(System.Logger.Level.ERROR, "No character attachment in character " + charac.getName());
            return;
        }
        logger.log(System.Logger.Level.DEBUG, "Create character controller");
        CharacterController<?, ?> controller = this.createCharacterController(model, charac);
        logger.log(System.Logger.Level.DEBUG, "Created character controller: {0}", controller);
        logger.log(System.Logger.Level.DEBUG, "Create CharacterViewLayout");
        CharacterViewLayout<?, ?, ?> view = this.createCharacterAppLayout(controller);
        logger.log(System.Logger.Level.DEBUG, "Created CharacterViewLayout " + String.valueOf(view));
        view.setController(controller);
        if (!model.isInCareerMode()) {
            logger.log(System.Logger.Level.INFO, "Continue creation for " + String.valueOf(model) + " using " + String.valueOf(((Object)view).getClass()));
            this.getAppLayout().getApplication().openScreen(view);
            logger.log(System.Logger.Level.INFO, "Call continueCreation");
            view.continueCreation(model, charac);
        } else {
            logger.log(System.Logger.Level.INFO, "Edit in career mode for " + String.valueOf(model) + " using " + String.valueOf(((Object)view).getClass()));
            this.getAppLayout().getApplication().openScreen(view);
            view.edit(model, charac);
        }
    }

    public boolean needsCreationModeWarning(CharacterHandle charac) {
        return !charac.getCharacter().isInCareerMode();
    }

    public String getCreationModeWarning(CharacterHandle charac) {
        return ResourceI18N.get((ResourceBundle)CharacterExportPluginConfigPane.RES, (String)"dialog.exportcreationmodewarning.message");
    }

    protected void exportClicked(CharacterHandle charac) {
        logger.log(System.Logger.Level.WARNING, "export " + String.valueOf(charac));
        if (this.needsCreationModeWarning(charac)) {
            this.getAppLayout().getApplication().showAlertAndCall(AlertType.NOTIFICATION, "", this.getCreationModeWarning(charac));
        }
        CharacterExportPluginSelectorPane<RuleSpecificCharacterObject> selector = new CharacterExportPluginSelectorPane<RuleSpecificCharacterObject>(charac.getCharacter());
        ManagedDialog dialog = new ManagedDialog(ResourceI18N.get((ResourceBundle)CharacterExportPluginConfigPane.RES, (String)"dialog.exportpluginselector.title") + " " + charac.getName(), selector, new CloseType[]{CloseType.BACK});
        selector.setToClose((Node)dialog);
        this.getAppLayout().getApplication().showAlertAndCall(dialog, null);
    }

    private void openDirectoryClicked(CharacterHandle charac) {
        logger.log(System.Logger.Level.DEBUG, "open directory off " + String.valueOf(charac));
        logger.log(System.Logger.Level.WARNING, charac.getPath());
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.OPEN_FILE, (Object[])new Object[]{charac.getPath()});
    }

    private void showException(CharacterIOException e) {
        StringWriter buf = new StringWriter();
        if (e.getCause() != null) {
            e.getCause().printStackTrace(new PrintWriter(buf));
        } else {
            e.printStackTrace(new PrintWriter(buf));
        }
        Label trace = new Label(buf.toString());
        trace.setWrapText(true);
        VBox content = new VBox(5.0);
        Label errorName = new Label();
        Label errorExpl = new Label();
        errorName.getStyleClass().add((Object)"subtitle");
        String i18nKeyName = "error.chario." + e.getCode().name().toLowerCase() + ".title";
        String i18nKeyExplain = "error.chario." + e.getCode().name().toLowerCase() + ".explain";
        errorName.setText(ResourceI18N.get((ResourceBundle)RES, (String)i18nKeyName));
        errorExpl.setText(ResourceI18N.get((ResourceBundle)RES, (String)i18nKeyExplain));
        content.getChildren().addAll((Object[])new Node[]{errorExpl, trace});
        if (e.getPath() != null) {
            Label path = new Label(e.getPath());
            path.getStyleClass().add((Object)"base");
            content.getChildren().add(1, (Object)path);
        }
        AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)ResourceI18N.get((ResourceBundle)RES, (String)i18nKeyName), (Node)content);
    }

    protected void showAnyException(Exception e, RuleSpecificCharacterObject<?, ?, ?, ?> model, String title, String message) {
        StringWriter out = new StringWriter();
        if (e != null) {
            e.printStackTrace(new PrintWriter(out));
        }
        Label mess = new Label(message != null ? message : e.getMessage());
        Label trace = new Label(out.toString());
        mess.setWrapText(true);
        trace.setWrapText(true);
        AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)title, (Node)new VBox(10.0, new Node[]{mess, trace}));
    }

    public void handleAppEvent(BabylonEvent event) {
        logger.log(System.Logger.Level.DEBUG, "RCV " + String.valueOf(event));
        switch (event.getType()) {
            case CHAR_ADDED: 
            case CHAR_REMOVED: 
            case CHAR_MODIFIED: 
            case CHAR_RENAMED: {
                this.refresh();
            }
        }
    }

    protected abstract void importCharacter(byte[] var1, String var2) throws Exception;
}

