/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.wizard;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.chargen.CharacterGenerator;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.jfx.wizard.WizardPageGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.VBox;
import org.prelle.javafx.ResponsiveControlManager;

class CharacterGeneratorListCell<A extends IAttribute, C extends RuleSpecificCharacterObject<A, ?, ?, ?>, G extends CharacterGenerator<A, C>>
extends ListCell<Class<G>> {
    private static final System.Logger logger = System.getLogger(CharacterGeneratorListCell.class.getPackageName());
    private static PropertyResourceBundle RES = (PropertyResourceBundle)ResourceBundle.getBundle(WizardPageGenerator.class.getPackageName() + ".WizardPages");
    private Map<Class<G>, G> cache = new HashMap<Class<G>, G>();
    private VBox box;
    private Label lblHeading;
    private Label lblHardcopy;
    private Function<Class<G>, String[]> nameGetter;

    public CharacterGeneratorListCell(Function<Class<G>, String[]> nameGetter) {
        this.nameGetter = nameGetter;
        this.lblHeading = new Label();
        this.lblHeading.getStyleClass().add((Object)"base");
        this.lblHardcopy = new Label();
        this.box = new VBox(5.0);
        this.box.getChildren().addAll((Object[])new Node[]{this.lblHeading, this.lblHardcopy});
    }

    public void updateItem(Class<G> item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            switch (ResponsiveControlManager.getCurrentMode()) {
                case MINIMAL: {
                    this.setGraphic((Node)this.lblHeading);
                    break;
                }
                default: {
                    this.setGraphic((Node)this.box);
                }
            }
            try {
                if (this.cache.containsKey(item)) {
                    CharacterGenerator gen = (CharacterGenerator)this.cache.get(item);
                    this.lblHeading.setText(gen.getName());
                    this.lblHardcopy.setText(gen.getDescription());
                } else {
                    if (logger.isLoggable(System.Logger.Level.TRACE)) {
                        logger.log(System.Logger.Level.TRACE, "Need to create instance of Generator to obtain names: " + String.valueOf(item));
                    }
                    this.lblHeading.setText(this.nameGetter.apply(item)[0]);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed creating instance of Generator " + String.valueOf(item), (Throwable)e);
                this.lblHeading.setText(item.getSimpleName());
            }
            this.lblHardcopy.setUserData(item);
        }
    }
}

