/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.wizard;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.chargen.DataSetMode;
import de.rpgframework.genericrpg.chargen.IGeneratorWrapper;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.cells.DataSetListCell;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.prelle.javafx.OptionalNodePane;
import org.prelle.javafx.Wizard;
import org.prelle.javafx.WizardPage;

public class WizardPageDatasets
extends WizardPage {
    private static PropertyResourceBundle RES = (PropertyResourceBundle)ResourceBundle.getBundle(WizardPageDatasets.class.getPackageName() + ".WizardPages");
    private DataSet core;
    private List<DataSet> available;
    private IGeneratorWrapper<?, ?, ?> charGen;
    private ChoiceBox<DataSetMode> cbMode;
    private ListView<DataSet> listSelection;
    private OptionalNodePane optional;
    private GenericDescriptionVBox descr;

    public WizardPageDatasets(Wizard wizard, IGeneratorWrapper<?, ?, ?> model, List<DataSet> sets, DataSetMode ... modes) {
        super(wizard);
        this.setTitle(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.datasets.title"));
        this.charGen = model;
        for (DataSet set : sets) {
            if (!set.getID().equals("CORE")) continue;
            this.core = set;
            break;
        }
        this.available = sets.stream().filter(s -> s != this.core).collect(Collectors.toList());
        Collections.sort(this.available, new Comparator<DataSet>(){

            @Override
            public int compare(DataSet ds1, DataSet ds2) {
                int i = Integer.compare(ds1.getType().ordinal(), ds2.getType().ordinal());
                if (i != 0) {
                    return i;
                }
                i = Integer.compare(ds1.getReleased(), ds2.getReleased());
                if (i != 0) {
                    return i;
                }
                return ds1.getName(Locale.getDefault()).compareTo(ds2.getName(Locale.getDefault()));
            }
        });
        this.initComponents(modes);
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents(DataSetMode ... modes) {
        Label hdSource = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.datasets.available"));
        Label hdTarget = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.datasets.selected"));
        hdSource.getStyleClass().add((Object)"base");
        hdTarget.getStyleClass().add((Object)"base");
        this.cbMode = new ChoiceBox(FXCollections.observableArrayList((Object[])modes));
        this.cbMode.setConverter((StringConverter)new StringConverter<DataSetMode>(){

            public String toString(DataSetMode mode) {
                return mode == null ? "?" : ResourceI18N.get((ResourceBundle)RES, (String)("wizard.datasets.mode." + mode.name().toLowerCase()));
            }

            public DataSetMode fromString(String val) {
                return null;
            }
        });
        this.listSelection = new ListView<DataSet>(){};
        this.listSelection.getItems().setAll(this.available);
        this.listSelection.setCellFactory(lv -> new DataSetListCell((CommonCharacter)this.charGen.getModel()));
        this.listSelection.setStyle("-fx-max-width: 50em");
    }

    private void initLayout() {
        Label lbDescr = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.datasets.descr"));
        lbDescr.setWrapText(true);
        Label lbMode = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"wizard.datasets.mode"));
        HBox bxModeLine = new HBox(10.0, new Node[]{lbMode, this.cbMode});
        VBox content = new VBox(20.0, new Node[]{lbDescr, bxModeLine, this.listSelection});
        this.descr = new GenericDescriptionVBox(null, null);
        this.descr.setShowModificationsInDescription(false);
        this.optional = new OptionalNodePane((Node)content, (Node)this.descr);
        this.setContent((Node)this.optional);
    }

    private void initInteractivity() {
        this.listSelection.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> this.showHelpFor((DataSet)n));
        this.cbMode.valueProperty().addListener((ov, o, n) -> {
            ((CommonCharacter)this.charGen.getModel()).getDataSets().mode = n;
            this.listSelection.setDisable(n != DataSetMode.SELECTED);
        });
    }

    public void pageVisited() {
        CommonCharacter.DataSetControl control = ((CommonCharacter)this.charGen.getModel()).getDataSets();
        this.cbMode.setValue((Object)control.mode);
        ObservableList list = FXCollections.observableArrayList();
        block0: for (String id : control.selected) {
            for (DataSet set : this.available) {
                if (!set.getID().equals(id)) continue;
                list.add((Object)set);
                continue block0;
            }
        }
    }

    public void pageLeft() {
        this.charGen.runProcessors();
    }

    private void showHelpFor(DataSet set) {
        this.descr.setData(set.getName(Locale.getDefault()), null, set.getDescription(Locale.getDefault()));
    }
}

