package de.rpgframework.jfx;

import org.prelle.javafx.JavaFXConstants;

import de.rpgframework.genericrpg.data.DataItem;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

/**
 * @author prelle
 *
 */
public abstract class ADescriptionPane<T extends DataItem> extends VBox {
	
	protected Label descTitle;
	protected Label descSources;
	
	protected ADescriptionPane() {
		getStyleClass().add("description-pane");
		descTitle = new Label("");
		descTitle.getStyleClass().add(JavaFXConstants.STYLE_HEADING3);
		descSources = new Label("");
	}

	public abstract void setData(T value);

//	public abstract void setHideTitleAndSources(boolean hide); 

	public void setTitle(String title) {
		descTitle.setText(title);
	}

	public void setSources(String value) {
		descSources.setText(value);
	}
	
}
