package de.rpgframework.jfx.pages;

import java.util.List;
import java.util.ResourceBundle;

import org.prelle.javafx.OptionalNodePane;
import org.prelle.javafx.Page;
import org.prelle.javafx.ResponsiveControl;

import de.rpgframework.ResourceI18N;
import de.rpgframework.reality.BoughtItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

/**
 * @author prelle
 *
 */
public class ContentPacksPage extends Page implements ResponsiveControl {
	
	private final static ResourceBundle RES = ResourceBundle.getBundle(ContentPacksPage.class.getName());
	
	private OptionalNodePane optionalNode;
	
	protected VBox optional;
	protected VBox layout;
	protected ListView<BoughtItem> listView;

	//-------------------------------------------------------------------
	public ContentPacksPage() {
		super(ResourceI18N.get(RES, "page.contents.title"));
		initComponents();
		initLayout();
		initInteractivity();
	}
	
	//-------------------------------------------------------------------
	private void initComponents() {
		listView = new ListView<BoughtItem>();
		listView.setMaxHeight(Double.MAX_VALUE);
	}
	
	//-------------------------------------------------------------------
	private void initLayout() {
		optional = new VBox();
		Label infoText = new Label(ResourceI18N.get(RES, "page.contents.infotext"));
		infoText.setWrapText(true);
		
		listView.setMaxWidth(Double.MAX_VALUE);
		GridPane.setFillWidth(listView, true);
		
		optionalNode = new OptionalNodePane(listView, optional);
		optionalNode.setTitle("Hier steht ein Titel");
		optionalNode.setMaxWidth(Double.MAX_VALUE);
		VBox.setVgrow(optionalNode, Priority.ALWAYS);
		
		layout = new VBox(infoText, optionalNode);
		setContent(layout);
	}
	
	//-------------------------------------------------------------------
	private void initInteractivity() {
	}
	
	//-------------------------------------------------------------------
	public void setData(List<BoughtItem> data) {
		listView.getItems().setAll(data);
	}

}
