package de.rpgframework.jfx.rules;

import org.prelle.javafx.ResponsiveControl;
import org.prelle.javafx.WindowMode;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.jfx.rules.skin.EditCarriedItemPaneWideSkin;
import de.rpgframework.jfx.rules.skin.Properties;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

/**
 * 
 */
public class EditCarriedItemPane<T extends PieceOfGear<?, ?, ?, ?>> extends Control implements ResponsiveControl {
	
	private ObjectProperty<Node> primaryNode = new SimpleObjectProperty<Node>();
	private ObservableList<ItemCategory<?>> allowedCategories = FXCollections.observableArrayList();
	private ObservableMap<ItemCategory<?>, ObservableList<DataItem>> itemsInCategory = FXCollections.observableHashMap();

	private CarriedItem<T> model;
	
	//-------------------------------------------------------------------
	public EditCarriedItemPane(CarriedItem<T> model) {
		this.model = model;
	}

	//-------------------------------------------------------------------
	/**
	 * @see javafx.scene.control.Control#createDefaultSkin()
	 */
	public Skin<?> createDefaultSkin() {
		return new EditCarriedItemPaneWideSkin(this);
	}
	
	//-------------------------------------------------------------------
	public ObjectProperty<Node> primaryNodeProperty() { return primaryNode; }
	public Node getPrimaryNode() { return primaryNode.get(); }
	public EditCarriedItemPane<T> setPrimaryNode(Node value) { primaryNode.set(value); return this; }

	//-------------------------------------------------------------------
	public void refresh() {
	    getProperties().put(Properties.RECREATE, Boolean.TRUE);
	}

	//-------------------------------------------------------------------
	/**
	 * @see org.prelle.javafx.ResponsiveControl#setResponsiveMode(org.prelle.javafx.WindowMode)
	 */
	@Override
	public void setResponsiveMode(WindowMode value) {
		// TODO Auto-generated method stub
		
	}

	//-------------------------------------------------------------------
	public CarriedItem<T> getItem() { return model; }

}
