package de.rpgframework.jfx.rules.skin;

import org.prelle.javafx.EditableLabel;

import de.rpgframework.jfx.rules.EditCarriedItemPane;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

/**
 * 
 */
public class EditCarriedItemPaneWideSkin extends SkinBase<EditCarriedItemPane> {
	
	private VBox layout;
	private Label label;
	private Button btnEditTitle;
	private StackPane containerPrimaryNode;

	private MapChangeListener<Object, Object> propertiesMapListener = c -> {
        if (! c.wasAdded()) return;
        if (Properties.RECREATE.equals(c.getKey())) {
 //           refresh();
            getSkinnable().requestLayout();
            getSkinnable().getProperties().remove(Properties.RECREATE);
        }
    };

	//-------------------------------------------------------------------
	public EditCarriedItemPaneWideSkin(EditCarriedItemPane control) {
		super(control);
		initComponents();
		initLayout();
		initInteractivity();
	}

	//-------------------------------------------------------------------
	private void initComponents() {
		label = new Label(getSkinnable().getItem().getNameWithoutRating());
		System.out.println("...EditCarriedItemPaneWideSkin: "+getSkinnable().getItem());
		containerPrimaryNode = new StackPane();
		containerPrimaryNode.setMinSize(400, 100);
		if (getSkinnable().getPrimaryNode()!=null) {
			containerPrimaryNode.getChildren().add(getSkinnable().getPrimaryNode());
		}
	}

	//-------------------------------------------------------------------
	private void initLayout() {
		layout = new VBox(20, new Label("Test"),label,containerPrimaryNode);
		layout.setStyle("-fx-background-color: rgba(255,255,255,0.9)");
		layout.setMaxSize(800, 400);
		
		getChildren().add(layout);
	}

	//-------------------------------------------------------------------
	private void initInteractivity() {
		getSkinnable().primaryNodeProperty().addListener( (ov,o,n) -> {
			if (o!=null)
				containerPrimaryNode.getChildren().remove( (Node)o);
			if (n!=null)
				containerPrimaryNode.getChildren().add(0, (Node)n);
		});
	}

}
