/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.PartialController;
import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.chargen.RecommendingController;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.jfx.GenericDescriptionVBox;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.OptionalNodePane;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.WindowMode;

public class ChoiceManyDialog
extends ManagedDialog {
    public static final System.Logger logger = System.getLogger("rpgframework.jfx");
    private String modText;
    private DataItem decideFor;
    private Choice choice;
    private List<Object> options;
    private PartialController<?> control;
    private OptionalNodePane pane;
    private GenericDescriptionVBox bxDescription;
    private ListView<Object> listView;
    private List<String> selections;
    private Decision decision;

    public ChoiceManyDialog(DataItem decideFor, Choice choice, String modText, List<?> options, PartialController<?> control) {
        super("", null, new CloseType[]{CloseType.CANCEL, CloseType.OK});
        this.decideFor = decideFor;
        this.modText = modText;
        this.choice = choice;
        this.options = options;
        this.control = control;
        if (control == null) {
            throw new NullPointerException();
        }
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.buttonDisabledProperty().put((Object)CloseType.OK, (Object)Boolean.FALSE);
        this.verifyOKButton();
    }

    private void initComponents() {
        this.selections = new ArrayList<String>();
        this.listView = new ListView();
        this.listView.getItems().addAll(this.options);
        if (this.choice.getCount() > 1) {
            this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        }
        this.bxDescription = new GenericDescriptionVBox(null, null);
        this.bxDescription.setStyle("-fx-max-width: 360px; -fx-min-width: 300px;");
    }

    private void initLayout() {
        Label lbModText = new Label(this.modText);
        VBox layout = new VBox(5.0, new Node[]{lbModText, this.listView});
        this.listView.setMaxHeight(Double.MAX_VALUE);
        this.listView.setStyle("-fx-max-width: 360px; -fx-min-width: 300px");
        this.listView.setCellFactory(lv -> new ListCell<Object>(){

            public void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    SymbolIcon symbol = new SymbolIcon("outlinestar");
                    RecommendingController recCtrl = ChoiceManyDialog.this.control.getCharacterController().getRecommendingControllerFor(item);
                    if (recCtrl != null) {
                        symbol.setManaged(true);
                        RecommendationState state = recCtrl.getRecommendationState(item);
                        if (state == null || state == RecommendationState.NEUTRAL) {
                            symbol.setVisible(false);
                        } else if (state == RecommendationState.RECOMMENDED) {
                            symbol.setVisible(true);
                            symbol.setSymbol("outlinestar");
                        } else if (state == RecommendationState.STRONGLY_RECOMMENDED) {
                            symbol.setVisible(true);
                            symbol.setSymbol("favorite");
                        }
                    } else {
                        symbol.setVisible(false);
                        symbol.setManaged(false);
                    }
                    this.setGraphic((Node)symbol);
                    if (item instanceof DataItem) {
                        this.setText(((DataItem)item).getName());
                    } else if (item instanceof DataItemValue) {
                        this.setText(((DataItemValue)item).getNameWithoutRating(Locale.getDefault()));
                    } else if (item instanceof Enum) {
                        try {
                            Method method = item.getClass().getMethod("getName", new Class[0]);
                            this.setText((String)method.invoke(item, new Object[0]));
                        }
                        catch (Exception e) {
                            this.setText(String.valueOf(item));
                        }
                    } else {
                        this.setText(String.valueOf(item));
                    }
                }
            }
        });
        VBox.setVgrow(this.listView, (Priority)Priority.SOMETIMES);
        this.pane = new OptionalNodePane();
        this.pane.setThreshold(WindowMode.COMPACT);
        this.pane.setContentGrow(Priority.SOMETIMES);
        this.pane.setContent((Node)layout);
        this.pane.setOptional((Node)this.bxDescription);
        super.setContent((Node)this.pane);
        super.setTitle(this.decideFor.getName());
    }

    private void initInteractivity() {
        this.listView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Object>(){

            public void onChanged(ListChangeListener.Change<? extends Object> c) {
                logger.log(System.Logger.Level.WARNING, "Selection changed " + c);
                ChoiceManyDialog.this.selections.clear();
                for (Object resolved : ChoiceManyDialog.this.listView.getSelectionModel().getSelectedItems()) {
                    String key = String.valueOf(resolved);
                    if (resolved instanceof Enum) {
                        key = ((Enum)resolved).name();
                        if (resolved instanceof Enum) {
                            try {
                                Method method = resolved.getClass().getMethod("getName", new Class[0]);
                                ChoiceManyDialog.this.bxDescription.setTitle((String)method.invoke(resolved, new Object[0]));
                            }
                            catch (Exception e) {
                                ChoiceManyDialog.this.bxDescription.setTitle(String.valueOf(resolved));
                            }
                        }
                    } else if (resolved instanceof DataItem) {
                        ChoiceManyDialog.this.bxDescription.setData((DataItem)resolved);
                        key = ((DataItem)resolved).getId();
                    } else if (resolved instanceof DataItemValue) {
                        ChoiceManyDialog.this.bxDescription.setData((DataItemValue)resolved);
                        key = ((DataItemValue)resolved).getKey();
                    }
                    ChoiceManyDialog.this.selections.add(key);
                }
                ChoiceManyDialog.this.verifyOKButton();
            }
        });
    }

    private void verifyOKButton() {
        boolean notGood = true;
        notGood = this.choice.getCount() > 0 ? this.selections.size() != this.choice.getCount() : this.selections.size() != 1;
        logger.log(System.Logger.Level.INFO, "Choice count = " + this.choice.getCount() + "   notGood=" + notGood);
        this.buttonDisabledProperty().put((Object)CloseType.OK, (Object)notGood);
    }

    public void onClose(CloseType closeType) {
        if (closeType == CloseType.OK) {
            String decidedKeys = String.join((CharSequence)",", this.selections);
            logger.log(System.Logger.Level.INFO, "Closing with decided keys = " + decidedKeys);
            this.decision = new Decision(this.choice, decidedKeys);
            this.control.decide((Object)this.decideFor, this.choice.getUUID(), this.decision);
        }
    }

    public Decision getDecision() {
        return this.decision;
    }
}

