/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.ADescriptionPane;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class GenericDescriptionVBox<T extends DataItem>
extends ADescriptionPane<T> {
    private static final ResourceBundle RES = ResourceBundle.getBundle(GenericDescriptionVBox.class.getName());
    private Function<Requirement, String> requirementResolver;
    private Function<Modification, String> modificationResolver;
    private BooleanProperty showModificationsInDescription = new SimpleBooleanProperty(true);
    private Label hdRequires;
    private Label requirements;
    private Label hdModifies;
    private Label modifications;

    public GenericDescriptionVBox(Function<Requirement, String> requirementResolver, Function<Modification, String> modificationResolver) {
        this.requirementResolver = requirementResolver;
        this.modificationResolver = modificationResolver;
        if (requirementResolver == null) {
            requirementResolver = req -> req.toString();
        }
        if (modificationResolver == null) {
            modificationResolver = req -> req.toString();
        }
        this.initExtraComponents();
        this.initExtraLayout();
    }

    public GenericDescriptionVBox(Function<Requirement, String> requirementResolver, Function<Modification, String> modificationResolver, T item) {
        this(requirementResolver, modificationResolver);
        this.setData(item);
        this.initExtraComponents();
        this.initExtraLayout();
    }

    @Override
    protected void initExtraComponents() {
        this.requirements = new Label();
        this.requirements.setWrapText(true);
        this.modifications = new Label();
        this.modifications.setWrapText(true);
    }

    @Override
    protected void initExtraLayout() {
        this.hdRequires = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.requires"));
        this.hdModifies = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.modifications"));
        this.hdRequires.getStyleClass().add((Object)"base");
        this.hdModifies.getStyleClass().add((Object)"base");
        this.inner.getChildren().addAll((Object[])new Node[]{this.hdModifies, this.modifications, this.hdRequires, this.requirements});
        VBox.setMargin((Node)this.hdModifies, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.hdRequires, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
    }

    @Override
    public void setData(DataItemValue<T> data) {
        if (data == null) {
            this.descTitle.setText(null);
            this.descSources.setText(null);
            this.requirements.setText(null);
            this.modifications.setText(null);
            return;
        }
        this.setData(data.getModifyable());
    }

    @Override
    public void setData(T data) {
        ArrayList<String> list;
        super.setData(data);
        if (data == null) {
            this.requirements.setText(null);
            this.modifications.setText(null);
            return;
        }
        if (data instanceof ComplexDataItem && !((ComplexDataItem)data).getRequirements().isEmpty()) {
            this.hdRequires.setVisible(true);
            this.hdRequires.setManaged(true);
            this.requirements.setVisible(true);
            this.requirements.setManaged(true);
            list = new ArrayList<String>();
            for (Requirement req : ((ComplexDataItem)data).getRequirements()) {
                if (this.requirementResolver != null) {
                    list.add(this.requirementResolver.apply(req));
                    continue;
                }
                list.add(String.valueOf(req));
            }
            this.requirements.setText(String.join((CharSequence)", ", list));
        } else {
            this.hdRequires.setVisible(false);
            this.hdRequires.setManaged(false);
            this.requirements.setVisible(false);
            this.requirements.setManaged(false);
        }
        if (data instanceof ComplexDataItem && !((ComplexDataItem)data).getOutgoingModifications().isEmpty() && this.showModificationsInDescription.get()) {
            this.hdModifies.setVisible(true);
            this.hdModifies.setManaged(true);
            this.modifications.setVisible(true);
            this.modifications.setManaged(true);
            list = new ArrayList();
            for (Requirement req : ((ComplexDataItem)data).getOutgoingModifications()) {
                String toAdd;
                if (req instanceof DataItemModification && String.valueOf(((DataItemModification)req).getReferenceType()).equals("HOOK") || (toAdd = this.modificationResolver != null ? this.modificationResolver.apply((Modification)req) : String.valueOf(req)) == null) continue;
                list.add(toAdd);
            }
            this.modifications.setText(String.join((CharSequence)", ", list));
        } else {
            this.hdModifies.setVisible(false);
            this.hdModifies.setManaged(false);
            this.modifications.setVisible(false);
            this.modifications.setManaged(false);
        }
    }

    @Override
    public void setData(String title, String source, String desc) {
        this.descTitle.setText(title);
        this.descSources.setText(source);
        RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, desc);
        this.hdRequires.setVisible(false);
        this.hdRequires.setManaged(false);
        this.hdModifies.setVisible(false);
        this.hdModifies.setManaged(false);
        this.requirements.setVisible(false);
        this.requirements.setManaged(false);
        this.modifications.setVisible(false);
        this.modifications.setManaged(false);
    }

    public void setResolver(Function<Requirement, String> requirementResolver) {
        this.requirementResolver = requirementResolver;
    }

    public void setModificationResolver(Function<Modification, String> modResolver) {
        this.modificationResolver = modResolver;
    }

    public BooleanProperty showModificationsInDescriptionProperty() {
        return this.showModificationsInDescription;
    }

    public Boolean isShowModificationsInDescription() {
        return this.showModificationsInDescription.get();
    }

    public GenericDescriptionVBox setShowModificationsInDescription(Boolean value) {
        this.showModificationsInDescription.set(value.booleanValue());
        return this;
    }

    @Override
    public BooleanProperty useScrollPaneProperty() {
        return this.useScrollPane;
    }

    @Override
    public Boolean isUseScrollPane() {
        return this.useScrollPane.get();
    }

    public GenericDescriptionVBox setUseScrollPane(Boolean value) {
        this.useScrollPane.set(value.booleanValue());
        return this;
    }
}

