/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.SelectionControllerNode;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class SelectionControlTwoColumnSkin<T extends DataItem, V extends DataItemValue<T>>
extends SkinBase<SelectionControllerNode<T, V>> {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private ListView<T> listPossible;
    private ListView<V> listSelected;
    private Label lblAvailable;
    private Label lblSelected;
    private Callback<ListView<T>, ListCell<T>> cfAvailable;
    private Callback<ListView<V>, ListCell<V>> cfSelected;
    private HBox columns;

    protected SelectionControlTwoColumnSkin(SelectionControllerNode<T, V> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.cfAvailable = new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> param) {
                ListCell cell = ((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getAvailableCellFactory() != null ? (ListCell)((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getAvailableCellFactory().call(param) : SelectionControlTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> SelectionControlTwoColumnSkin.this.mouseClickedAvailable(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> SelectionControlTwoColumnSkin.this.dragDetectedAvailable(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.cfSelected = new Callback<ListView<V>, ListCell<V>>(){

            public ListCell<V> call(ListView<V> param) {
                ListCell cell = ((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getSelectedCellFactory() != null ? (ListCell)((SelectionControllerNode)SelectionControlTwoColumnSkin.this.getSkinnable()).getSelectedCellFactory().call(param) : SelectionControlTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> SelectionControlTwoColumnSkin.this.mouseClickedSelected(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> SelectionControlTwoColumnSkin.this.dragDetectedSelected(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.listPossible = new ListView();
        this.listPossible.setCellFactory(this.cfAvailable);
        this.listPossible.itemsProperty().bind(((SelectionControllerNode)this.getSkinnable()).availableProperty());
        this.listSelected = new ListView();
        this.listSelected.setCellFactory(this.cfSelected);
        this.listSelected.itemsProperty().bind(((SelectionControllerNode)this.getSkinnable()).selectedProperty());
        this.lblAvailable = new Label(" " + ((SelectionControllerNode)this.getSkinnable()).getAvailableHeading());
        this.lblSelected = new Label(" " + ((SelectionControllerNode)this.getSkinnable()).getSelectedHeading());
        this.lblAvailable.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.lblSelected.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.listPossible.setStyle(((SelectionControllerNode)this.getSkinnable()).getAvailableStyle());
        this.listSelected.setStyle(((SelectionControllerNode)this.getSkinnable()).getSelectedStyle());
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
        this.columns = new HBox();
        this.columns.setStyle("-fx-spacing: 1em;");
        this.getChildren().add((Object)this.columns);
    }

    private void initLayout() {
        this.columns.getChildren().clear();
        if (((SelectionControllerNode)this.getSkinnable()).getShowHeadings()) {
            VBox col1 = new VBox(new Node[]{this.lblAvailable, this.listPossible});
            VBox col2 = new VBox(new Node[]{this.lblSelected, this.listSelected});
            col1.setStyle("-fx-spacing: 1em");
            col2.setStyle("-fx-spacing: 1em");
            VBox.setVgrow(this.listPossible, (Priority)Priority.ALWAYS);
            VBox.setVgrow(this.listSelected, (Priority)Priority.ALWAYS);
            this.columns.getChildren().addAll((Object[])new Node[]{col1, col2});
        } else {
            this.columns.getChildren().addAll((Object[])new Node[]{this.listPossible, this.listSelected});
        }
    }

    private void initInteractivity() {
        ((SelectionControllerNode)this.getSkinnable()).showHeadingsProperty().addListener((ov, o, n) -> this.initLayout());
        ((SelectionControllerNode)this.getSkinnable()).availableHeadingProperty().addListener((ov, o, n) -> this.lblAvailable.setText(" " + n));
        ((SelectionControllerNode)this.getSkinnable()).selectedHeadingProperty().addListener((ov, o, n) -> this.lblSelected.setText(" " + n));
        ((SelectionControllerNode)this.getSkinnable()).availableStyleProperty().addListener((ov, o, n) -> this.listPossible.setStyle(n));
        ((SelectionControllerNode)this.getSkinnable()).selectedStyleProperty().addListener((ov, o, n) -> this.listSelected.setStyle(n));
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((SelectionControllerNode)this.getSkinnable()).setShowHelpFor(n));
        this.listSelected.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((SelectionControllerNode)this.getSkinnable()).setShowHelpFor(n != null ? n.getModifyable() : null));
        this.listPossible.setOnDragOver(ev -> this.dragOverAvailable((DragEvent)ev));
        this.listSelected.setOnDragOver(ev -> this.dragOverSelected((DragEvent)ev));
        this.listPossible.setOnDragDropped(ev -> this.dragDroppedAvailable((DragEvent)ev));
        this.listSelected.setOnDragDropped(ev -> this.dragDroppedSelected((DragEvent)ev));
    }

    private static <T> ListCell<T> createDefaultCellImpl() {
        return new ListCell<T>(){

            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof Node) {
                    this.setText(null);
                    Node currentNode = this.getGraphic();
                    Node newNode = (Node)item;
                    if (currentNode == null || !currentNode.equals(newNode)) {
                        this.setGraphic(newNode);
                    }
                } else {
                    this.setText(item == null ? "null" : item.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    private void userSelects(T toSelect) {
        logger.log(System.Logger.Level.DEBUG, "userSelects(" + toSelect + ")");
        ComplexDataItemController ctrl = ((SelectionControllerNode)this.getSkinnable()).getController();
        if (ctrl.canBeSelected(toSelect, new Decision[0]).get()) {
            if (!ctrl.getChoicesToDecide(toSelect).isEmpty()) {
                List options = ctrl.getChoicesToDecide(toSelect);
                logger.log(System.Logger.Level.DEBUG, "called getOptions");
                if (((SelectionControllerNode)this.getSkinnable()).getOptionCallback() != null) {
                    Platform.runLater(() -> logger.log(System.Logger.Level.ERROR, "TODO;call getOptionCallback"));
                }
            } else {
                DataItemValue selected;
                logger.log(System.Logger.Level.DEBUG, "call select before: " + ((SelectionControllerNode)this.getSkinnable()).getSelected());
                OperationResult res = ctrl.select(toSelect, new Decision[0]);
                logger.log(System.Logger.Level.DEBUG, "call select after: " + ((SelectionControllerNode)this.getSkinnable()).getSelected());
                if (res.isPresent() && (selected = (DataItemValue)res.get()) != null) {
                    this.listSelected.getItems().add((Object)selected);
                }
            }
        } else {
            logger.log(System.Logger.Level.DEBUG, "can not be Selected(" + toSelect + ")");
        }
    }

    private void mouseClickedAvailable(ListCell<T> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.userSelects((DataItem)cell.getItem());
            ((SelectionControllerNode)this.getSkinnable()).refresh();
        }
    }

    private void mouseClickedSelected(ListCell<V> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2 && ((SelectionControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)cell.getItem()).get()) {
            ((SelectionControllerNode)this.getSkinnable()).getController().deselect((DataItemValue)cell.getItem());
        }
    }

    protected void dragDetectedAvailable(ListCell<T> cell, MouseEvent event) {
        DataItem data = (DataItem)cell.getItem();
        if (data == null) {
            return;
        }
        if (!((SelectionControllerNode)this.getSkinnable()).getController().canBeSelected(data, new Decision[0]).get()) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = data.getTypeString() + ":" + data.getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    protected void dragDetectedSelected(ListCell<V> cell, MouseEvent event) {
        DataItemValue data = (DataItemValue)cell.getItem();
        if (data == null) {
            return;
        }
        if (!((SelectionControllerNode)this.getSkinnable()).getController().canBeDeselected(data).get()) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = data.getModifyable().getTypeString() + ":" + data.getModifyable().getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    private void dragOverSelected(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            String enhanceID = event.getDragboard().getString();
            DataItem toSelect = null;
            for (DataItem tmp : ((SelectionControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = tmp.getTypeString() + ":" + tmp.getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null && ((SelectionControllerNode)this.getSkinnable()).getController().canBeSelected(toSelect, new Decision[0]).get()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
        }
    }

    private void dragDroppedSelected(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            DataItem toSelect = null;
            for (DataItem tmp : ((SelectionControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = tmp.getTypeString() + ":" + tmp.getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                this.userSelects(toSelect);
                ((SelectionControllerNode)this.getSkinnable()).refresh();
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void dragOverAvailable(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private void dragDroppedAvailable(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            DataItemValue toSelect = null;
            for (DataItemValue tmp : ((SelectionControllerNode)this.getSkinnable()).getController().getSelected()) {
                String cmp = tmp.getModifyable().getTypeString() + ":" + tmp.getModifyable().getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                ((SelectionControllerNode)this.getSkinnable()).getController().deselect(toSelect);
                ((SelectionControllerNode)this.getSkinnable()).refresh();
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }
}

