/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.SelectionControlTwoColumnSkin;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class SelectionControllerNode<T extends DataItem, V extends DataItemValue<T>>
extends Control {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private static final String DEFAULT_STYLE_CLASS = "selection-control";
    private ObjectProperty<ComplexDataItemController<T, V>> control;
    private ObjectProperty<ObservableList<T>> availableProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<ObservableList<V>> selectedProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> availableCellFactoryProperty;
    private ObjectProperty<Callback<ListView<V>, ListCell<V>>> selectedCellFactoryProperty;
    private ObjectProperty<BiFunction<T, List<?>, Decision[]>> optionCallbackProperty;
    private BooleanProperty showHeadingsProperty;
    private StringProperty availableHeadingProperty;
    private StringProperty selectedHeadingProperty;
    private StringProperty availablePlaceholderProperty;
    private StringProperty selectedPlaceholderProperty;
    private ObjectProperty<T> showHelpForProperty;
    private StringProperty availableStyleProperty;
    private StringProperty selectedStyleProperty;

    public SelectionControllerNode(ComplexDataItemController<T, V> control) {
        if (control == null) {
            throw new NullPointerException("Controller may not be null");
        }
        this.control = new SimpleObjectProperty(control);
        this.availableCellFactoryProperty = new SimpleObjectProperty();
        this.selectedCellFactoryProperty = new SimpleObjectProperty();
        this.optionCallbackProperty = new SimpleObjectProperty();
        this.showHeadingsProperty = new SimpleBooleanProperty(true);
        this.availableHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.available"));
        this.selectedHeadingProperty = new SimpleStringProperty(RPGFrameworkJFXConstants.UI.getString("label.selected"));
        this.availablePlaceholderProperty = new SimpleStringProperty();
        this.selectedPlaceholderProperty = new SimpleStringProperty();
        this.showHelpForProperty = new SimpleObjectProperty();
        this.availableStyleProperty = new SimpleStringProperty();
        this.selectedStyleProperty = new SimpleStringProperty();
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.control.addListener((ov, o, n) -> this.refresh());
        this.refresh();
    }

    public Skin<?> createDefaultSkin() {
        return new SelectionControlTwoColumnSkin(this);
    }

    public ObjectProperty<ComplexDataItemController<T, V>> getControllerProperty() {
        return this.control;
    }

    public ComplexDataItemController<T, V> getController() {
        return (ComplexDataItemController)this.control.get();
    }

    public void setController(ComplexDataItemController<T, V> value) {
        this.control.set(value);
    }

    public void refresh() {
        logger.log(System.Logger.Level.INFO, "SelectionControllerNode.refresh: " + ((ComplexDataItemController)this.control.get()).getSelected());
        try {
            ((ObservableList)this.availableProperty.get()).setAll((Collection)((ComplexDataItemController)this.control.get()).getAvailable());
            ((ObservableList)this.selectedProperty.get()).setAll((Collection)((ComplexDataItemController)this.control.get()).getSelected());
            logger.log(System.Logger.Level.DEBUG, "SelectionControllerNode.refresh2: " + this.selectedProperty.get());
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "SelectionControllerNode.refresh: done");
        }
    }

    public ObjectProperty<ObservableList<T>> availableProperty() {
        return this.availableProperty;
    }

    public ObservableList<T> getAvailable() {
        return (ObservableList)this.availableProperty.get();
    }

    public ObjectProperty<ObservableList<V>> selectedProperty() {
        return this.selectedProperty;
    }

    public ObservableList<V> getSelected() {
        return (ObservableList)this.selectedProperty.get();
    }

    public ObjectProperty<BiFunction<T, List<?>, Decision[]>> optionCallbackProperty() {
        return this.optionCallbackProperty;
    }

    public BiFunction<T, List<?>, Decision[]> getOptionCallback() {
        return (BiFunction)this.optionCallbackProperty.get();
    }

    public void setOptionCallback(BiFunction<T, List<?>, Decision[]> value) {
        this.optionCallbackProperty.setValue(value);
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> availableCellFactoryProperty() {
        return this.availableCellFactoryProperty;
    }

    public Callback<ListView<T>, ListCell<T>> getAvailableCellFactory() {
        return (Callback)this.availableCellFactoryProperty.get();
    }

    public void setAvailableCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.availableCellFactoryProperty.setValue(value);
    }

    public ObjectProperty<Callback<ListView<V>, ListCell<V>>> selectedCellFactoryProperty() {
        return this.selectedCellFactoryProperty;
    }

    public Callback<ListView<V>, ListCell<V>> getSelectedCellFactory() {
        return (Callback)this.selectedCellFactoryProperty.get();
    }

    public void setSelectedCellFactory(Callback<ListView<V>, ListCell<V>> value) {
        this.selectedCellFactoryProperty.setValue(value);
    }

    public BooleanProperty showHeadingsProperty() {
        return this.showHeadingsProperty;
    }

    public boolean getShowHeadings() {
        return this.showHeadingsProperty.get();
    }

    public void setShowHeadings(boolean value) {
        this.showHeadingsProperty.set(value);
    }

    public StringProperty availableHeadingProperty() {
        return this.availableHeadingProperty;
    }

    public String getAvailableHeading() {
        return (String)this.availableHeadingProperty.get();
    }

    public void setAvailableHeading(String value) {
        this.availableHeadingProperty.set((Object)value);
    }

    public StringProperty selectedHeadingProperty() {
        return this.selectedHeadingProperty;
    }

    public String getSelectedHeading() {
        return (String)this.selectedHeadingProperty.get();
    }

    public void setSelectedHeading(String value) {
        this.selectedHeadingProperty.set((Object)value);
    }

    public StringProperty availablePlaceholderProperty() {
        return this.availablePlaceholderProperty;
    }

    public String getAvailablePlaceholder() {
        return (String)this.availablePlaceholderProperty.get();
    }

    public void setAvailablePlaceholder(String value) {
        this.availablePlaceholderProperty.set((Object)value);
    }

    public StringProperty selectedPlaceholderProperty() {
        return this.selectedPlaceholderProperty;
    }

    public String getSelectedPlaceholder() {
        return (String)this.selectedPlaceholderProperty.get();
    }

    public void setSelectedPlaceholder(String value) {
        this.selectedPlaceholderProperty.set((Object)value);
    }

    public ObjectProperty<T> showHelpForProperty() {
        return this.showHelpForProperty;
    }

    public T getShowHelpFor() {
        return (T)((DataItem)this.showHelpForProperty.get());
    }

    public void setShowHelpFor(T value) {
        this.showHelpForProperty.setValue(value);
    }

    public StringProperty availableStyleProperty() {
        return this.availableStyleProperty;
    }

    public String getAvailableStyle() {
        return (String)this.availableStyleProperty.get();
    }

    public void setAvailableStyle(String value) {
        this.availableStyleProperty.set((Object)value);
    }

    public StringProperty selectedStyleProperty() {
        return this.selectedStyleProperty;
    }

    public String getSelectedStyle() {
        return (String)this.selectedStyleProperty.get();
    }

    public void setSelectedStyle(String value) {
        this.selectedStyleProperty.set((Object)value);
    }
}

