/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;

public class StupidSimpleSingleSelectionModel<T>
extends MultipleSelectionModel<T> {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private ObservableList<T> list;
    private ObservableList<Integer> selectedIndices;
    private ObservableList<T> selectedItems;

    public StupidSimpleSingleSelectionModel(ObservableList<T> list) {
        this.list = list;
        this.selectedIndices = FXCollections.observableArrayList();
        this.selectedItems = FXCollections.observableArrayList();
        list.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                StupidSimpleSingleSelectionModel.this.refreshList();
            }
        });
        list.addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> c) {
                StupidSimpleSingleSelectionModel.this.refreshList();
            }
        });
    }

    private void refreshList() {
        this.selectedIndices.clear();
        for (T tmp : new ArrayList<T>(this.selectedItems)) {
            int index = this.list.indexOf(tmp);
            if (index == -1) {
                this.selectedItems.remove(tmp);
                continue;
            }
            this.selectedIndices.add((Object)index);
        }
    }

    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    public ObservableList<T> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectIndices(int index, int ... indices) {
        this.selectedIndices.clear();
        this.selectedItems.clear();
        this.selectedItems.add(this.list.get(index));
        this.selectedIndices.add((Object)index);
        for (int tmp : indices) {
            this.selectedItems.add(this.list.get(tmp));
            this.selectedIndices.add((Object)tmp);
        }
    }

    public void selectAll() {
        this.selectedItems.setAll(this.list);
        this.refreshList();
    }

    public void selectFirst() {
        if (this.list.isEmpty()) {
            return;
        }
        if (this.selectedIndices.contains((Object)0)) {
            return;
        }
        this.select(0);
    }

    public void selectLast() {
        if (this.list.isEmpty()) {
            return;
        }
        if (this.selectedIndices.contains((Object)(this.list.size() - 1))) {
            return;
        }
        this.select(this.list.size() - 1);
    }

    public void clearAndSelect(int index) {
        this.selectedIndices.clear();
        this.selectedItems.clear();
        this.select(index);
    }

    public void select(int index) {
        logger.log(System.Logger.Level.INFO, "select " + index + "  already=" + this.selectedIndices);
        if (this.selectedIndices.contains((Object)index)) {
            return;
        }
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.clearSelection();
        }
        if (index >= this.list.size()) {
            return;
        }
        Object val = this.list.get(index);
        this.selectedItems.add(val);
        this.selectedIndices.add((Object)index);
        this.setSelectedIndex(index);
        this.setSelectedItem(val);
        logger.log(System.Logger.Level.INFO, "Result: indices=" + this.selectedIndices + ", items=" + this.selectedItems + "   selected=" + this.getSelectedIndex());
    }

    public void select(T obj) {
        logger.log(System.Logger.Level.INFO, "select " + obj);
        if (!this.list.contains(obj)) {
            return;
        }
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.clearSelection();
        }
        int index = this.list.indexOf(obj);
        this.selectedItems.add(obj);
        this.selectedIndices.add((Object)index);
        this.setSelectedIndex(index);
        this.setSelectedItem(obj);
    }

    public void clearSelection(int index) {
        if (this.isSelected(index)) {
            this.selectedIndices.remove((Object)index);
            this.selectedItems.remove(this.list.get(index));
        }
        if (index == this.getSelectedIndex()) {
            this.setSelectedIndex(-1);
            this.setSelectedItem(null);
        }
    }

    public void clearSelection() {
        logger.log(System.Logger.Level.INFO, "clearSelection");
        this.setSelectedIndex(-1);
        this.setSelectedItem(null);
        this.selectedIndices.clear();
        this.selectedItems.clear();
    }

    public boolean isSelected(int index) {
        return this.selectedIndices.contains((Object)index);
    }

    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    public void selectPrevious() {
        int prev = this.getSelectedIndex() - 1;
        if (prev >= 0) {
            this.select(prev);
        }
    }

    public void selectNext() {
        int next = this.getSelectedIndex() + 1;
        if (next >= this.list.size()) {
            this.select(next);
        }
    }
}

