/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.character.CharacterHandle;
import de.rpgframework.jfx.CharacterHandleBox;
import de.rpgframework.jfx.SelectingGridView;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.GridCell;

public class CharacterGridCell
extends GridCell<CharacterHandle> {
    private static final System.Logger logger = System.getLogger(CharacterGridCell.class.getPackageName());
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private CharacterHandleBox layout;

    public CharacterGridCell(SelectingGridView<CharacterHandle> gv) {
        this.setAccessibleRole(AccessibleRole.LIST_ITEM);
        this.layout = new CharacterHandleBox();
        this.initInteractivity();
        if (gv.getSelectionModel() != null) {
            this.addSelectionModelListener(gv);
        }
        this.getStyleClass().add((Object)"grid-cell");
    }

    private void initInteractivity() {
        this.layout.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                logger.log(System.Logger.Level.INFO, "Event " + event.getEventType() + " from " + event.getSource());
                if (event.getClickCount() == 1) {
                    logger.log(System.Logger.Level.DEBUG, "Clicked " + CharacterGridCell.this.getItem());
                    if (CharacterGridCell.this.getGridView() instanceof SelectingGridView) {
                        boolean oldState = ((SelectingGridView)CharacterGridCell.this.getGridView()).getSelectionModel().isSelected(CharacterGridCell.this.getIndex());
                        CharacterGridCell.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, !oldState);
                        if (oldState) {
                            ((SelectingGridView)CharacterGridCell.this.getGridView()).getSelectionModel().clearSelection(CharacterGridCell.this.getIndex());
                        } else {
                            ((SelectingGridView)CharacterGridCell.this.getGridView()).getSelectionModel().select(CharacterGridCell.this.getIndex());
                        }
                    }
                }
                if (event.getClickCount() >= 2) {
                    logger.log(System.Logger.Level.DEBUG, "Double Clicked " + CharacterGridCell.this.getItem());
                }
            }
        });
    }

    private void addSelectionModelListener(SelectingGridView<CharacterHandle> gv) {
        gv.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<CharacterHandle>(){

            public void onChanged(ListChangeListener.Change<? extends CharacterHandle> c) {
                CharacterHandle index = (CharacterHandle)CharacterGridCell.this.getItem();
                while (c.next()) {
                    if (c.wasRemoved() && c.getRemoved().contains(index)) {
                        CharacterGridCell.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, false);
                    }
                    if (!c.wasAdded() || !c.getAddedSubList().contains(index)) continue;
                    CharacterGridCell.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, true);
                }
            }
        });
    }

    public void updateItem(CharacterHandle item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.layout.setHandle(item);
            this.setGraphic((Node)this.layout);
        }
    }
}

