/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.action.Action;
import org.prelle.javafx.AlertType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.SymbolIcon;

public class ComplexDataItemValueListCell<T extends ComplexDataItem, V extends ComplexDataItemValue<T>>
extends ListCell<V> {
    public static final String ICON_PEN = "\ue1c2";
    private static final String NORMAL_STYLE = "complex-data-item-value-cell";
    protected static final System.Logger logger = System.getLogger(ComplexDataItemValueListCell.class.getPackageName());
    protected Supplier<ComplexDataItemController<T, V>> controlProvider;
    private List<CellAction> actions = new ArrayList<CellAction>();
    private List<Button> actionButtons = new ArrayList<Button>();
    protected List<Node> extraActionLineNodes = new ArrayList<Node>();
    protected HBox nameLine;
    protected Label decision;
    protected HBox decisionLine;
    protected TilePane flagLine;
    protected Separator sep = new Separator(Orientation.HORIZONTAL);
    protected HBox actionLine;
    protected VBox lines;
    protected Label lblRecom;
    protected Label name;
    protected Label lblLock;
    protected Button btnDec;
    protected Label lblVal;
    protected Button btnInc;
    protected HBox largeDecInc;

    public ComplexDataItemValueListCell(Supplier<ComplexDataItemController<T, V>> ctrlProv) {
        this.controlProvider = ctrlProv;
        this.initComponents();
        this.initStyle();
        this.initLayout();
        this.initInteractivity();
    }

    private void initComponents() {
        this.lblRecom = new Label();
        this.name = new Label();
        this.lblLock = new Label(null, (Node)new SymbolIcon("lock"));
        this.decision = new Label();
        this.decisionLine = new HBox(new Node[]{this.decision});
        this.flagLine = new TilePane();
        this.btnDec = new Button("\ue0c6");
        this.lblVal = new Label("?");
        this.btnInc = new Button("\ue0c5");
    }

    private void initStyle() {
        this.name.getStyleClass().add((Object)"base");
        this.lblVal.getStyleClass().add((Object)"text-subheader");
        this.btnDec.getStyleClass().add((Object)"mini-button");
        this.btnInc.getStyleClass().add((Object)"mini-button");
        this.getStyleClass().add((Object)NORMAL_STYLE);
    }

    private static Region buffer() {
        Region buf = new Region();
        buf.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)buf, (Priority)Priority.ALWAYS);
        return buf;
    }

    protected void initLayout() {
        this.lblLock.setMaxWidth(50.0);
        this.nameLine = new HBox(5.0);
        this.actionLine = new HBox(5.0);
        this.actionLine.setMaxWidth(Double.MAX_VALUE);
        this.actionLine.getStyleClass().add((Object)"caption");
        this.lines = new VBox(2.0);
        this.lines.getChildren().addAll((Object[])new Node[]{this.nameLine, this.decisionLine, this.flagLine, this.actionLine});
        this.lines.getChildren().add((Object)this.sep);
        this.largeDecInc = new HBox(2.0, new Node[]{this.btnDec, this.lblVal, this.btnInc});
        this.btnDec.setStyle("-fx-padding: 2px");
        this.lblVal.setStyle("-fx-padding: -5px 0 -8px 0");
        this.btnInc.setStyle("-fx-padding: 2px");
        this.largeDecInc.setStyle("-fx-padding: 0px");
        this.largeDecInc.setAlignment(Pos.CENTER);
        this.largeDecInc.setFillHeight(false);
        this.nameLine.setMaxWidth(Double.MAX_VALUE);
        this.nameLine.getChildren().addAll((Object[])new Node[]{this.lblRecom, this.name, ComplexDataItemValueListCell.buffer(), this.lblLock, this.largeDecInc});
        this.setAlignment(Pos.TOP_LEFT);
    }

    private void initInteractivity() {
        this.btnInc.setOnAction(event -> {
            logger.log(System.Logger.Level.DEBUG, "Increase " + this.getItem());
            ComplexDataItemController<T, V> charGen = this.controlProvider.get();
            OperationResult result = ((NumericalValueController)charGen).increase((NumericalValue)((ComplexDataItemValue)this.getItem()));
            if (result.wasSuccessful()) {
                this.updateItem((V)((ComplexDataItemValue)this.getItem()), false);
                this.getListView().refresh();
            } else {
                FlexibleApplication.getInstance().showAlertAndCall(AlertType.ERROR, "Darn!", result.getError());
            }
        });
        this.btnDec.setOnAction(event -> {
            logger.log(System.Logger.Level.DEBUG, "Decrease " + this.getItem());
            ComplexDataItemController<T, V> charGen = this.controlProvider.get();
            OperationResult result = ((NumericalValueController)charGen).decrease((NumericalValue)((ComplexDataItemValue)this.getItem()));
            if (result.wasSuccessful()) {
                this.updateItem((V)((ComplexDataItemValue)this.getItem()), false);
                this.getListView().refresh();
            } else {
                FlexibleApplication.getInstance().showAlertAndCall(AlertType.ERROR, "Darn!", result.getError());
            }
        });
        this.setOnDragDetected(event -> this.dragStarted((MouseEvent)event));
    }

    public ComplexDataItemValueListCell<T, V> addAction(CellAction action) {
        this.actions.add(action);
        Button btn = new Button(action.icon);
        btn.getStyleClass().add((Object)"mini-button");
        btn.setOnAction(ev -> action.executeAction((ComplexDataItemValue)this.getItem()));
        return this;
    }

    public void addExtraActionLine(Node node) {
        this.extraActionLineNodes.add(node);
    }

    private void dragStarted(MouseEvent event) {
        logger.log(System.Logger.Level.DEBUG, "drag started for " + this.getItem());
        if (this.getItem() == null) {
            return;
        }
        Node source = (Node)event.getSource();
        logger.log(System.Logger.Level.DEBUG, "drag src = " + source);
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = "qualityval:" + ((ComplexDataItem)((ComplexDataItemValue)this.getItem()).getModifyable()).getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    public void updateItem(V item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            ComplexDataItemController<T, V> charGen = this.controlProvider.get();
            this.updateNameLine(item, charGen);
            this.updateDecisionLine(item, charGen);
            this.updateContentLine(item, charGen);
            this.updateFlagsLine(item);
            this.updateDecInc(item, charGen);
            this.updateActions(item, charGen);
            this.setGraphic((Node)this.lines);
        }
    }

    private void updateNameLine(V item, ComplexDataItemController<T, V> ctrl) {
        RecommendationState recom;
        RecommendationState recommendationState = recom = ctrl != null ? ctrl.getRecommendationState(item) : null;
        if (recom == null || recom == RecommendationState.NEUTRAL) {
            this.lblRecom.setVisible(false);
            this.lblRecom.setManaged(false);
        } else {
            switch (recom) {
                case STRONGLY_RECOMMENDED: {
                    this.lblRecom.setText("*");
                    this.lblRecom.setStyle("-fx-text-fill: green");
                    break;
                }
                case RECOMMENDED: {
                    this.lblRecom.setText("+");
                    this.lblRecom.setStyle("-fx-text-fill: green");
                    break;
                }
                case UNRECOMMENDED: {
                    this.lblRecom.setText("-");
                    this.lblRecom.setStyle("-fx-text-fill: red");
                }
            }
        }
        this.name.setText(item.getNameWithoutRating());
        if (ctrl != null) {
            Possible removeable = ctrl.canBeDeselected(item);
            if (removeable != null) {
                this.lblLock.setVisible(!removeable.get());
                if (removeable.get()) {
                    this.lblLock.setTooltip(null);
                } else {
                    this.lblLock.setTooltip(new Tooltip("Auto-Injected"));
                }
            } else {
                this.lblLock.setVisible(false);
                logger.log(System.Logger.Level.ERROR, "Calling " + ctrl.getClass().getSimpleName() + ".canBeDeselected returned NULL");
            }
        } else {
            this.lblLock.setVisible(false);
        }
    }

    protected void updateDecisionLine(V item, ComplexDataItemController<T, V> ctrl) {
        this.decisionLine.setVisible(!item.getDecisions().isEmpty());
        this.decisionLine.setManaged(!item.getDecisions().isEmpty());
        if (ctrl != null) {
            this.decision.setText(item.getDecisionString(Locale.getDefault(), (CommonCharacter)ctrl.getModel()));
        }
    }

    private void updateContentLine(V item, ComplexDataItemController<T, V> ctrl) {
        Parent content = this.getContentNode(item);
        if (content != null) {
            this.lines.getChildren().setAll((Object[])new Node[]{this.nameLine, this.decisionLine, content, this.flagLine, this.actionLine, this.sep});
        } else {
            this.lines.getChildren().retainAll((Object[])new Node[]{this.nameLine, this.decisionLine, this.flagLine, this.actionLine, this.sep});
        }
    }

    private void updateFlagsLine(V item) {
        this.flagLine.getChildren().clear();
        for (String flag : this.getFlagsStringsToShow(item)) {
            Label lbFlag = new Label(flag);
            lbFlag.getStyleClass().add((Object)"item-flag");
            this.flagLine.getChildren().add((Object)lbFlag);
        }
        this.flagLine.setManaged(!this.flagLine.getChildren().isEmpty());
        this.flagLine.setVisible(!this.flagLine.getChildren().isEmpty());
    }

    private void updateDecInc(V item, ComplexDataItemController<T, V> ctrl) {
        ComplexDataItem data = (ComplexDataItem)item.getModifyable();
        this.lblVal.setText(" " + String.valueOf(item.getDistributed()) + " ");
        if (ctrl instanceof NumericalValueController && data.hasLevel()) {
            this.largeDecInc.setVisible(true);
            this.largeDecInc.setManaged(true);
            this.lblVal.setText(" " + String.valueOf(((NumericalValueController)ctrl).getValue(item)) + " ");
            this.btnDec.setDisable(!((NumericalValueController)ctrl).canBeDecreased(item).get());
            this.btnInc.setDisable(!((NumericalValueController)ctrl).canBeIncreased(item).get());
        } else {
            this.largeDecInc.setVisible(false);
            this.largeDecInc.setManaged(false);
        }
    }

    protected boolean canPerformAction(V item, CellAction action) {
        return true;
    }

    private void updateActions(V item, ComplexDataItemController<T, V> ctrl) {
        ArrayList<Button> replaceWith = new ArrayList<Button>();
        for (CellAction action : this.actions) {
            if (!this.canPerformAction(item, action)) continue;
            replaceWith.add(this.getActionButton(action, item));
        }
        this.actionButtons.clear();
        this.actionButtons.addAll(replaceWith);
        this.actionLine.getChildren().setAll(replaceWith);
        if (!this.extraActionLineNodes.isEmpty()) {
            Region buf = new Region();
            buf.setMaxWidth(Double.MAX_VALUE);
            this.actionLine.getChildren().add((Object)buf);
            this.actionLine.getChildren().addAll(this.extraActionLineNodes);
        }
    }

    private Button getActionButton(CellAction action, V item) {
        Button button = new Button(action.getText(), action.getGraphic());
        button.getStyleClass().add((Object)"mini-button");
        if (action.getGraphic() != null) {
            button.setText(null);
        }
        if (action.getLongText() != null) {
            button.setTooltip(new Tooltip(action.getLongText()));
        }
        button.setOnAction(ev -> action.executeAction(item));
        return button;
    }

    protected Parent getContentNode(V ref) {
        return null;
    }

    public List<String> getFlagsStringsToShow(V item) {
        return List.of();
    }

    public class CellAction
    extends Action {
        private String icon;
        private BiFunction<CellAction, V, OperationResult<?>> handler;

        public CellAction(String name, String icon, String tooltip, BiFunction<CellAction, V, OperationResult<?>> handler) {
            super(name);
            this.setEventHandler(event -> handler.apply(this, (ComplexDataItemValue)ComplexDataItemValueListCell.this.getItem()));
            Button btn = new Button(icon);
            btn.getStyleClass().add((Object)"mini-button");
            this.setGraphic((Node)btn);
            if (tooltip != null) {
                btn.setTooltip(new Tooltip(tooltip));
            }
            this.handler = handler;
        }

        public OperationResult<?> executeAction(V data) {
            return this.handler.apply(this, data);
        }
    }
}

