/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.fxml;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.ADescriptionPane;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.fxml.FilteredListPageController;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import org.prelle.javafx.ApplicationScreen;
import org.prelle.javafx.Page;
import org.prelle.javafx.PageBase;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.WindowMode;

public class ExtendedFilteredListPageController<T extends DataItem, C extends ListCell<T>, P extends ADescriptionPane<T>>
extends FilteredListPageController<T> {
    private transient Class<P> descriptionPaneClass;

    @Override
    @FXML
    public void initialize() {
        this.description.setVisible(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        this.description.setManaged(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        this.lvResult.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            if (n != null) {
                this.showAction(n);
            }
        });
        this.search.textProperty().addListener((ov, o, n) -> this.refreshList());
        this.btnOpen.setOnAction(ev -> this.page.toggleOpenClose());
    }

    @Override
    protected void showAction(T value) {
        this.description.setVisible(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        this.description.setManaged(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        if (ResponsiveControlManager.getCurrentMode() == WindowMode.MINIMAL) {
            try {
                Page toOpen = new Page(value.getName());
                ADescriptionPane box = (ADescriptionPane)((Object)this.descriptionPaneClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                box.setData(value);
                toOpen.setContent((Node)box);
                this.page.getAppLayout().getApplication().openScreen(new ApplicationScreen((PageBase)toOpen));
            }
            catch (Exception e) {
                RPGFrameworkJavaFX.logger.log(System.Logger.Level.ERROR, "Error opening " + this.descriptionPaneClass.getName(), (Throwable)e);
            }
        } else {
            try {
                ADescriptionPane box = (ADescriptionPane)((Object)this.descriptionPaneClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                box.setData(value);
                this.description.getChildren().add((Object)box);
            }
            catch (Exception e) {
                RPGFrameworkJavaFX.logger.log(System.Logger.Level.ERROR, "Error opening " + this.descriptionPaneClass.getName(), (Throwable)e);
            }
        }
    }

    public void setComponent(Page page, Supplier<Collection<T>> listProvider, Function<Requirement, String> resolver, Function<Modification, String> mResolver, Class<C> listCellClass, Class<P> descriptionPaneClass) {
        super.setComponent(page, listProvider, resolver, mResolver);
        this.descriptionPaneClass = descriptionPaneClass;
        page.getHeader().setText(ResourceI18N.get((ResourceBundle)this.resources, (String)"page.title"));
        boolean withDescription = ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL;
        this.description.setManaged(withDescription);
        this.description.setVisible(withDescription);
        this.lvResult.setCellFactory(lv -> {
            try {
                ListCell cell = (ListCell)listCellClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                cell.setOnMouseClicked(ev -> {
                    if (ev.getClickCount() == 2) {
                        this.showAction((DataItem)cell.getItem());
                    }
                });
                return cell;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                RPGFrameworkJavaFX.logger.log(System.Logger.Level.ERROR, "Error creating listcell", (Throwable)e);
                return null;
            }
        });
    }
}

