/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.fxml;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.fxml.GenericDescriptionBoxController;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import org.prelle.javafx.ApplicationScreen;
import org.prelle.javafx.Page;
import org.prelle.javafx.PageBase;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.WindowMode;

public class FilteredListPageController<T extends DataItem> {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    protected transient Page page;
    protected transient Supplier<Collection<T>> listProvider;
    protected transient Function<Requirement, String> resolver;
    protected transient Function<Modification, String> modResolver;
    @FXML
    protected ResourceBundle resources;
    @FXML
    protected FlowPane filterPane;
    @FXML
    protected ListView<T> lvResult;
    @FXML
    protected GenericDescriptionBoxController descriptionController;
    @FXML
    protected VBox description;
    @FXML
    protected Button btnOpen;
    @FXML
    protected TextField search;

    @FXML
    public void initialize() {
        this.description.setVisible(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        this.description.setManaged(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        this.lvResult.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            if (n != null) {
                this.showAction(n);
            }
        });
        this.search.textProperty().addListener((ov, o, n) -> this.refreshList());
        this.btnOpen.setOnAction(ev -> this.page.toggleOpenClose());
        this.lvResult.setCellFactory(lv -> {
            ListCell cell = new ListCell<T>(){

                public void updateItem(T item, boolean empty) {
                    super.updateItem(item, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(item.getName(Locale.getDefault()));
                    }
                }
            };
            cell.setOnMouseClicked(arg_0 -> this.lambda$initialize$3((ListCell)cell, arg_0));
            return cell;
        });
    }

    protected List<T> filterItems(List<T> input) {
        return input;
    }

    protected void refreshList() {
        List<T> list = new ArrayList<T>(this.listProvider.get());
        if (this.search.getText() != null && !this.search.getText().isBlank()) {
            list = list.stream().filter(crea -> crea.getName().toLowerCase().indexOf(this.search.getText().toLowerCase()) > -1).collect(Collectors.toList());
        }
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        this.lvResult.getItems().setAll(list);
    }

    protected void showAction(T value) {
        logger.log(System.Logger.Level.INFO, "Show FeatureType " + value);
        this.description.setVisible(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        this.description.setManaged(ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL);
        if (ResponsiveControlManager.getCurrentMode() == WindowMode.MINIMAL) {
            try {
                GenericDescriptionVBox<T> box = new GenericDescriptionVBox<T>(this.resolver, this.modResolver, value);
                Page toOpen = new Page(null, box);
                this.page.getAppLayout().getApplication().openScreen(new ApplicationScreen((PageBase)toOpen));
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error opening FeatureTypeDescriptionPage", (Throwable)e);
            }
        } else {
            this.descriptionController.setData((DataItem)value, this.resolver);
        }
    }

    public void setComponent(Page page, Supplier<Collection<T>> listProvider, Function<Requirement, String> resolver, Function<Modification, String> modResolver) {
        logger.log(System.Logger.Level.INFO, "setComponent()");
        this.page = page;
        this.listProvider = listProvider;
        this.resolver = resolver;
        this.modResolver = modResolver;
        boolean withDescription = ResponsiveControlManager.getCurrentMode() != WindowMode.MINIMAL;
        this.description.setManaged(withDescription);
        this.description.setVisible(withDescription);
        this.refreshList();
    }

    private /* synthetic */ void lambda$initialize$3(ListCell cell, MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.showAction((DataItem)cell.getItem());
        }
    }
}

