/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.pane;

import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarryMode;
import de.rpgframework.genericrpg.items.Hook;
import de.rpgframework.genericrpg.items.ItemFlag;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.jfx.ADescriptionPane;
import de.rpgframework.jfx.GenericDescriptionVBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.NavigButtonControl;
import org.prelle.javafx.OptionalNodePane;

public class AChoiceSelectorDialog<T extends ComplexDataItem, V extends ComplexDataItemValue<T>>
extends ManagedDialog
implements BiFunction<T, List<Choice>, Decision[]> {
    private static final System.Logger logger = System.getLogger(AChoiceSelectorDialog.class.getPackageName());
    private static final Choice VARIANT_CHOICE = new Choice(PieceOfGear.VARIANT, null);
    protected ComplexDataItemController<T, V> controller;
    protected CarryMode carry;
    protected T item;
    protected Hook hook;
    protected Lifeform<?, ?, ?> model;
    protected DataItemValue<?> context;
    protected List<Decision> suggestions = new ArrayList<Decision>();
    protected List<Decision> fixedDecisions = new ArrayList<Decision>();
    protected ChoiceSelectorCustomizer customizer;
    protected BiFunction<T, Decision[], Possible> selectionVerifier;
    protected BiFunction<T, PieceOfGearVariant, String> variantNameGetter;
    protected PieceOfGearVariant suggestedVariant;
    private transient Map<Choice, Decision> decisions = new LinkedHashMap<Choice, Decision>();
    private transient List<ItemFlag> selectedFlasgs = new ArrayList<ItemFlag>();
    private PieceOfGearVariant selectedVariant;
    private Map<PieceOfGearVariant, List<Node>> perVariantChoices = new HashMap<PieceOfGearVariant, List<Node>>();
    private transient boolean canBeLeftWithOK;
    private transient OptionalNodePane optional;
    private transient ADescriptionPane<T> descriptionNode = new GenericDescriptionVBox(null, null);
    private transient VBox content;
    private transient Label lbProblem;
    private transient NavigButtonControl btnCtrl;

    public String getTitle(T item) {
        return "Select for " + item.getName();
    }

    public String getExplainString(T item) {
        return "Configure your selection";
    }

    public String getVariantTitle(PieceOfGear item) {
        return "Variant";
    }

    public String getRegularVersionTitle(PieceOfGear item) {
        return "Regular";
    }

    public String getForcedChoiceTitle(T item, Choice choice) {
        return "Make some choices";
    }

    public String getForcedVariantChoiceTitle(PieceOfGearVariant<?> variant, Choice choice) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Decision[] apply(T item, List<Choice> choices) {
        Decision[] decisionArray;
        CloseType closed;
        block6: {
            logger.log(System.Logger.Level.INFO, "ENTER apply({0}, {1})", item, choices);
            this.item = item;
            this.content = new VBox(5.0);
            this.optional = new OptionalNodePane((Node)this.content, this.descriptionNode);
            this.lbProblem = new Label();
            this.lbProblem.setStyle("-fx-text-fill: -fx-accent");
            this.buttons.setAll((Object[])new CloseType[]{CloseType.OK, CloseType.CANCEL});
            for (CloseType type : this.buttons) {
                this.buttonDisabledProperty().put((Object)type, (Object)Boolean.FALSE);
            }
            this.setContent((Node)new VBox(10.0, new Node[]{this.optional, this.lbProblem}));
            closed = null;
            try {
                this.setTitle(this.getTitle());
                this.descriptionNode.setData(item);
                this.content.getChildren().clear();
                Label explain = new Label(this.getExplainString(item));
                explain.setWrapText(true);
                this.content.getChildren().add((Object)explain);
                if (item instanceof PieceOfGear && !((PieceOfGear)item).getVariants().isEmpty()) {
                    this.processVariants((PieceOfGear)item);
                }
                for (Choice choice : choices) {
                    logger.log(System.Logger.Level.WARNING, "Found choice {0} and controller {1}", choice, this.controller);
                    String forceTitle = this.getForcedChoiceTitle(item, choice);
                    List<Node> toAdd = this.processChoice(item, choice, forceTitle);
                    if (toAdd == null) continue;
                    this.content.getChildren().addAll(toAdd);
                }
                this.btnCtrl = new NavigButtonControl();
                this.btnCtrl.initialize(FlexibleApplication.getInstance(), (ManagedDialog)this);
                this.updateButtons();
                logger.log(System.Logger.Level.ERROR, "showAlertAndCall with btnCtrl=" + this.btnCtrl);
                closed = FlexibleApplication.getInstance().showAlertAndCall((ManagedDialog)this, this.btnCtrl);
                logger.log(System.Logger.Level.ERROR, "Closed with " + closed);
                if (closed != CloseType.CANCEL) break block6;
                decisionArray = null;
            }
            catch (Throwable throwable) {
                logger.log(System.Logger.Level.INFO, "LEAVE apply({0}, {1} with {2})", item, choices, closed);
                throw throwable;
            }
            logger.log(System.Logger.Level.INFO, "LEAVE apply({0}, {1} with {2})", item, choices, closed);
            return decisionArray;
        }
        decisionArray = this.getDecisions();
        logger.log(System.Logger.Level.INFO, "LEAVE apply({0}, {1} with {2})", item, choices, closed);
        return decisionArray;
    }

    private Decision[] getDecisions() {
        Decision[] ret = new Decision[this.decisions.size()];
        int i = 0;
        for (Map.Entry<Choice, Decision> entry : this.decisions.entrySet()) {
            ret[i] = entry.getValue();
            logger.log(System.Logger.Level.DEBUG, "Decision [{0}] = {1}", i, entry.getValue());
            ++i;
        }
        return ret;
    }

    private void updateButtons() {
        logger.log(System.Logger.Level.INFO, "updateButtons");
        Possible possible = null;
        possible = this.selectionVerifier != null ? this.selectionVerifier.apply(this.item, this.getDecisions()) : this.controller.canBeSelected(this.item, this.getDecisions());
        ToDoElement problem = possible.getMostSevere();
        if (problem == null) {
            this.lbProblem.setText(null);
        } else {
            this.lbProblem.setText(problem.getMessage(Locale.getDefault()));
            switch (problem.getSeverity()) {
                case STOPPER: {
                    this.lbProblem.setStyle("-fx-text-fill: -fx-accent");
                    break;
                }
                case WARNING: {
                    this.lbProblem.setStyle("-fx-text-fill: primary");
                    break;
                }
                case INFO: {
                    this.lbProblem.setStyle("-fx-text-fill: -fx-text-base-color");
                }
            }
        }
        logger.log(System.Logger.Level.INFO, "Item selection possible=={0}   btnCtrl={1}", possible, this.btnCtrl);
        if (this.btnCtrl != null) {
            if (!possible.getRequireDecisions() || problem != null && problem.getSeverity() != ToDoElement.Severity.INFO) {
                logger.log(System.Logger.Level.DEBUG, " disable OK");
                this.canBeLeftWithOK = false;
                this.btnCtrl.setDisabled(CloseType.OK, true);
                this.buttonDisabledProperty().put((Object)CloseType.OK, (Object)true);
            } else {
                logger.log(System.Logger.Level.DEBUG, " enable OK ");
                this.canBeLeftWithOK = true;
                this.btnCtrl.setDisabled(CloseType.OK, false);
                this.buttonDisabledProperty().put((Object)CloseType.OK, (Object)false);
            }
        } else {
            this.canBeLeftWithOK = possible.get();
            if (this.btnCtrl != null) {
                this.btnCtrl.setDisabled(CloseType.OK, !this.canBeLeftWithOK);
            }
            this.buttonDisabledProperty().put((Object)CloseType.OK, (Object)(!this.canBeLeftWithOK ? 1 : 0));
        }
    }

    private void processVariants(final PieceOfGear template) {
        logger.log(System.Logger.Level.INFO, "variants detected");
        this.addLabel(this.getVariantTitle(template));
        ChoiceBox cbVariants = new ChoiceBox();
        if (!template.requiresVariant()) {
            cbVariants.getItems().add(null);
        }
        cbVariants.getItems().addAll(template.getVariants());
        cbVariants.setConverter((StringConverter)new StringConverter<PieceOfGearVariant>(){

            public PieceOfGearVariant fromString(String value) {
                return null;
            }

            public String toString(PieceOfGearVariant value) {
                if (value == null) {
                    return AChoiceSelectorDialog.this.getRegularVersionTitle(template);
                }
                String name = template.getVariantName(value, Locale.getDefault());
                if (name.startsWith(template.getTypeString()) && AChoiceSelectorDialog.this.variantNameGetter != null) {
                    name = AChoiceSelectorDialog.this.variantNameGetter.apply(AChoiceSelectorDialog.this.item, value);
                }
                return name;
            }
        });
        cbVariants.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            logger.log(System.Logger.Level.INFO, "Chose variant {0}", n);
            this.selectedVariant = n;
            if (n == null) {
                this.decisions.remove(VARIANT_CHOICE);
            } else {
                this.decisions.put(VARIANT_CHOICE, new Decision(PieceOfGear.VARIANT, n.getId()));
            }
            this.updateButtons();
        });
        this.content.getChildren().add((Object)cbVariants);
        for (PieceOfGearVariant variant : template.getVariants()) {
            if (variant.getChoices() == null || variant.getChoices().isEmpty()) continue;
            ArrayList<Node> allVariantNodes = new ArrayList<Node>();
            for (Choice choice : variant.getChoices()) {
                String forceTitle = this.getForcedVariantChoiceTitle(variant, choice);
                List<Node> list = this.processChoice(this.item, choice, forceTitle);
                logger.log(System.Logger.Level.INFO, "Variant choice returned " + list);
                allVariantNodes.addAll(list);
            }
            this.perVariantChoices.put(variant, allVariantNodes);
            for (Node node : allVariantNodes) {
                node.setVisible(false);
                node.setManaged(false);
            }
        }
        if (this.suggestedVariant != null) {
            this.selectedVariant = this.suggestedVariant;
            cbVariants.getSelectionModel().select((Object)this.suggestedVariant);
        } else {
            cbVariants.getSelectionModel().select(0);
        }
        this.updateButtons();
    }

    private void processFlag(PieceOfGear item, ItemFlag flag) {
        logger.log(System.Logger.Level.DEBUG, "Flag " + flag);
        System.err.println("ChoiceSelectorDialog: Flag " + flag);
        CheckBox checkBox = new CheckBox(flag.getName());
        checkBox.selectedProperty().addListener((ov, o, n) -> {
            if (n.booleanValue()) {
                logger.log(System.Logger.Level.DEBUG, "Selected flag {0}", n);
                this.selectedFlasgs.add(flag);
            } else {
                logger.log(System.Logger.Level.DEBUG, "Deselected flag {0} again", n);
                this.selectedFlasgs.remove(flag);
            }
            this.updateButtons();
        });
        this.content.getChildren().add((Object)checkBox);
    }

    private Label addLabel(String title) {
        Label lbName = new Label(title);
        lbName.getStyleClass().add((Object)"base");
        return lbName;
    }

    private List<Node> processChoice(T item, Choice choice, String forceTitle) {
        Node nodeToAdd;
        logger.log(System.Logger.Level.DEBUG, "Choice " + choice);
        ArrayList<Node> ret = new ArrayList<Node>();
        Label label = this.addLabel(forceTitle == null ? item.getChoiceName(choice, Locale.getDefault()) : forceTitle);
        ret.add((Node)label);
        Node node = nodeToAdd = this.customizer != null ? this.customizer.processChoice(item, choice, this.decisions, c -> this.updateButtons()) : null;
        if (nodeToAdd != null) {
            ret.add(nodeToAdd);
        } else {
            logger.log(System.Logger.Level.ERROR, "No UI node to add for choice {0}", choice);
        }
        return ret;
    }

    public static interface ChoiceSelectorCustomizer {
        public <T extends ComplexDataItem> Node processChoice(T var1, Choice var2, Map<Choice, Decision> var3, Consumer<Choice> var4);
    }
}

