/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.rules;

import de.rpgframework.genericrpg.data.ASkillValue;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.ISkill;
import de.rpgframework.genericrpg.data.SkillSpecialization;
import de.rpgframework.genericrpg.data.SkillSpecializationValue;
import de.rpgframework.jfx.rules.SkillTable;
import java.util.Locale;
import javafx.collections.SetChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.SymbolIcon;

class SkillNameTableCell<A extends IAttribute, S extends ISkill, V extends ASkillValue<S>>
extends TableCell<V, String> {
    private static final System.Logger logger = System.getLogger("rpgframework.jfx.skill");
    private SkillTable<A, S, V> parent;
    private Button button;
    private StackPane stack;
    private Label lbName;
    private VBox box;

    public SkillNameTableCell(SkillTable<A, S, V> parent) {
        this.parent = parent;
        this.lbName = new Label();
        this.lbName.getStyleClass().add((Object)"base");
        this.lbName.setMaxWidth(Double.MAX_VALUE);
        this.box = new VBox(2.0, new Node[]{this.lbName});
        this.box.setAlignment(Pos.TOP_LEFT);
        this.button = new Button(null, (Node)new SymbolIcon("Edit"));
        this.button.getStyleClass().add((Object)"mini-button");
        this.button.setVisible(false);
        this.stack = new StackPane();
        this.stack.getChildren().addAll((Object[])new Node[]{this.box, this.button});
        StackPane.setAlignment((Node)this.button, (Pos)Pos.CENTER_RIGHT);
        StackPane.setAlignment((Node)this.lbName, (Pos)Pos.CENTER_LEFT);
        this.button.setOnAction(ev -> {
            Callback callback = parent.getActionCallback();
            logger.log(System.Logger.Level.INFO, "Clicked Edit - calling " + callback);
            if (callback != null) {
                CloseType close = (CloseType)callback.call((Object)((ASkillValue)this.getTableRow().getItem()));
                logger.log(System.Logger.Level.WARNING, "Returned " + close);
                if (close == CloseType.OK || close == CloseType.APPLY) {
                    parent.refresh();
                }
            } else {
                logger.log(System.Logger.Level.WARNING, "No callback to handle click on SkillTable");
            }
        });
        this.getPseudoClassStates().addListener((SetChangeListener)new SetChangeListener<PseudoClass>(){

            public void onChanged(SetChangeListener.Change<? extends PseudoClass> change) {
                if (change.getElementRemoved() != null && ((PseudoClass)change.getElementRemoved()).getPseudoClassName().equals("rowhover")) {
                    SkillNameTableCell.this.button.setVisible(false);
                }
                if (change.getElementAdded() != null && ((PseudoClass)change.getElementAdded()).getPseudoClassName().equals("rowhover")) {
                    SkillNameTableCell.this.button.setVisible(true);
                }
            }
        });
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.box.getChildren().retainAll((Object[])new Node[]{this.lbName});
            this.lbName.setText(item);
            ASkillValue sVal = (ASkillValue)this.getTableRow().getItem();
            if (sVal == null) {
                logger.log(System.Logger.Level.ERROR, "No tablerow item for '" + item + "'");
            } else if (!sVal.getSpecializations().isEmpty()) {
                for (SkillSpecializationValue tmp : sVal.getSpecializations()) {
                    if (tmp.getResolved() != null) {
                        Label lb = new Label("- " + ((SkillSpecialization)tmp.getResolved()).getName(Locale.getDefault()));
                        this.box.getChildren().add((Object)lb);
                        continue;
                    }
                    this.box.getChildren().add((Object)new Label("- " + tmp.getKey()));
                }
            }
            this.setGraphic((Node)this.stack);
        }
    }
}

