/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.skin;

import de.rpgframework.ResourceI18N;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.GenericRPGTools;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationChoice;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.DataItemDetailsPane;
import de.rpgframework.jfx.DataItemPane;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.cells.ChoiceCell;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.StringConverter;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.WindowMode;

public class DataItemDetailsPaneSkin<T extends DataItem>
extends SkinBase<DataItemDetailsPane<T>> {
    static final ResourceBundle RES = ResourceBundle.getBundle(DataItemPane.class.getName());
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private ListView<Choice> listView;
    private GenericDescriptionVBox tfDescription;
    private TabPane tabs;
    private Tab tbEffects = new Tab(ResourceI18N.get((ResourceBundle)RES, (String)"tab.effects"));
    private Tab tbChoices = new Tab(ResourceI18N.get((ResourceBundle)RES, (String)"tab.choices"));
    private Tab tbDescription = new Tab(ResourceI18N.get((ResourceBundle)RES, (String)"tab.description"));
    private Tab tbCustom1 = new Tab();
    private Tab tbCustom2 = new Tab();

    public DataItemDetailsPaneSkin(DataItemDetailsPane<T> control, Function<Requirement, String> reqR, Function<Modification, String> modR) {
        super(control);
        this.listView = new ListView();
        this.listView.setCellFactory(lv -> new ChoiceCell(new StringConverter<Choice>(){

            public String toString(Choice value) {
                if (((DataItemDetailsPane)DataItemDetailsPaneSkin.this.getSkinnable()).getChoiceConverter() != null) {
                    return ((DataItemDetailsPane)DataItemDetailsPaneSkin.this.getSkinnable()).getChoiceConverter().apply(value);
                }
                return String.valueOf(value);
            }

            public Choice fromString(String string) {
                return null;
            }
        }, () -> ((DataItemDetailsPane)this.getSkinnable()).getModel(), choice -> {
            RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "getSkinnable(): " + this.getSkinnable());
            ((DataItemDetailsPane)this.getSkinnable()).getDecisionHandler().accept(((DataItemDetailsPane)this.getSkinnable()).getSelectedItem(), (Choice)choice);
        }));
        this.tfDescription = new GenericDescriptionVBox(reqR, modR);
        this.tfDescription.showModificationsInDescriptionProperty().bind((ObservableValue)control.showModificationsInDescriptionProperty());
        this.tbEffects.setClosable(false);
        this.tbChoices.setClosable(false);
        this.tbDescription.setClosable(false);
        this.tbCustom1.setClosable(false);
        this.tbCustom2.setClosable(false);
        this.initInteractivity();
        this.refresh(ResponsiveControlManager.getCurrentMode());
        this.selectionChanged(control.getSelectedItem());
        this.updateTabs();
    }

    private void initInteractivity() {
        ((DataItemDetailsPane)this.getSkinnable()).layoutModeProperty().addListener((ov, o, n) -> this.refresh((WindowMode)n));
        ((DataItemDetailsPane)this.getSkinnable()).selectedItemProperty().addListener((ov, o, n) -> {
            logger.log(System.Logger.Level.ERROR, "selection of {1} changed to {0}", n, this.getSkinnable());
            this.selectionChanged(n);
            switch (ResponsiveControlManager.getCurrentMode()) {
                case EXPANDED: {
                    this.refreshExpanded();
                    break;
                }
                default: {
                    this.updateTabs();
                }
            }
        });
        ((DataItemDetailsPane)this.getSkinnable()).modelProperty().addListener((ov, o, n) -> this.listView.refresh());
        ((DataItemDetailsPane)this.getSkinnable()).showHelpForProperty().addListener((ov, o, n) -> this.tfDescription.setData(n));
    }

    private void selectionChanged(T n) {
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.DEBUG, "selectionChanged: {0}", n);
        Function<Modification, String> modConv = ((DataItemDetailsPane)this.getSkinnable()).getModificationConverter();
        if (n instanceof ComplexDataItem) {
            this.listView.setItems(FXCollections.observableArrayList((Collection)((ComplexDataItem)n).getChoices()));
        } else {
            this.listView.getItems().clear();
        }
        this.tfDescription.setData(n);
        this.refresh(ResponsiveControlManager.getCurrentMode());
    }

    private void refresh(WindowMode mode) {
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.DEBUG, "mode changed to {0}", mode);
        switch (mode) {
            case EXPANDED: {
                this.refreshExpanded();
                break;
            }
            default: {
                this.refreshAsTabs();
            }
        }
    }

    private void refreshExpanded() {
        this.listView.setStyle("-fx-min-width: 15em;");
        this.listView.setMaxHeight(Double.MAX_VALUE);
        Node contentStats = this.getContentStats();
        VBox column1 = new VBox(20.0);
        column1.setStyle("-fx-min-width: 15em; -fx-max-width: 20em");
        column1.getStyleClass().addAll((Object[])new String[]{"detail-card", "item-details-stats"});
        Label lbStats = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"tab.effects"));
        lbStats.getStyleClass().add((Object)"title");
        ScrollPane scrollStats = new ScrollPane(contentStats);
        scrollStats.setFitToWidth(true);
        VBox.setVgrow((Node)scrollStats, (Priority)Priority.ALWAYS);
        column1.getChildren().addAll((Object[])new Node[]{lbStats, scrollStats});
        VBox column2 = new VBox(20.0);
        column2.getStyleClass().addAll((Object[])new String[]{"detail-card", "item-detail-choices"});
        Label lbChoices = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"tab.choices"));
        lbChoices.getStyleClass().add((Object)"title");
        column2.getChildren().addAll((Object[])new Node[]{lbChoices, this.listView});
        Label lbDescr = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"tab.description"));
        lbDescr.getStyleClass().add((Object)"title");
        this.tfDescription.setMaxHeight(Double.MAX_VALUE);
        VBox column3 = new VBox(0.0);
        column3.getStyleClass().addAll((Object[])new String[]{"detail-card", "item-detail-description"});
        column3.getChildren().addAll((Object[])new Node[]{lbDescr, this.tfDescription});
        VBox.setVgrow((Node)this.tfDescription, (Priority)Priority.ALWAYS);
        column3.setMaxHeight(Double.MAX_VALUE);
        HBox columns = new HBox(20.0, new Node[]{column1, column3});
        columns.setFillHeight(true);
        columns.setMaxHeight(Double.MAX_VALUE);
        if (((DataItemDetailsPane)this.getSkinnable()).isShowDecisionColumn().booleanValue()) {
            columns.getChildren().add(1, (Object)column2);
        }
        if (!((DataItemDetailsPane)this.getSkinnable()).isShowStatsColumn().booleanValue()) {
            columns.getChildren().remove((Object)column1);
        }
        if (this.listView.getItems().isEmpty() || !((DataItemDetailsPane)this.getSkinnable()).isShowDecisionColumn().booleanValue()) {
            columns.getChildren().remove((Object)column2);
        }
        if (((DataItemDetailsPane)this.getSkinnable()).getCustomNode2() != null) {
            VBox columnC2 = new VBox(20.0);
            columnC2.getStyleClass().add((Object)"detail-card");
            Label lbCust2 = new Label(((DataItemDetailsPane)this.getSkinnable()).getCustomNode2().getTitle());
            lbCust2.getStyleClass().add((Object)"title");
            columnC2.getChildren().addAll((Object[])new Node[]{lbCust2, ((DataItemDetailsPane)this.getSkinnable()).getCustomNode2().getContent()});
            columns.getChildren().add(0, (Object)columnC2);
        }
        if (((DataItemDetailsPane)this.getSkinnable()).getCustomNode1() != null) {
            VBox columnC1 = new VBox(20.0);
            columnC1.getStyleClass().add((Object)"detail-card");
            Label lbCust1 = new Label(((DataItemDetailsPane)this.getSkinnable()).getCustomNode1().getTitle());
            lbCust1.getStyleClass().add((Object)"title");
            columnC1.getChildren().addAll((Object[])new Node[]{lbCust1, ((DataItemDetailsPane)this.getSkinnable()).getCustomNode1().getContent()});
            columns.getChildren().add(0, (Object)columnC1);
        }
        this.getChildren().clear();
        this.getChildren().add((Object)columns);
    }

    private void refreshAsTabs() {
        Node contentStats = this.getContentStats();
        this.listView.setMaxHeight(((DataItemDetailsPane)this.getSkinnable()).getHeight() * 0.7);
        this.tabs = new TabPane();
        this.tabs.getTabs().addAll((Object[])new Tab[]{this.tbEffects, this.tbDescription});
        if (((DataItemDetailsPane)this.getSkinnable()).isShowDecisionColumn().booleanValue()) {
            this.tabs.getTabs().add(1, (Object)this.tbChoices);
        }
        if (((DataItemDetailsPane)this.getSkinnable()).getScene() != null) {
            this.tabs.setMaxWidth(((DataItemDetailsPane)this.getSkinnable()).getScene().getWidth());
        }
        this.tbEffects.setContent(contentStats);
        this.tbChoices.setContent(this.listView);
        ScrollPane scrollDescr = new ScrollPane((Node)this.tfDescription);
        scrollDescr.setFitToWidth(true);
        scrollDescr.setMaxHeight(Double.MAX_VALUE);
        this.tbDescription.setContent((Node)scrollDescr);
        if (((DataItemDetailsPane)this.getSkinnable()).getCustomNode2() != null) {
            this.tbCustom2.setText(((DataItemDetailsPane)this.getSkinnable()).getCustomNode2().getTitle());
            this.tbCustom2.setContent(((DataItemDetailsPane)this.getSkinnable()).getCustomNode2().getContent());
            ((DataItemDetailsPane)this.getSkinnable()).getCustomNode2().getContent().setStyle("-fx-padding: 3px;");
            this.tabs.getTabs().add(0, (Object)this.tbCustom2);
        }
        if (((DataItemDetailsPane)this.getSkinnable()).getCustomNode1() != null) {
            this.tbCustom1.setText(((DataItemDetailsPane)this.getSkinnable()).getCustomNode1().getTitle());
            this.tbCustom1.setContent(((DataItemDetailsPane)this.getSkinnable()).getCustomNode1().getContent());
            ((DataItemDetailsPane)this.getSkinnable()).getCustomNode1().getContent().setStyle("-fx-padding: 3px;");
            this.tabs.getTabs().add(0, (Object)this.tbCustom1);
        }
        this.getChildren().clear();
        this.getChildren().add((Object)this.tabs);
    }

    private void updateTabs() {
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.INFO, "-------------------updateTabs(" + ((DataItemDetailsPane)this.getSkinnable()).getId() + ")--------------------- " + ((DataItemDetailsPane)this.getSkinnable()).getSelectedItem());
        this.tfDescription.setStyle("-fx-padding: 3px");
        this.tbEffects.setContent(this.getContentStats());
        this.tbChoices.setContent(this.listView);
        this.tbDescription.setContent((Node)this.tfDescription);
    }

    private Node getContentStats() {
        Object raw = ((DataItemDetailsPane)this.getSkinnable()).getSelectedItem();
        VBox contentStats = new VBox();
        RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "getContentStats() for {0} using {1}", raw, ((DataItemDetailsPane)this.getSkinnable()).getModificationConverter());
        if (raw instanceof ComplexDataItem) {
            ComplexDataItem item = (ComplexDataItem)raw;
            ModifiedObjectType previousType = null;
            Function<Modification, String> modConv = ((DataItemDetailsPane)this.getSkinnable()).getModificationConverter();
            for (Modification m : item.getOutgoingModifications()) {
                if (m.getReferenceType() != previousType) {
                    String category = String.valueOf(m.getReferenceType());
                    if (((DataItemDetailsPane)this.getSkinnable()).getReferenceTypeConverter() != null && m.getReferenceType() != null) {
                        category = ((DataItemDetailsPane)this.getSkinnable()).getReferenceTypeConverter().apply(m.getReferenceType());
                    }
                    if (category != null) {
                        Label head = new Label(category);
                        head.getStyleClass().add((Object)"base");
                        contentStats.getChildren().add((Object)head);
                        VBox.setMargin((Node)head, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
                    }
                }
                previousType = m.getReferenceType();
                Button button = null;
                Tooltip tooltip = null;
                RuleSpecificCharacterObject model = ((DataItemDetailsPane)this.getSkinnable()).getModel();
                String text = modConv != null ? modConv.apply(m) : String.valueOf(m);
                Text choiceText = new Text(text);
                choiceText.setStyle("-fx-fill: -fx-text-base-color");
                Text decText = new Text();
                decText.getStyleClass().add((Object)"base");
                if (m instanceof DataItemModification) {
                    DataItem toShow;
                    mod = (DataItemModification)m;
                    if (mod.getConnectedChoice() != null) {
                        if (model.hasDecisionBeenMade(mod.getConnectedChoice())) {
                            this.updateChoice(item, mod, decText);
                        }
                        Choice choice = item.getChoice(mod.getConnectedChoice());
                        button = new Button(decText.getText().length() == 0 ? "?" : "!");
                        button.setOnAction(ev -> {
                            ((DataItemDetailsPane)this.getSkinnable()).getDecisionHandler().accept(((DataItemDetailsPane)this.getSkinnable()).getSelectedItem(), choice);
                            RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "Decision dialog closed------------------updating choice");
                            this.updateChoice(item, mod, decText);
                        });
                        button.setUserData((Object)choice);
                    } else if (mod.getResolvedKey() != null && mod.getResolvedKey() instanceof DataItem && (toShow = (DataItem)mod.getResolvedKey()) != null) {
                        tooltip = new Tooltip(toShow.getDescription());
                        tooltip.setWrapText(true);
                        tooltip.setMaxWidth(300.0);
                    }
                } else if (m instanceof ModificationChoice) {
                    mod = (ModificationChoice)m;
                    button = new Button(decText.getText().length() == 0 ? "?" : "!");
                    button.setOnAction(arg_0 -> this.lambda$getContentStats$8((ModificationChoice)mod, item, decText, arg_0));
                    button.setUserData((Object)mod);
                }
                TextFlow label = new TextFlow(new Node[]{choiceText, decText});
                if (button == null) {
                    contentStats.getChildren().add((Object)label);
                    continue;
                }
                HBox box = new HBox(5.0, new Node[]{button, label});
                box.setAlignment(Pos.CENTER_LEFT);
                contentStats.getChildren().add((Object)box);
            }
        }
        return contentStats;
    }

    private void updateChoice(ComplexDataItem item, DataItemModification mod, Text decText) {
        RuleSpecificCharacterObject model = ((DataItemDetailsPane)this.getSkinnable()).getModel();
        ComplexDataItemValue<ComplexDataItem> complex = ((DataItemDetailsPane)this.getSkinnable()).getShowChoicesWithValue();
    }

    private void updateChoice(ComplexDataItem item, ModificationChoice mod, Text decText) {
        RuleSpecificCharacterObject model = ((DataItemDetailsPane)this.getSkinnable()).getModel();
        Decision dec = model.getDecision(mod.getUUID());
        if (dec == null) {
            decText.setText("");
        } else {
            List modList = GenericRPGTools.decisionToModifications((ModificationChoice)mod, (Decision)dec);
            List modListS = modList.stream().map(mb -> ((DataItemDetailsPane)this.getSkinnable()).getModificationConverter().apply((Modification)mb)).collect(Collectors.toList());
            decText.setText(" (" + String.join((CharSequence)", ", modListS) + ")");
        }
    }

    private /* synthetic */ void lambda$getContentStats$8(ModificationChoice mod, ComplexDataItem item, Text decText, ActionEvent ev) {
        if (((DataItemDetailsPane)this.getSkinnable()).getModDecisionHandler() == null) {
            RPGFrameworkJavaFX.logger.log(System.Logger.Level.ERROR, "Missing modDecisionHandler for " + this.getSkinnable());
        } else {
            ((DataItemDetailsPane)this.getSkinnable()).getModDecisionHandler().accept(((DataItemDetailsPane)this.getSkinnable()).getSelectedItem(), mod);
            RPGFrameworkJavaFX.logger.log(System.Logger.Level.WARNING, "Decision dialog closed------------------");
            this.updateChoice(item, mod, decText);
        }
    }
}

