/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.wizard;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.chargen.CharacterController;
import de.rpgframework.genericrpg.chargen.Rule;
import de.rpgframework.genericrpg.chargen.RuleValue;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class RuleChoiceBox
extends VBox {
    private static final PropertyResourceBundle RES = (PropertyResourceBundle)ResourceBundle.getBundle(RPGFrameworkJFXConstants.class.getName());
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private List<Rule.EffectOn> allowedCategories;
    private Label heading;
    private GridPane grid;

    public RuleChoiceBox(Rule.EffectOn ... allowed) {
        this.allowedCategories = List.of(allowed);
        this.heading = new Label(ResourceI18N.get((ResourceBundle)RES, (String)"label.ruledetails"));
        this.heading.setStyle("-fx-underline: true");
        this.heading.getStyleClass().add((Object)"subtitle");
        this.grid = new GridPane();
        this.grid.setVgap(5.0);
        ScrollPane scroll = new ScrollPane((Node)this.grid);
        scroll.setMaxHeight(Double.MAX_VALUE);
        scroll.setFitToWidth(true);
        this.getChildren().addAll((Object[])new Node[]{this.heading, scroll});
        VBox.setVgrow((Node)scroll, (Priority)Priority.ALWAYS);
    }

    public void setData(CharacterController<?, ?> ctrl) {
        logger.log(System.Logger.Level.WARNING, "RuleController of " + ctrl.getClass() + " is " + ctrl.getRuleController());
        List values = ctrl.getRuleController().getValues();
        values = values.stream().filter(r -> this.allowedCategories.contains(r.getRule().getAffected())).sorted(new Comparator<RuleValue>(){

            @Override
            public int compare(RuleValue o1, RuleValue o2) {
                int cmp = Integer.compare(o1.getRule().getAffected().ordinal(), o2.getRule().getAffected().ordinal());
                return cmp;
            }
        }).collect(Collectors.toList());
        this.grid.getChildren().clear();
        Rule.EffectOn lastCategory = null;
        int i = -1;
        block5: for (RuleValue rVal : values) {
            logger.log(System.Logger.Level.DEBUG, "  rule {0}", rVal);
            ++i;
            if (rVal.getRule().getAffected() != lastCategory) {
                Label heading = new Label(rVal.getRule().getAffected().getName());
                heading.getStyleClass().add((Object)"base");
                GridPane.setMargin((Node)heading, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
                this.grid.add((Node)heading, 0, i, 2, 1);
                ++i;
                lastCategory = rVal.getRule().getAffected();
            }
            Rule rule = rVal.getRule();
            Label lbName = new Label(rule.getName(Locale.getDefault()));
            lbName.setWrapText(true);
            this.grid.add((Node)lbName, 0, i);
            if (!rVal.isEditable()) {
                Label lbLock = new Label("\ud83d\udd12");
                lbLock.setStyle("-fx-min-width: 1em");
                this.grid.add((Node)lbLock, 1, i);
            }
            switch (rule.getType()) {
                case BOOLEAN: {
                    CheckBox check = new CheckBox();
                    check.setDisable(!rVal.isEditable());
                    check.setSelected(((Boolean)rVal.getValue()).booleanValue());
                    this.grid.add((Node)check, 2, i);
                    check.selectedProperty().addListener((ov, o, n) -> {
                        logger.log(System.Logger.Level.INFO, "Rule " + rVal + " changed to " + n);
                        ctrl.getRuleController().set(rule, String.valueOf(n));
                        ctrl.runProcessors();
                    });
                    continue block5;
                }
                case INTEGER: 
                case FLOAT: {
                    TextField intField = new TextField(String.valueOf(rVal.getValue()));
                    intField.setUserData((Object)rule);
                    intField.setPrefColumnCount(4);
                    intField.setStyle("-fx-min-width: 3.5em; -fx-max-width: 6em");
                    intField.setEditable(rVal.isEditable());
                    this.grid.add((Node)intField, 2, i);
                    intField.textProperty().addListener((ov, o, n) -> {
                        logger.log(System.Logger.Level.INFO, "Rule " + rVal + " changed to " + n);
                        ctrl.getRuleController().set(rule, String.valueOf(n));
                        ctrl.runProcessors();
                    });
                    continue block5;
                }
                case ENUM: {
                    ChoiceBox enumField = new ChoiceBox();
                    for (Enum tmp : (Enum[])rule.getEnumClassToUse().getEnumConstants()) {
                        enumField.getItems().add((Object)tmp);
                    }
                    enumField.setValue((Object)rule.getDefaultAsEnumValue());
                    enumField.setConverter((StringConverter)new StringConverter<Object>(){

                        public String toString(Object val) {
                            try {
                                Method method = val.getClass().getMethod("getName", Locale.class);
                                return (String)method.invoke(val, Locale.getDefault());
                            }
                            catch (NoSuchMethodException e) {
                                return String.valueOf(val);
                            }
                            catch (Exception e) {
                                return "?Error?";
                            }
                        }

                        public Object fromString(String string) {
                            return null;
                        }
                    });
                    enumField.setUserData((Object)rule);
                    enumField.setStyle("-fx-min-width: 8em");
                    enumField.setDisable(!rVal.isEditable());
                    this.grid.add((Node)enumField, 2, i);
                    enumField.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
                        logger.log(System.Logger.Level.INFO, "Rule " + rVal + " changed to " + n);
                        ctrl.getRuleController().set(rule, String.valueOf(n));
                        ctrl.runProcessors();
                    });
                    continue block5;
                }
            }
            logger.log(System.Logger.Level.ERROR, "No support for type " + rule.getType());
            System.err.println("RuleChoiceBox: No support for rule type " + rule.getType());
        }
    }
}

