package de.rpgframework.jfx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.rpgframework.jfx.skin.FuturisticBorderElementSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

/**
 * 
 */
public class FuturisticBorderElement extends Control {
	
	private final static int DEFAULT_DECO_WIDTH = -10;
	
	@FXML private DoubleProperty borderWidth;
	@FXML private DoubleProperty borderWidthTop;
	@FXML private DoubleProperty borderWidthBottom;
	@FXML private DoubleProperty borderWidthLeft;
	@FXML private DoubleProperty borderWidthRight;
	@FXML private BooleanProperty innerBorder;
	@FXML private ObjectProperty<Paint> borderColor; 
    @FXML private ObjectProperty<Node> content = new SimpleObjectProperty<>(); 

	//-------------------------------------------------------------------
	public FuturisticBorderElement() {
	}

	//-------------------------------------------------------------------
	public FuturisticBorderElement(Node content) {
		this.content.set(content);
	}

	//-------------------------------------------------------------------
	public FuturisticBorderElement(Node content, int width) {
		this.content.set(content);
		setBorderWidthBottom(width);
		setBorderWidthTop(width);
		setBorderWidthLeft(width);
		setBorderWidthRight(width);
	}

	//-------------------------------------------------------------------
	public FuturisticBorderElement(Node content, int decoTop, int decoLeft, int decoBottom, int decoRight) {
		this.content.set(content);
		setBorderWidthBottom(decoBottom);
		setBorderWidthTop(decoTop);
		setBorderWidthLeft(decoLeft);
		setBorderWidthRight(decoRight);
	}

	//-------------------------------------------------------------------
	/**
	 * @see javafx.scene.control.Control#createDefaultSkin()
	 */
	@Override
	public Skin<?> createDefaultSkin() {
		return new FuturisticBorderElementSkin(this);
	}

    
	//-------------------------------------------------------------------
    public final void setContent(Node value) { contentProperty().set(value); }
    public final Node getContent() { return content.get(); }
    public final ObjectProperty<Node> contentProperty() { return content; }
    
	//-------------------------------------------------------------------
    public final void setBorderColor(Paint value) { borderColorProperty().set(value); }
    public final Paint getBorderColor() { return borderColor == null ? Color.BLACK : borderColor.get(); }
    public final ObjectProperty<Paint> borderColorProperty() {
        if (borderColor == null) {
        	borderColor = new StyleableObjectProperty<Paint>(Color.BLACK) {
                @Override
                public CssMetaData<FuturisticBorderElement,Paint> getCssMetaData() { return StyleableProperties.BORDER_COLOR; }
                @Override
                public Object getBean() { return FuturisticBorderElement.this; }
                @Override
                public String getName() { return "borderColor"; }
            };
        }
        return borderColor;
    }

    
	//-------------------------------------------------------------------
    public final void setBorderWidth(int value) { borderWidthProperty().set(value); }
    public final double getBorderWidth() { return borderWidth == null ? DEFAULT_DECO_WIDTH: borderWidth.get(); }
    public final DoubleProperty borderWidthProperty() {
        if (borderWidth == null) {
        	borderWidth = new StyleableDoubleProperty(1.0) {
                @Override
                public CssMetaData<FuturisticBorderElement,Number> getCssMetaData() { return StyleableProperties.BORDER_WIDTH; }
                @Override
                public Object getBean() { return FuturisticBorderElement.this; }
                @Override
                public String getName() { return "borderWidth"; }
            };
        }
        return borderWidth;
    }

    
	//-------------------------------------------------------------------
    public final void setBorderWidthTop(int value) { borderWidthTopProperty().set(value); }
    public final double getBorderWidthTop() { return borderWidthTop == null ? DEFAULT_DECO_WIDTH: borderWidthTop.get(); }
    public final DoubleProperty borderWidthTopProperty() {
        if (borderWidthTop == null) {
        	borderWidthTop = new StyleableDoubleProperty(0.0) {
                @Override
                public CssMetaData<FuturisticBorderElement,Number> getCssMetaData() { return StyleableProperties.BORDER_WIDTH_TOP; }
                @Override
                public Object getBean() { return FuturisticBorderElement.this; }
                @Override
                public String getName() { return "borderWidthTop"; }
            };
        }
        return borderWidthTop;
    }

    
	//-------------------------------------------------------------------
    public final void setBorderWidthBottom(int value) { borderWidthBottomProperty().set(value); }
    public final double getBorderWidthBottom() { return borderWidthBottom == null ? DEFAULT_DECO_WIDTH: borderWidthBottom.get(); }
    public final DoubleProperty borderWidthBottomProperty() {
        if (borderWidthBottom == null) {
        	borderWidthBottom = new StyleableDoubleProperty(0.0) {
                @Override public CssMetaData<FuturisticBorderElement,Number> getCssMetaData() { return StyleableProperties.BORDER_WIDTH_BOTTOM; }
                @Override public Object getBean() { return FuturisticBorderElement.this; }
                @Override public String getName() { return "borderWidthBottom"; }
            };
        }
        return borderWidthBottom;
    }

    
	//-------------------------------------------------------------------
    public final void setBorderWidthLeft(int value) { borderWidthLeftProperty().set(value); }
    public final double getBorderWidthLeft() { return borderWidthLeft == null ? DEFAULT_DECO_WIDTH: borderWidthLeft.get(); }
    public final DoubleProperty borderWidthLeftProperty() {
        if (borderWidthLeft == null) {
        	borderWidthLeft = new StyleableDoubleProperty(0.0) {
                @Override public CssMetaData<FuturisticBorderElement,Number> getCssMetaData() { return StyleableProperties.BORDER_WIDTH_LEFT; }
                @Override public Object getBean() { return FuturisticBorderElement.this; }
                @Override public String getName() { return "borderWidthLeft"; }
            };
        }
        return borderWidthLeft;
    }

    
	//-------------------------------------------------------------------
    public final void setBorderWidthRight(int value) { borderWidthRightProperty().set(value); }
    public final double getBorderWidthRight() { return borderWidthRight == null ? DEFAULT_DECO_WIDTH: borderWidthRight.get(); }
    public final DoubleProperty borderWidthRightProperty() {
        if (borderWidthRight == null) {
        	borderWidthRight = new StyleableDoubleProperty(0.0) {
                @Override public CssMetaData<FuturisticBorderElement,Number> getCssMetaData() { return StyleableProperties.BORDER_WIDTH_RIGHT; }
                @Override public Object getBean() { return FuturisticBorderElement.this; }
                @Override public String getName() { return "borderWidthRight"; }
            };
        }
        return borderWidthRight;
    }

    
	//-------------------------------------------------------------------
    public final void setInnerBorder(boolean value) { innerBorderProperty().set(value); }
    public final boolean isInnerBorder() { return innerBorder == null ? false: innerBorder.get(); }
    public final BooleanProperty innerBorderProperty() {
        if (innerBorder == null) {
        	innerBorder = new StyleableBooleanProperty(false) {
                @Override public CssMetaData<FuturisticBorderElement,Boolean> getCssMetaData() { return StyleableProperties.BORDER_INNER; }
                @Override public Object getBean() { return FuturisticBorderElement.this; }
                @Override public String getName() { return "borderInner"; }
            };
        }
        return innerBorder;
    }

    private static class StyleableProperties {

        private static final CssMetaData<FuturisticBorderElement,Paint> BORDER_COLOR =
                new CssMetaData<FuturisticBorderElement,Paint>("-fx-border-color",
                PaintConverter.getInstance(), Color.BLACK) {

            @Override
            public boolean isSettable(FuturisticBorderElement n) {
                return n.borderColor == null || !n.borderColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(FuturisticBorderElement n) {
                return (StyleableProperty<Paint>)(WritableValue<Paint>)n.borderColorProperty();
            }
        };

        private static final CssMetaData<FuturisticBorderElement,Number> BORDER_WIDTH=
            new CssMetaData<FuturisticBorderElement,Number>("-fx-border-width", SizeConverter.getInstance(), 0) {
        		@Override
        		public boolean isSettable(FuturisticBorderElement n) { return n.borderWidth == null || !n.borderWidth.isBound(); }        		
        		@Override
        		public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
        			return (StyleableProperty<Number>)(WritableValue<Number>)n.borderWidthProperty();
        		}
        };

        private static final CssMetaData<FuturisticBorderElement,Number> BORDER_WIDTH_TOP =
            new CssMetaData<FuturisticBorderElement,Number>("-fx-border-width-top", SizeConverter.getInstance(), 0) {
        		@Override
        		public boolean isSettable(FuturisticBorderElement n) { return n.borderWidthTop == null || !n.borderWidthTop.isBound(); }        		
        		@Override
        		public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
        			return (StyleableProperty<Number>)(WritableValue<Number>)n.borderWidthTopProperty();
        		}
        };

        private static final CssMetaData<FuturisticBorderElement,Number> BORDER_WIDTH_BOTTOM =
            new CssMetaData<FuturisticBorderElement,Number>("-fx-border-width-bottom", SizeConverter.getInstance(), 0) {
        		@Override
        		public boolean isSettable(FuturisticBorderElement n) { return n.borderWidthBottom == null || !n.borderWidthBottom.isBound(); }        		
        		@Override
        		public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
        			return (StyleableProperty<Number>)(WritableValue<Number>)n.borderWidthBottomProperty();
        		}
        };

        private static final CssMetaData<FuturisticBorderElement,Number> BORDER_WIDTH_LEFT =
            new CssMetaData<FuturisticBorderElement,Number>("-fx-border-width-left", SizeConverter.getInstance(), 0) {
        		@Override
        		public boolean isSettable(FuturisticBorderElement n) { return n.borderWidthLeft== null || !n.borderWidthLeft.isBound(); }        		
        		@Override
        		public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
        			return (StyleableProperty<Number>)(WritableValue<Number>)n.borderWidthLeftProperty();
        		}
        };

        private static final CssMetaData<FuturisticBorderElement,Number> BORDER_WIDTH_RIGHT =
            new CssMetaData<FuturisticBorderElement,Number>("-fx-border-width-right", SizeConverter.getInstance(), 0) {
        		@Override
        		public boolean isSettable(FuturisticBorderElement n) { return n.borderWidthRight== null || !n.borderWidthRight.isBound(); }        		
        		@Override
        		public StyleableProperty<Number> getStyleableProperty(FuturisticBorderElement n) {
        			return (StyleableProperty<Number>)(WritableValue<Number>)n.borderWidthRightProperty();
        		}
        };

        private static final CssMetaData<FuturisticBorderElement,Boolean> BORDER_INNER =
            new CssMetaData<FuturisticBorderElement,Boolean>("-fx-border-inner", BooleanConverter.getInstance(), Boolean.FALSE) {
        		@Override
        		public boolean isSettable(FuturisticBorderElement n) { return n.innerBorder== null || !n.innerBorder.isBound(); }        		
        		@Override
        		public StyleableProperty<Boolean> getStyleableProperty(FuturisticBorderElement n) {
        			return (StyleableProperty<Boolean>)(WritableValue<Boolean>)n.innerBorderProperty();
        		}
        };

        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        static {
            final List<CssMetaData<? extends Styleable, ?>> styleables =
                new ArrayList<CssMetaData<? extends Styleable, ?>>(Control.getClassCssMetaData());
            Collections.addAll(styleables,
                BORDER_COLOR,
                BORDER_WIDTH,
                BORDER_WIDTH_TOP,
                BORDER_WIDTH_BOTTOM,
                BORDER_WIDTH_LEFT,
                BORDER_WIDTH_RIGHT,
                BORDER_INNER
            );
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }


    /**
     * @return The CssMetaData associated with this class, which may include the
     * CssMetaData of its superclasses.
     * @since JavaFX 8.0
     */
    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

}
