package de.rpgframework.jfx.skin;

import de.rpgframework.jfx.FuturisticBorderElement;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;

/**
 * 
 */
public class FuturisticBorderElementSkin extends SkinBase<FuturisticBorderElement> {
	
	private final static int SIZE = 100;
	
	private BorderPane grid;
	private Border border;
	private VBox center;

	//-------------------------------------------------------------------
	/**
	 * @param control
	 */
	public FuturisticBorderElementSkin(FuturisticBorderElement control) {
		super(control);
		initComponents();
		initInteractivity();
		getChildren().add(grid);
		redraw();
	}

	//-------------------------------------------------------------------
	private void initComponents() {
		border = Border.stroke(getSkinnable().getBorderColor());
		center = new VBox();
		grid = new BorderPane();
		grid.setCenter(center);
		grid.setMinSize(FuturisticBorderElementSkin.SIZE, FuturisticBorderElementSkin.SIZE);
		getSkinnable().setMinSize(FuturisticBorderElementSkin.SIZE, FuturisticBorderElementSkin.SIZE);
	}

	//-------------------------------------------------------------------
	private void initInteractivity() {
		FuturisticBorderElement skinnable = getSkinnable();
		grid.centerProperty().addListener( (ov,o,n) -> {
			if (n instanceof Region)
				((Region)n).setBorder(border);
		});
		
		skinnable.borderWidthProperty().addListener( (ov,o,n) -> redraw());
		skinnable.borderWidthLeftProperty().addListener( (ov,o,n) -> redraw());
		skinnable.borderWidthRightProperty().addListener( (ov,o,n) -> redraw());
		skinnable.borderWidthTopProperty().addListener( (ov,o,n) -> redraw());
		skinnable.borderWidthBottomProperty().addListener( (ov,o,n) -> redraw());
	}

	//-------------------------------------------------------------------
	private void redraw() {
		if (getSkinnable().getContent()==null)
			center.getChildren().clear();
		else
			center.getChildren().setAll(getSkinnable().getContent());
		// Negative: Links/Unten 
		// Positiv: Rechts/Oben
		
		boolean isInner = getSkinnable().isInnerBorder();
		if (isInner) {
			getSkinnable().setBorder(border);
			grid.setBorder(null);
			center.setBorder(null);			
			drawInnerBorder();
		} else {
			getSkinnable().setBorder(null);
			grid.setBorder(null);
			center.setBorder(border);
			drawOuterBorder();
		}
	}
	
	//-------------------------------------------------------------------
	private void drawOuterBorder() {
		// Left
		double width = Math.abs( getSkinnable().getBorderWidthLeft() );
		if (width!=0) {
			Polygon poly = new Polygon(0,width, width,0, width,SIZE, 0,SIZE-width, 0,width);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setLeft(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthLeft()<0)?Pos.BOTTOM_LEFT:Pos.TOP_LEFT);
		}
		
		// Right
		width = Math.abs( getSkinnable().getBorderWidthRight() );
		if (width!=0) {
			Polygon poly = new Polygon(0,0, width,width, width,SIZE-width, 0,SIZE, 0,0);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setRight(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthRight()<0)?Pos.TOP_RIGHT:Pos.BOTTOM_RIGHT);
		} else
			grid.setRight(null);
		
		// Top
		width = Math.abs( getSkinnable().getBorderWidthTop() );
		if (width!=0) {
			Polygon poly = new Polygon(0,width, width,0, SIZE-width,0, SIZE,width, 0,width);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setTop(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthTop()<0)?Pos.BOTTOM_LEFT:Pos.BOTTOM_RIGHT);
			BorderPane.setMargin(poly, new Insets(0, getSkinnable().getBorderWidthRight(), 0, getSkinnable().getBorderWidthLeft()));
		}
		
		// Bottom
		width = Math.abs( getSkinnable().getBorderWidthBottom() );
		if (width!=0) {
			Polygon poly = new Polygon(0,0, SIZE,0, SIZE-width,width, width,width, 0,0);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setBottom(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthBottom()<0)?Pos.TOP_RIGHT:Pos.TOP_LEFT);
			BorderPane.setMargin(poly, new Insets(0, getSkinnable().getBorderWidthRight(), 0, getSkinnable().getBorderWidthLeft()));
		}
	}
	
	
	//-------------------------------------------------------------------
	private void drawInnerBorder() {
		// Left
		double width = Math.abs( getSkinnable().getBorderWidthLeft() );
		if (width!=0) {
			Polygon poly = new Polygon(0,0, width,width, width,SIZE-width, 0,SIZE, 0,0);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setLeft(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthLeft()<0)?Pos.BOTTOM_LEFT:Pos.TOP_LEFT);
		}
		
		// Right
		width = Math.abs( getSkinnable().getBorderWidthRight() );
		if (width!=0) {
			Polygon poly = new Polygon(0,width, width,0, width,SIZE, 0,SIZE-width, 0,width);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setRight(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthLeft()<0)?Pos.TOP_RIGHT:Pos.BOTTOM_RIGHT);
		}
		
		// Top
		width = Math.abs( getSkinnable().getBorderWidthTop() );
		if (width!=0) {
			Polygon poly = new Polygon(0,0, SIZE,0, SIZE-width,width, width,width, 0,0);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setTop(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthLeft()<0)?Pos.BOTTOM_LEFT:Pos.BOTTOM_RIGHT);
		}
		
		// Bottom
		width = Math.abs( getSkinnable().getBorderWidthTop() );
		if (width!=0) {
			Polygon poly = new Polygon(0,width, width,0, SIZE-width,0, SIZE,width, 0,width);
			poly.setFill(getSkinnable().getBorderColor());
			grid.setBottom(poly);
			BorderPane.setAlignment(poly, (getSkinnable().getBorderWidthLeft()<0)?Pos.TOP_RIGHT:Pos.TOP_LEFT);
		}
	}

}
