/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.genericrpg.data.ASkillValue;
import de.rpgframework.genericrpg.data.AttributeValue;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.jfx.NumericalValueField;
import javafx.collections.MapChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.prelle.javafx.SymbolIcon;

public class NumericalValueFieldSkin<T, V extends NumericalValue<T>>
extends SkinBase<NumericalValueField<T, V>> {
    private static final System.Logger logger = System.getLogger("prelle.jfx");
    private HBox layout;
    private Button dec;
    private Button inc;
    private Label lbValue;
    private int minWidthEm;
    private Integer overrideValue;

    public NumericalValueFieldSkin(NumericalValueField<T, V> parent) {
        super(parent);
        ((NumericalValueField)this.getSkinnable()).getProperties().addListener((MapChangeListener)new MapChangeListener<Object, Object>(){

            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                logger.log(System.Logger.Level.WARNING, "onChanged {0}", change);
                if (String.valueOf(change.getKey()).equals("refreshKey")) {
                    NumericalValueFieldSkin.this.refresh();
                    ((NumericalValueField)NumericalValueFieldSkin.this.getSkinnable()).getProperties().put((Object)"refreshKey", (Object)Boolean.FALSE);
                }
            }
        });
        this.initComponents();
        this.initLayout();
        this.initStyle();
        this.initInteractivity();
        this.dec.setDisable(true);
        this.inc.setDisable(true);
        this.refresh();
    }

    private void initComponents() {
        this.dec = new Button(null, (Node)new SymbolIcon("remove"));
        this.inc = new Button(null, (Node)new SymbolIcon("add"));
        this.lbValue = new Label();
    }

    private void initLayout() {
        this.layout = new HBox();
        this.layout.getChildren().clear();
        this.layout.setAlignment(Pos.CENTER);
        this.layout.getChildren().addAll((Object[])new Node[]{this.dec, this.lbValue, this.inc});
        HBox.setHgrow((Node)this.lbValue, (Priority)Priority.SOMETIMES);
        HBox.setMargin((Node)this.lbValue, (Insets)new Insets(1.0, 2.0, 1.0, 2.0));
        HBox.setMargin((Node)this.dec, (Insets)new Insets(2.0, 3.0, 0.0, 4.0));
        HBox.setMargin((Node)this.inc, (Insets)new Insets(2.0, 4.0, 0.0, 3.0));
        this.getChildren().add((Object)this.layout);
    }

    private void initStyle() {
        this.inc.getStyleClass().add((Object)"mini-button");
        this.dec.getStyleClass().add((Object)"mini-button");
        this.lbValue.setStyle("-fx-alignment:center");
    }

    private void initInteractivity() {
        this.dec.setOnAction(ev -> {
            NumericalValue value = ((NumericalValueField)this.getSkinnable()).getValueFactory() != null ? (NumericalValue)((NumericalValueField)this.getSkinnable()).getValueFactory().get() : null;
            ((NumericalValueField)this.getSkinnable()).getController().decrease(value);
            this.refresh();
            if (((NumericalValueField)this.getSkinnable()).getOnAction() != null) {
                ((NumericalValueField)this.getSkinnable()).getOnAction().handle(ev);
            }
        });
        this.inc.setOnAction(ev -> {
            NumericalValue value = ((NumericalValueField)this.getSkinnable()).getValueFactory() != null ? (NumericalValue)((NumericalValueField)this.getSkinnable()).getValueFactory().get() : null;
            ((NumericalValueField)this.getSkinnable()).getController().increase(value);
            this.refresh();
            if (((NumericalValueField)this.getSkinnable()).getOnAction() != null) {
                ((NumericalValueField)this.getSkinnable()).getOnAction().handle(ev);
            }
        });
        ((NumericalValueField)this.getSkinnable()).controllerProperty().addListener((ov, o, n) -> this.refresh());
        ((NumericalValueField)this.getSkinnable()).valueFactoryProperty().addListener((ov, o, n) -> this.refresh());
    }

    public void refresh() {
        NumericalValue value;
        String content = "-";
        NumericalValue numericalValue = value = ((NumericalValueField)this.getSkinnable()).getValueFactory() != null ? (NumericalValue)((NumericalValueField)this.getSkinnable()).getValueFactory().get() : null;
        if (value != null) {
            content = ((NumericalValueField)this.getSkinnable()).getConverter() != null ? (String)((NumericalValueField)this.getSkinnable()).getConverter().call((Object)value) : (value instanceof AttributeValue ? ((AttributeValue)value).getDisplayString() : (value instanceof ItemAttributeNumericalValue ? String.valueOf(((ItemAttributeNumericalValue)value).getModifiedValue()) : (value instanceof ASkillValue ? String.valueOf(((ASkillValue)value).getModifiedValue()) : String.valueOf(value.getDistributed()))));
        }
        this.lbValue.setText(content);
        NumericalValueController control = ((NumericalValueField)this.getSkinnable()).getController();
        if (control != null) {
            this.dec.setManaged(true);
            this.inc.setManaged(true);
            this.dec.setVisible(true);
            this.inc.setVisible(true);
            this.dec.setDisable(!control.canBeDecreased(value).get());
            this.inc.setDisable(!control.canBeIncreased(value).get());
        } else {
            this.dec.setManaged(false);
            this.inc.setManaged(false);
            this.dec.setVisible(false);
            this.inc.setVisible(false);
        }
    }
}

