/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.jfx.NumericalValueField;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

public class NumericalValueTableCell<T, R extends NumericalValue<T>>
extends TableCell<R, Number> {
    private ObjectProperty<NumericalValueController<T, R>> ctrl;
    private boolean useItem;
    private Function<R, Boolean> visibilityCallback;

    public NumericalValueTableCell(ObjectProperty<NumericalValueController<T, R>> ctrl, Function<R, Boolean> visibilityCallback) {
        this.ctrl = ctrl;
        this.visibilityCallback = visibilityCallback;
    }

    public NumericalValueTableCell(ObjectProperty<NumericalValueController<T, R>> ctrl) {
        this.ctrl = ctrl;
    }

    public NumericalValueTableCell(NumericalValueController<T, R> data) {
        this.ctrl = new SimpleObjectProperty(data);
    }

    public NumericalValueTableCell(NumericalValueController<T, R> data, boolean useItem) {
        this.ctrl = new SimpleObjectProperty(data);
        this.useItem = useItem;
    }

    public NumericalValueTableCell(NumericalValueController<T, R> data, Function<R, Boolean> visibilityCallback) {
        this.ctrl = new SimpleObjectProperty(data);
        this.visibilityCallback = visibilityCallback;
    }

    public void updateItem(Number item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
        } else if (this.getTableRow() != null && this.getTableRow().getItem() != null) {
            NumericalValueField val = new NumericalValueField(() -> (NumericalValue)this.getTableRow().getItem(), (NumericalValueController)this.ctrl.get());
            val.setController((NumericalValueController)this.ctrl.get());
            if (this.useItem) {
                val.refresh();
            }
            this.setGraphic((Node)val);
            if (this.visibilityCallback == null) {
                this.setVisible(true);
            } else {
                this.setVisible(this.visibilityCallback.apply((NumericalValue)this.getTableRow().getItem()));
            }
        }
    }
}

