/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.chargen.PartialController;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ChoiceOrigin;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.DecisionContainer;
import de.rpgframework.genericrpg.data.GenericRPGTools;
import de.rpgframework.genericrpg.data.PageReference;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationChoice;
import de.rpgframework.genericrpg.modification.ValueModification;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.ChoiceFewDialog;
import de.rpgframework.jfx.ChoiceManyDialog;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.UserDistributeDialog;
import java.io.ByteArrayInputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;

public class RPGFrameworkJavaFX {
    public static final System.Logger logger = System.getLogger("rpgframework.jfx");
    private static final URL STYLE_URL = RPGFrameworkJavaFX.class.getResource("css/rpgframework.css");
    private static final String STYLE = STYLE_URL.toString();

    public static void assignStylesheet(Scene scene) {
        if (!scene.getStylesheets().contains((Object)STYLE)) {
            scene.getStylesheets().add((Object)STYLE);
        }
    }

    public static void parseMarkupAndFillTextFlow(TextFlow flow, String text) {
        flow.getChildren().clear();
        if (text.length() > 1200) {
            text = text.substring(0, 1200);
        }
        String toParse = "<text>" + text + "</text>";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(toParse.getBytes("UTF-8"));
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(in);
            StringBuffer buf = new StringBuffer();
            boolean em = false;
            boolean i = false;
            boolean b = false;
            while (parser.hasNext()) {
                block1 : switch (parser.getEventType()) {
                    case 7: {
                        break;
                    }
                    case 8: {
                        parser.close();
                        break;
                    }
                    case 13: {
                        System.out.println("NAMESPACE: " + parser.getNamespaceURI());
                        break;
                    }
                    case 1: {
                        Object textblk;
                        if (buf.length() > 0) {
                            textblk = new Text(buf.toString());
                            if (!buf.toString().endsWith("\n")) {
                                textblk.setText(buf.toString() + " ");
                            }
                            flow.getChildren().add(textblk);
                            StringBuffer style = new StringBuffer("-fx-fill: -fx-text-background-color; -fx-text-alignment: justify;");
                            if (b && !em) {
                                textblk.setFont(Font.font((String)"Segoe UI Bold", (FontWeight)FontWeight.NORMAL, (double)-1.0));
                                textblk.getStyleClass().add((Object)"base");
                            } else if (em && !b) {
                                textblk.setFont(Font.font((String)"Segoe UI Italic", (FontWeight)FontWeight.NORMAL, (double)-1.0));
                                textblk.getStyleClass().add((Object)"emphasize");
                            } else if (em && b) {
                                textblk.getStyleClass().addAll((Object[])new String[]{"emphasize", "base"});
                                textblk.setFont(Font.font((String)"Segoe UI Bold Italic", (FontWeight)FontWeight.NORMAL, (double)-1.0));
                            }
                            textblk.setStyle(style.toString());
                        }
                        buf = new StringBuffer();
                        switch (parser.getLocalName()) {
                            case "text": {
                                break block1;
                            }
                            case "br": {
                                buf.append("\n");
                                break block1;
                            }
                            case "em": {
                                em = true;
                                break block1;
                            }
                            case "i": {
                                i = true;
                                break block1;
                            }
                            case "b": {
                                b = true;
                                break block1;
                            }
                        }
                        logger.log(System.Logger.Level.WARNING, "Unsupported START markup: " + parser.getLocalName());
                        break;
                    }
                    case 4: {
                        if (parser.isWhiteSpace()) break;
                        buf.append(parser.getText().trim());
                        break;
                    }
                    case 2: {
                        Object textblk;
                        if (buf.length() > 0) {
                            textblk = new Text(buf.toString());
                            if (!buf.toString().endsWith("\n")) {
                                textblk.setText(buf.toString() + " ");
                            }
                            flow.getChildren().add(textblk);
                            StringBuffer style = new StringBuffer("-fx-fill: -fx-text-background-color; -fx-text-alignment: justify;");
                            if (b && !em && !i) {
                                textblk.setFont(Font.font((String)"Segoe UI Bold", (FontWeight)FontWeight.NORMAL, (double)-1.0));
                                textblk.getStyleClass().add((Object)"base");
                            } else if ((em || i) && !b) {
                                textblk.setFont(Font.font((String)"Segoe UI Italic", (FontWeight)FontWeight.NORMAL, (double)-1.0));
                                textblk.getStyleClass().add((Object)"emphasize");
                            } else if ((em || i) && b) {
                                textblk.getStyleClass().addAll((Object[])new String[]{"emphasize", "base"});
                                textblk.setFont(Font.font((String)"Segoe UI Bold Italic", (FontWeight)FontWeight.NORMAL, (double)-1.0));
                            }
                            textblk.setStyle(style.toString());
                            buf = new StringBuffer();
                        }
                        switch (parser.getLocalName()) {
                            case "text": {
                                break block1;
                            }
                            case "br": {
                                break block1;
                            }
                            case "em": {
                                em = false;
                                break block1;
                            }
                            case "b": {
                                b = false;
                                break block1;
                            }
                            case "i": {
                                i = false;
                                break block1;
                            }
                        }
                        logger.log(System.Logger.Level.WARNING, "Unsupported END markup: " + parser.getLocalName());
                        break;
                    }
                }
                parser.next();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed parsing markup", (Throwable)e);
            logger.log(System.Logger.Level.ERROR, text);
        }
    }

    public static String createSourceText(DataItem item) {
        ArrayList<CallSite> elements = new ArrayList<CallSite>();
        boolean shorted = item.getPageReferences().size() > 2;
        String language = Locale.getDefault().getLanguage();
        for (PageReference ref : item.getPageReferences()) {
            if (!ref.getLanguage().equals(language)) continue;
            if (ref.getOverwrittenProductName() != null) {
                elements.add((CallSite)((Object)(ref.getOverwrittenProductName() + " " + ref.getPage())));
                continue;
            }
            if (shorted) {
                elements.add((CallSite)((Object)(ref.getProduct().getShortName(Locale.getDefault()) + " " + ref.getPage())));
                continue;
            }
            elements.add((CallSite)((Object)(ref.getProduct().getName(Locale.getDefault()) + " " + ref.getPage())));
        }
        return String.join((CharSequence)", ", elements);
    }

    public static <T extends DataItem> Decision requestDecision(DataItem decideFor, Choice choice, String modText, PartialController<T> control) {
        logger.log(System.Logger.Level.DEBUG, "ENTER: requestDecision from {0}", choice);
        List options = GenericRPGTools.convertChoiceToOptions((Choice)choice);
        logger.log(System.Logger.Level.WARNING, "requestDecision from {0}", options);
        if (choice.getDistribute() != null) {
            logger.log(System.Logger.Level.WARNING, "TODO: Distribute {0} on {1}", Arrays.toString((Object[])choice.getDistribute()), choice);
            UserDistributeDialog dialog = new UserDistributeDialog(decideFor, choice);
            CloseType closed = FlexibleApplication.getInstance().showAndWait((Node)dialog);
            logger.log(System.Logger.Level.INFO, "Closed with " + String.valueOf(closed));
            if (closed == CloseType.OK) {
                ArrayList<CallSite> mods = new ArrayList<CallSite>();
                for (ValueModification mod : dialog.getChoice()) {
                    if (mod == null) {
                        return null;
                    }
                    mods.add((CallSite)((Object)(mod.getKey() + ":" + mod.getValue())));
                }
                return new Decision(choice, String.join((CharSequence)",", mods));
            }
        } else {
            int count;
            int n = count = choice.getCount() > 0 ? choice.getCount() : 1;
            if (count > 1) {
                modText = count + "x " + (String)modText;
            }
            logger.log(System.Logger.Level.WARNING, "Chose " + count + "x from " + String.valueOf(options));
            if (count == 1 && options.size() <= 3) {
                ChoiceFewDialog dialog = new ChoiceFewDialog(decideFor, choice.getUUID(), (String)modText, options, control);
                CloseType closed = FlexibleApplication.getInstance().showAndWait((Node)dialog);
                logger.log(System.Logger.Level.INFO, "Closed with " + String.valueOf(closed));
            } else {
                ChoiceManyDialog dialog = new ChoiceManyDialog(decideFor, choice, (String)modText, options, control);
                CloseType closed = FlexibleApplication.getInstance().showAndWait((Node)dialog);
                logger.log(System.Logger.Level.INFO, "Closed with " + String.valueOf(closed));
            }
        }
        logger.log(System.Logger.Level.DEBUG, "LEAVE: requestDecision from {0}");
        return null;
    }

    public static <T extends DataItem> Decision requestDecision(DataItem decideFor, ModificationChoice choice, String modText, PartialController<T> control) {
        logger.log(System.Logger.Level.WARNING, "requestDecision from " + String.valueOf(choice.getUUID()) + " with ChoiceFewDialog");
        List options = GenericRPGTools.convertChoiceToOptions((ModificationChoice)choice);
        logger.log(System.Logger.Level.WARNING, "requestDecision: options = {0}", options);
        ChoiceFewDialog dialog = new ChoiceFewDialog(decideFor, choice.getUUID(), modText, options, control);
        CloseType closed = FlexibleApplication.getInstance().showAndWait((Node)dialog);
        logger.log(System.Logger.Level.INFO, "Closed with " + String.valueOf(closed));
        return dialog.getDecision();
    }

    public static <D extends ComplexDataItem, V extends ComplexDataItemValue<D>> VBox getRequirementsBox(D item, Function<Requirement, Boolean> reqMetResolver, Function<Requirement, String> reqNameResolver) {
        VBox ret = new VBox(5.0);
        if (item.getRequirements().isEmpty()) {
            return ret;
        }
        Label heading = new Label(ResourceI18N.get((ResourceBundle)RPGFrameworkJFXConstants.UI, (String)"label.requires"));
        heading.getStyleClass().add((Object)"base");
        heading.setStyle("    -fx-border-width: 0 0 1 0;\r\n    -fx-underline: true;");
        ret.getChildren().add((Object)heading);
        for (Requirement req : item.getRequirements()) {
            String name = reqNameResolver.apply(req);
            Label reqLabel = new Label(name);
            ret.getChildren().add((Object)reqLabel);
            if (reqMetResolver == null) continue;
            boolean met = reqMetResolver.apply(req);
            reqLabel.setStyle(met ? "" : "-fx-text-fill: highlight");
        }
        return ret;
    }

    public static <D extends ComplexDataItem, V extends ComplexDataItemValue<D>> VBox getModificationsBox(D item, Function<Modification, String> modNameResolver) {
        VBox ret = new VBox(5.0);
        if (item.getOutgoingModifications().isEmpty()) {
            return ret;
        }
        Label heading = new Label(ResourceI18N.get((ResourceBundle)RPGFrameworkJFXConstants.UI, (String)"label.grants"));
        heading.getStyleClass().add((Object)"base");
        heading.setStyle("    -fx-border-width: 0 0 1 0;\r\n    -fx-underline: true;");
        ret.getChildren().add((Object)heading);
        for (Modification mod : item.getOutgoingModifications()) {
            String name = modNameResolver.apply(mod);
            Label reqLabel = new Label(name);
            ret.getChildren().add((Object)reqLabel);
        }
        return ret;
    }

    public static void updateChoice(DecisionContainer container, ChoiceOrigin origin, Function<Modification, String> modConv, DataItemModification mod, Text decText) {
        Decision dec = container.getDecision(mod.getConnectedChoice());
        if (dec == null) {
            decText.setText("");
        } else {
            List modList = GenericRPGTools.decisionToModifications((DataItemModification)mod, (Choice)origin.getChoice(mod.getConnectedChoice()), (Decision)dec);
            List modListS = modList.stream().map(mb -> (String)modConv.apply((Modification)mb)).collect(Collectors.toList());
            decText.setText(" (" + String.join((CharSequence)", ", modListS) + ")");
        }
    }
}

