/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.ResourceI18N;
import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.chargen.SelectedValueController;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.jfx.GenericDescriptionVBox;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import de.rpgframework.jfx.SelectedValuesControllerNode;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.prelle.javafx.AlertManager;
import org.prelle.javafx.AlertType;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.FlexibleApplication;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.ResponsiveControlManager;
import org.prelle.javafx.SymbolIcon;
import org.prelle.javafx.WindowMode;

public class SelectedValuesControllerTwoColumnSkin<V extends ComplexDataItemValue<?>>
extends SkinBase<SelectedValuesControllerNode<V>> {
    private static final System.Logger logger = RPGFrameworkJavaFX.logger;
    private Button btnAdd;
    private Button btnDel;
    private ListView<V> listPossible;
    private ListView<V> listSelected;
    private HBox line1Select;
    private Label lblAvailable;
    private Label lblSelected;
    private Label phAvailable;
    private Label phSelected;
    private Callback<ListView<V>, ListCell<V>> cfAvailable;
    private Callback<ListView<V>, ListCell<V>> cfSelected;
    private HBox columns;
    private VBox col1;
    private VBox col2;

    protected SelectedValuesControllerTwoColumnSkin(SelectedValuesControllerNode<V> control) {
        super(control);
        this.initComponents();
        this.initLayout();
        this.initInteractivity();
        this.setResponsiveMode(ResponsiveControlManager.getCurrentMode());
    }

    private void initComponents() {
        this.btnAdd = new Button(null, (Node)new SymbolIcon("Add"));
        this.btnDel = new Button(null, (Node)new SymbolIcon("Delete"));
        this.btnDel.setDisable(true);
        this.cfAvailable = new Callback<ListView<V>, ListCell<V>>(){

            public ListCell<V> call(ListView<V> param) {
                ListCell cell = ((SelectedValuesControllerNode)SelectedValuesControllerTwoColumnSkin.this.getSkinnable()).getCellFactory() != null ? (ListCell)((SelectedValuesControllerNode)SelectedValuesControllerTwoColumnSkin.this.getSkinnable()).getCellFactory().call(param) : SelectedValuesControllerTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> SelectedValuesControllerTwoColumnSkin.this.mouseClickedAvailable(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> SelectedValuesControllerTwoColumnSkin.this.dragDetectedAvailable(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.cfSelected = new Callback<ListView<V>, ListCell<V>>(){

            public ListCell<V> call(ListView<V> param) {
                ListCell cell = ((SelectedValuesControllerNode)SelectedValuesControllerTwoColumnSkin.this.getSkinnable()).getCellFactory() != null ? (ListCell)((SelectedValuesControllerNode)SelectedValuesControllerTwoColumnSkin.this.getSkinnable()).getCellFactory().call(param) : SelectedValuesControllerTwoColumnSkin.createDefaultCellImpl();
                cell.setOnMouseClicked(ev -> SelectedValuesControllerTwoColumnSkin.this.mouseClickedSelected(cell, (MouseEvent)ev));
                cell.setOnDragDetected(ev -> SelectedValuesControllerTwoColumnSkin.this.dragDetectedSelected(cell, (MouseEvent)ev));
                return cell;
            }
        };
        this.phAvailable = new Label();
        this.phAvailable.setWrapText(true);
        this.phSelected = new Label();
        this.phSelected.setWrapText(true);
        this.phSelected.setStyle("-fx-background-color: -fx-second-background");
        this.listPossible = new ListView();
        this.listPossible.setCellFactory(this.cfAvailable);
        this.listPossible.itemsProperty().bind(((SelectedValuesControllerNode)this.getSkinnable()).availableProperty());
        this.listPossible.setPlaceholder((Node)this.phAvailable);
        this.listPossible.setStyle("-fx-border-width: 1px; -fx-border-color: white; -fx-border-style:solid;");
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
        this.listSelected = new ListView();
        this.listSelected.setCellFactory(this.cfSelected);
        this.listSelected.itemsProperty().bind(((SelectedValuesControllerNode)this.getSkinnable()).selectedProperty());
        this.listSelected.setPlaceholder((Node)this.phSelected);
        this.listSelected.setStyle("-fx-background-color: -fx-second-background;");
        this.listSelected.setMaxHeight(Double.MAX_VALUE);
        this.lblAvailable = new Label(" " + ((SelectedValuesControllerNode)this.getSkinnable()).getAvailableHeading());
        this.lblSelected = new Label(" " + ((SelectedValuesControllerNode)this.getSkinnable()).getSelectedHeading());
        this.lblAvailable.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.lblSelected.getStyleClass().addAll((Object[])new String[]{"text-small-subheader", "list-heading"});
        this.listPossible.setStyle(((SelectedValuesControllerNode)this.getSkinnable()).getAvailableStyle());
        this.listSelected.setStyle(((SelectedValuesControllerNode)this.getSkinnable()).getSelectedStyle());
        this.listPossible.setMaxHeight(Double.MAX_VALUE);
        this.columns = new HBox();
        this.columns.setStyle("-fx-spacing: 1em;");
        this.getChildren().add((Object)this.columns);
    }

    private void initLayout() {
        this.columns.getChildren().clear();
        Region buf = new Region();
        buf.setMaxWidth(Double.MAX_VALUE);
        this.line1Select = new HBox(new Node[]{buf, this.btnAdd, this.btnDel});
        HBox.setHgrow((Node)buf, (Priority)Priority.ALWAYS);
        if (((SelectedValuesControllerNode)this.getSkinnable()).getSelectedListHead() != null) {
            this.line1Select.getChildren().add(0, (Object)((SelectedValuesControllerNode)this.getSkinnable()).getSelectedListHead());
        }
        this.col1 = new VBox(new Node[]{this.listPossible});
        this.col2 = new VBox(new Node[]{this.line1Select, this.listSelected});
        VBox.setVgrow(this.listPossible, (Priority)Priority.ALWAYS);
        VBox.setVgrow(this.listSelected, (Priority)Priority.ALWAYS);
        this.col1.setFillWidth(true);
        this.col2.setStyle("-fx-margin: 0 1em 0 0");
        HBox.setHgrow((Node)this.col1, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.col2, (Priority)Priority.ALWAYS);
        this.columns.getChildren().addAll((Object[])new Node[]{this.col1, this.col2});
        this.columns.setFillHeight(true);
        if (((SelectedValuesControllerNode)this.getSkinnable()).getShowHeadings()) {
            VBox.setMargin((Node)this.lblAvailable, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            VBox.setMargin((Node)this.lblSelected, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            this.col1.getChildren().add(0, (Object)this.lblAvailable);
            this.col2.getChildren().add(0, (Object)this.lblSelected);
        }
    }

    private void initInteractivity() {
        ((SelectedValuesControllerNode)this.getSkinnable()).showHeadingsProperty().addListener((ov, o, n) -> this.initLayout());
        ((SelectedValuesControllerNode)this.getSkinnable()).availableHeadingProperty().addListener((ov, o, n) -> this.lblAvailable.setText(" " + n));
        ((SelectedValuesControllerNode)this.getSkinnable()).selectedHeadingProperty().addListener((ov, o, n) -> this.lblSelected.setText(" " + n));
        ((SelectedValuesControllerNode)this.getSkinnable()).availableStyleProperty().addListener((ov, o, n) -> this.listPossible.setStyle(n));
        ((SelectedValuesControllerNode)this.getSkinnable()).selectedStyleProperty().addListener((ov, o, n) -> this.listSelected.setStyle(n));
        ((SelectedValuesControllerNode)this.getSkinnable()).selectedListHeadProperty().addListener((ov, o, n) -> {
            if (o != null) {
                this.line1Select.getChildren().remove(o);
            }
            if (n != null) {
                this.line1Select.getChildren().add(0, n);
            }
        });
        this.phAvailable.textProperty().bind((ObservableValue)((SelectedValuesControllerNode)this.getSkinnable()).availablePlaceholderProperty());
        this.phSelected.textProperty().bind((ObservableValue)((SelectedValuesControllerNode)this.getSkinnable()).selectedPlaceholderProperty());
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> ((SelectedValuesControllerNode)this.getSkinnable()).setShowHelpFor(n));
        this.listSelected.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> {
            this.btnDel.setDisable(n == null || !((SelectedValuesControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)n).get());
            ((SelectedValuesControllerNode)this.getSkinnable()).setShowHelpFor(n != null ? n : null);
        });
        this.listPossible.setOnDragOver(ev -> this.dragOverAvailable((DragEvent)ev));
        this.listSelected.setOnDragOver(ev -> this.dragOverSelected((DragEvent)ev));
        this.listPossible.setOnDragDropped(ev -> this.dragDroppedAvailable((DragEvent)ev));
        this.listSelected.setOnDragDropped(ev -> this.dragDroppedSelected((DragEvent)ev));
        this.btnAdd.setOnAction(ev -> this.onAddClicked());
        this.btnDel.setOnAction(ev -> this.onDeleteClicked((ComplexDataItemValue)this.listSelected.getSelectionModel().getSelectedItem()));
    }

    private static <V> ListCell<V> createDefaultCellImpl() {
        return new ListCell<V>(){

            public void updateItem(V item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof Node) {
                    this.setText(null);
                    Node currentNode = this.getGraphic();
                    Node newNode = (Node)item;
                    if (currentNode == null || !currentNode.equals(newNode)) {
                        this.setGraphic(newNode);
                    }
                } else {
                    this.setText(item == null ? "null" : item.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    private void userSelects(V toSelect) {
        logger.log(System.Logger.Level.DEBUG, "userSelects(" + String.valueOf(toSelect) + ")");
        SelectedValueController ctrl = ((SelectedValuesControllerNode)this.getSkinnable()).getController();
        Possible possible = ctrl.canBeSelected(toSelect);
        logger.log(System.Logger.Level.DEBUG, "possible = " + String.valueOf(possible));
        if (possible.get()) {
            logger.log(System.Logger.Level.DEBUG, "ctrl = " + String.valueOf(ctrl));
            logger.log(System.Logger.Level.DEBUG, "call select(option)");
            OperationResult res = ctrl.select(toSelect);
            if (res.wasSuccessful()) {
                logger.log(System.Logger.Level.INFO, "Selecting {0} was successful", toSelect);
            } else {
                logger.log(System.Logger.Level.WARNING, "Selecting {0} failed: {1}", toSelect, res.getError());
                AlertManager.showAlertAndCall((Alert.AlertType)Alert.AlertType.ERROR, (String)"Failed adding", (String)res.getError());
            }
        } else {
            logger.log(System.Logger.Level.DEBUG, "can not be Selected(" + String.valueOf(toSelect) + "): " + String.valueOf(possible.getI18NKey()));
            FlexibleApplication.getInstance().showAlertAndCall(AlertType.NOTIFICATION, "Selection failed", possible.toString());
        }
    }

    private void mouseClickedAvailable(ListCell<V> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.userSelects((ComplexDataItemValue)cell.getItem());
            ((SelectedValuesControllerNode)this.getSkinnable()).refresh();
        }
    }

    private void mouseClickedSelected(ListCell<V> cell, MouseEvent ev) {
        if (ev.getClickCount() == 2 && ((SelectedValuesControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)((ComplexDataItemValue)cell.getItem())).get()) {
            ((SelectedValuesControllerNode)this.getSkinnable()).getController().deselect((DataItemValue)((ComplexDataItemValue)cell.getItem()));
        }
    }

    protected void dragDetectedAvailable(ListCell<V> cell, MouseEvent event) {
        ComplexDataItemValue data = (ComplexDataItemValue)cell.getItem();
        if (data == null) {
            return;
        }
        logger.log(System.Logger.Level.DEBUG, "check: can be selected");
        if (!((SelectedValuesControllerNode)this.getSkinnable()).getController().canBeSelected((DataItemValue)data).get()) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = ((ComplexDataItem)data.getResolved()).getTypeString() + ":" + data.getKey();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    protected void dragDetectedSelected(ListCell<V> cell, MouseEvent event) {
        ComplexDataItemValue data = (ComplexDataItemValue)cell.getItem();
        if (data == null) {
            return;
        }
        if (!((SelectedValuesControllerNode)this.getSkinnable()).getController().canBeDeselected((DataItemValue)data).get()) {
            return;
        }
        Node source = (Node)event.getSource();
        Dragboard db = source.startDragAndDrop(TransferMode.ANY);
        ClipboardContent content = new ClipboardContent();
        String id = ((ComplexDataItem)data.getModifyable()).getTypeString() + ":" + ((ComplexDataItem)data.getModifyable()).getId();
        content.putString(id);
        db.setContent((Map)content);
        WritableImage snapshot = source.snapshot(new SnapshotParameters(), null);
        db.setDragView((Image)snapshot);
        event.consume();
    }

    private void dragOverSelected(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            String enhanceID = event.getDragboard().getString();
            ComplexDataItemValue toSelect = null;
            for (ComplexDataItemValue tmp : ((SelectedValuesControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = ((ComplexDataItem)tmp.getResolved()).getTypeString() + ":" + tmp.getKey();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null && ((SelectedValuesControllerNode)this.getSkinnable()).getController().canBeSelected(toSelect).get()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
        }
    }

    private void dragDroppedSelected(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            ComplexDataItemValue toSelect = null;
            for (ComplexDataItemValue tmp : ((SelectedValuesControllerNode)this.getSkinnable()).getController().getAvailable()) {
                String cmp = ((ComplexDataItem)tmp.getResolved()).getTypeString() + ":" + tmp.getKey();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                this.userSelects(toSelect);
                ((SelectedValuesControllerNode)this.getSkinnable()).refresh();
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void dragOverAvailable(DragEvent event) {
        Node target = (Node)event.getSource();
        if (event.getGestureSource() != target && event.getDragboard().hasString()) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
        }
    }

    private void dragDroppedAvailable(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString()) {
            String enhanceID = db.getString();
            ComplexDataItemValue toSelect = null;
            for (ComplexDataItemValue tmp : ((SelectedValuesControllerNode)this.getSkinnable()).getController().getSelected()) {
                String cmp = ((ComplexDataItem)tmp.getModifyable()).getTypeString() + ":" + ((ComplexDataItem)tmp.getModifyable()).getId();
                if (!enhanceID.equals(cmp)) continue;
                toSelect = tmp;
                break;
            }
            if (toSelect != null) {
                ((SelectedValuesControllerNode)this.getSkinnable()).getController().deselect(toSelect);
                ((SelectedValuesControllerNode)this.getSkinnable()).refresh();
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    public void setResponsiveMode(WindowMode value) {
        logger.log(System.Logger.Level.TRACE, "setResponsiveMode({0})", value);
        if (value == WindowMode.MINIMAL) {
            this.columns.getChildren().remove((Object)this.col1);
            this.col2.setStyle("-fx-min-width: 20em; -fx-max-width: 23em");
            this.btnAdd.setVisible(true);
        } else {
            this.btnAdd.setVisible(false);
            this.col2.setStyle("-fx-min-width: 23em");
            if (!this.columns.getChildren().contains((Object)this.col1)) {
                this.columns.getChildren().add(0, (Object)this.col1);
            }
        }
        this.columns.requestLayout();
    }

    private void onAddClicked() {
        ComplexDataItemValue selected;
        logger.log(System.Logger.Level.WARNING, "Add button clicked");
        GenericDescriptionVBox descr = new GenericDescriptionVBox(((SelectedValuesControllerNode)this.getSkinnable()).getRequirementResolver(), ((SelectedValuesControllerNode)this.getSkinnable()).getModificationResolver());
        descr.setStyle("-fx-min-height: 5em");
        VBox pane = new VBox(10.0, new Node[]{this.col1, descr});
        VBox.setVgrow((Node)this.col1, (Priority)Priority.ALWAYS);
        VBox.setVgrow(descr, (Priority)Priority.SOMETIMES);
        this.listPossible.getSelectionModel().selectedItemProperty().addListener((ov, o, n) -> descr.setData(n));
        ManagedDialog dialog = new ManagedDialog(ResourceI18N.get((ResourceBundle)RPGFrameworkJFXConstants.UI, (String)"label.selectOne"), (Node)pane, new CloseType[]{CloseType.CANCEL, CloseType.OK});
        CloseType closed = FlexibleApplication.getInstance().showAndWait((Node)dialog);
        logger.log(System.Logger.Level.WARNING, "Closed with " + String.valueOf(closed));
        if (closed == CloseType.OK && (selected = (ComplexDataItemValue)this.listPossible.getSelectionModel().getSelectedItem()) != null) {
            this.userSelects(selected);
        }
    }

    private void onDeleteClicked(V selected) {
        logger.log(System.Logger.Level.DEBUG, "Delete button clicked for " + String.valueOf(selected));
        boolean success = ((SelectedValuesControllerNode)this.getSkinnable()).getController().deselect(selected);
        if (success) {
            this.listSelected.getItems().remove(selected);
        }
    }
}

