/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx;

import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationChoice;
import de.rpgframework.genericrpg.modification.ValueModification;
import de.rpgframework.jfx.RPGFrameworkJFXConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.prelle.javafx.AlertType;
import org.prelle.javafx.CloseType;
import org.prelle.javafx.ManagedDialog;
import org.prelle.javafx.NavigButtonControl;

public class UserDistributePointsDialog
extends ManagedDialog
implements EventHandler<ActionEvent> {
    public static final System.Logger logger = System.getLogger("rpgframework.jfx");
    private static PropertyResourceBundle RES = RPGFrameworkJFXConstants.UI;
    private ModificationChoice choice;
    Map<Modification, SkillField> mapping;
    Map<ButtonBase, ValueModification> incMapping;
    Map<ButtonBase, ValueModification> decMapping;
    private int pointsLeft = 0;
    private Label pointsLeft_l;
    private NavigButtonControl buttonControl = new NavigButtonControl();

    public UserDistributePointsDialog(String choiceReason, ModificationChoice choice) {
        super(null, null, new CloseType[]{CloseType.OK});
        this.buttonControl.setDisabled(CloseType.OK, true);
        this.choice = choice;
        this.mapping = new HashMap<Modification, SkillField>();
        this.incMapping = new HashMap<ButtonBase, ValueModification>();
        this.decMapping = new HashMap<ButtonBase, ValueModification>();
        this.initComponents(choiceReason);
    }

    private void initComponents(String choiceReason) {
        Label select = new Label(RES.getString("wizard.selectMod.distribute"));
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(4.0));
        grid.setVgap(7.0);
        grid.setHgap(5.0);
        this.pointsLeft_l = new Label(String.valueOf(this.pointsLeft));
        this.pointsLeft_l.setStyle("-fx-font-size: 400%");
        this.pointsLeft_l.getStyleClass().add((Object)"wizard-context");
        int y = 0;
        for (Modification tmp : this.choice.getModificiations()) {
            Label tmpL = new Label(tmp.toString());
            if (tmp instanceof ValueModification) {
                ValueModification mod = (ValueModification)tmp;
                tmpL.setText(mod.getResolvedKey().toString());
                mod.setValue(0);
            }
            SkillField field = new SkillField();
            field.dec.setOnAction((EventHandler)this);
            field.inc.setOnAction((EventHandler)this);
            field.setText("0");
            ValueModification mod = (ValueModification)tmp;
            this.mapping.put((Modification)mod, field);
            this.incMapping.put((ButtonBase)field.inc, mod);
            this.decMapping.put((ButtonBase)field.dec, mod);
            grid.add((Node)tmpL, 1, y);
            grid.add((Node)field, 2, y);
            ++y;
        }
        grid.add((Node)this.pointsLeft_l, 0, 0, 1, y);
        GridPane.setMargin((Node)this.pointsLeft_l, (Insets)new Insets(0.0, 20.0, 0.0, 0.0));
        VBox content = new VBox(10.0);
        content.setPadding(new Insets(5.0));
        content.getStyleClass().add((Object)"wizard-content");
        content.getChildren().addAll((Object[])new Node[]{select, grid});
        this.setTitle(choiceReason);
        this.setContent((Node)content);
    }

    public Modification[] getChoice() {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Map.Entry<Modification, SkillField> entry : this.mapping.entrySet()) {
            if (entry.getValue().getInt() <= 0) continue;
            mods.add(entry.getKey());
        }
        Modification[] ret = new Modification[mods.size()];
        mods.toArray(ret);
        return ret;
    }

    public void handle(ActionEvent event) {
        Button key = (Button)event.getSource();
        ValueModification mod = null;
        if (this.incMapping.containsKey(key)) {
            mod = this.incMapping.get(key);
            SkillField field = this.mapping.get(mod);
            if (this.pointsLeft > 0) {
                mod.setValue(mod.getValue() + 1);
                --this.pointsLeft;
            } else {
                this.getScreenManager().showAlertAndCall(AlertType.ERROR, "Internal Error", "Ups, da ist was schief gelaufen.\nUserDistributePointsDialog does not support " + String.valueOf(mod.getClass()));
            }
        } else {
            mod = this.decMapping.get(key);
            SkillField field = this.mapping.get(mod);
            if (field.getInt() > 0) {
                mod.setValue(mod.getValue() - 1);
                field.setText(String.valueOf(mod.getValue()));
                ++this.pointsLeft;
            } else {
                this.getScreenManager().showAlertAndCall(AlertType.ERROR, "Internal Error", "Ups, da ist was schief gelaufen.\nUserDistributePointsDialog does not support " + String.valueOf(mod.getClass()));
            }
        }
        this.pointsLeft_l.setText(String.valueOf(this.pointsLeft));
        this.buttonControl.setDisabled(CloseType.OK, this.pointsLeft > 0);
    }

    private class SkillField
    extends HBox {
        public Button dec = new Button("\ue0c6");
        public Button inc = new Button("\ue0c5");
        private TextField value;

        public SkillField() {
            this.inc.getStyleClass().add((Object)"mini-button");
            this.dec.getStyleClass().add((Object)"mini-button");
            this.value = new TextField();
            this.value.setPrefColumnCount(1);
            this.value.setEditable(false);
            this.value.setFocusTraversable(false);
            this.getChildren().addAll((Object[])new Node[]{this.dec, this.value, this.inc});
            this.setStyle("-fx-min-width: 7.5em");
        }

        public SkillField(String text) {
            this.inc.getStyleClass().add((Object)"mini-button");
            this.dec.getStyleClass().add((Object)"mini-button");
            this.value = new TextField();
            this.value.setPrefColumnCount(text.length());
            this.value.setText(text);
            this.value.setEditable(false);
            this.value.setFocusTraversable(false);
            this.getChildren().addAll((Object[])new Node[]{this.dec, this.value, this.inc});
            this.setStyle("-fx-min-width: 7.5em");
        }

        public void setText(String txt) {
            this.value.setText(txt);
        }

        public int getInt() {
            try {
                return Integer.parseInt(this.value.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

