/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.cells;

import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.NumericalValueController;
import de.rpgframework.genericrpg.chargen.ComplexDataItemController;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.jfx.cells.ComplexDataItemValueListCell;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.control.Label;

public abstract class ACarriedItemListCell<T extends PieceOfGear<?, ?, ?, ?>>
extends ComplexDataItemValueListCell<T, CarriedItem<T>> {
    protected Label lbValue;

    public ACarriedItemListCell(Supplier<ComplexDataItemController<T, CarriedItem<T>>> equipCtrl) {
        super(equipCtrl);
        this.addAction(new ComplexDataItemValueListCell.CellAction(this, "Edit", "\ue1c2", "tooltip", (act, item) -> this.editClicked((CarriedItem<T>)item)));
        this.lbValue = new Label();
        this.addExtraActionLine((Node)this.lbValue);
        this.setStyle("-fx-max-width: 22em");
    }

    public abstract int getSinglePrice(CarriedItem<T> var1);

    public abstract String getModificationSourceString(Object var1);

    @Override
    public void updateItem(CarriedItem<T> item, boolean empty) {
        super.updateItem(item, empty);
        if (item != null) {
            int price = this.getSinglePrice(item) * (item.getCount() > 1 ? item.getCount() : 1);
            this.lbValue.setText("$" + price);
            if (((PieceOfGear)item.getResolved()).isCountable() || item.getCount() > 1) {
                this.lblVal.setText(String.valueOf(item.getCount()));
                this.largeDecInc.setVisible(true);
                this.largeDecInc.setManaged(true);
                this.btnDec.setDisable(!((NumericalValueController)this.controlProvider.get()).canBeDecreased(item).get());
                this.btnInc.setDisable(!((NumericalValueController)this.controlProvider.get()).canBeIncreased(item).get());
            } else {
                this.largeDecInc.setVisible(false);
                this.largeDecInc.setManaged(false);
            }
        }
    }

    protected OperationResult<CarriedItem<T>> editClicked(CarriedItem<T> ref) {
        logger.log(System.Logger.Level.WARNING, "TODO: editClicked for " + String.valueOf(((Object)((Object)this)).getClass()));
        BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{0, "The developer forgot to support editing '" + ((PieceOfGear)((CarriedItem)this.getItem()).getResolved()).getTypeString() + "' or hide the edit button :)"});
        return new OperationResult(ref);
    }
}

