/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.jfx.fxml;

import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.jfx.RPGFrameworkJavaFX;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Function;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.text.TextFlow;

public class GenericDescriptionBoxController {
    @FXML
    private Label descTitle;
    @FXML
    private Label descSources;
    @FXML
    private TextFlow description;
    @FXML
    private Label hdRequires;
    @FXML
    private Label requires;

    @FXML
    void initialize() {
        assert (this.descTitle != null) : "fx:id=\"descTitle\" was not injected: check your FXML file 'GenericDescriptionBox.fxml'.";
        assert (this.descSources != null) : "fx:id=\"descSources\" was not injected: check your FXML file 'GenericDescriptionBox.fxml'.";
        assert (this.description != null) : "fx:id=\"description\" was not injected: check your FXML file 'GenericDescriptionBox.fxml'.";
    }

    public void setData(DataItem data, Function<Requirement, String> requirementResolver) {
        if (this.descTitle != null) {
            this.descTitle.setText(data.getName());
        }
        if (this.descSources != null) {
            this.descSources.setText(RPGFrameworkJavaFX.createSourceText(data));
        }
        this.descTitle.setText(data.getName());
        RPGFrameworkJavaFX.parseMarkupAndFillTextFlow(this.description, data.getDescription(Locale.getDefault()));
        if (data instanceof ComplexDataItem && !((ComplexDataItem)data).getRequirements().isEmpty()) {
            this.hdRequires.setVisible(true);
            this.hdRequires.setManaged(true);
            this.requires.setVisible(true);
            this.requires.setManaged(true);
            ArrayList<String> list = new ArrayList<String>();
            for (Requirement req : ((ComplexDataItem)data).getRequirements()) {
                list.add(requirementResolver.apply(req));
            }
            this.requires.setText(String.join((CharSequence)", ", list));
        } else {
            this.hdRequires.setVisible(false);
            this.hdRequires.setManaged(false);
            this.requires.setVisible(false);
            this.requires.setManaged(false);
        }
    }
}

